/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook;

import com.alibaba.cloud.ai.graph.KeyStrategy;
import com.alibaba.cloud.ai.graph.agent.Prioritized;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.hook.AgentHook;
import com.alibaba.cloud.ai.graph.agent.hook.HookPosition;
import com.alibaba.cloud.ai.graph.agent.hook.HookPositions;
import com.alibaba.cloud.ai.graph.agent.hook.JumpTo;
import com.alibaba.cloud.ai.graph.agent.hook.ModelHook;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolInterceptor;
import java.util.List;
import java.util.Map;
import org.springframework.ai.tool.ToolCallback;

public interface Hook
extends Prioritized {
    public String getName();

    public void setAgentName(String var1);

    public String getAgentName();

    public ReactAgent getAgent();

    public void setAgent(ReactAgent var1);

    default public List<ModelInterceptor> getModelInterceptors() {
        return List.of();
    }

    default public List<ToolInterceptor> getToolInterceptors() {
        return List.of();
    }

    default public List<ToolCallback> getTools() {
        return List.of();
    }

    default public List<JumpTo> canJumpTo() {
        return List.of();
    }

    default public Map<String, KeyStrategy> getKeyStrategys() {
        return Map.of();
    }

    default public HookPosition[] getHookPositions() {
        HookPositions annotation = this.getClass().getAnnotation(HookPositions.class);
        if (annotation != null) {
            return annotation.value();
        }
        if (this instanceof AgentHook) {
            return new HookPosition[]{HookPosition.BEFORE_AGENT, HookPosition.AFTER_AGENT};
        }
        if (this instanceof ModelHook) {
            return new HookPosition[]{HookPosition.BEFORE_MODEL, HookPosition.AFTER_MODEL};
        }
        return new HookPosition[0];
    }

    public static String getFullHookName(Hook hook) {
        return "_AGENT_HOOK_" + hook.getName();
    }
}

