/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import com.alibaba.cloud.ai.graph.action.AsyncMultiCommandAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeActionWithConfig;
import com.alibaba.cloud.ai.graph.action.MultiCommandAction;
import com.alibaba.cloud.ai.graph.action.NodeActionWithConfig;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.MainAgentNodeAction;
import com.alibaba.cloud.ai.graph.agent.flow.node.MainAgentToSupervisorEdgeAction;
import com.alibaba.cloud.ai.graph.agent.flow.node.SupervisorNodeFromState;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.AbstractFlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import java.util.HashMap;
import java.util.Map;

public class SupervisorGraphBuildingStrategy
extends AbstractFlowGraphBuildingStrategy {
    @Override
    protected void buildCoreGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        this.validateSupervisorConfig(config);
        Agent rootAgent = this.getRootAgent();
        Agent mainAgent = config.getMainAgent();
        if (!(mainAgent instanceof ReactAgent)) {
            throw new IllegalArgumentException("Supervisor mainAgent must be a ReactAgent, got: " + (mainAgent != null ? mainAgent.getClass().getName() : "null"));
        }
        ReactAgent reactAgent = (ReactAgent)mainAgent;
        this.graph.addNode(rootAgent.name(), AsyncNodeActionWithConfig.node_async((NodeActionWithConfig)new MainAgentNodeAction(reactAgent, config.getSubAgents())));
        HashMap<String, String> edgeRoutingMap = new HashMap<String, String>();
        for (Agent subAgent : config.getSubAgents()) {
            FlowGraphBuildingStrategy.addSubAgentNode(subAgent, this.graph);
            edgeRoutingMap.put(subAgent.name(), subAgent.name());
            this.graph.addEdge(subAgent.name(), this.entryNode);
        }
        this.buildCoreGraphWithMainAgent(config, rootAgent, edgeRoutingMap);
    }

    private void buildCoreGraphWithMainAgent(FlowGraphBuilder.FlowGraphConfig config, Agent rootAgent, Map<String, String> edgeRoutingMap) throws GraphStateException {
        String mainAgentNodeName = rootAgent.name();
        String supervisorNodeName = rootAgent.name() + "_supervisor";
        String routingKey = config.getCustomProperty("supervisor.routingKey") != null ? String.valueOf(config.getCustomProperty("supervisor.routingKey")) : "supervisor_next";
        this.graph.addNode(supervisorNodeName, AsyncNodeAction.node_async(state -> Map.of()));
        MainAgentToSupervisorEdgeAction mainAgentToSupervisor = new MainAgentToSupervisorEdgeAction(routingKey, supervisorNodeName);
        HashMap<Object, Object> mainAgentEdgeMap = new HashMap<Object, Object>();
        mainAgentEdgeMap.put("__END__", this.exitNode);
        mainAgentEdgeMap.put(supervisorNodeName, supervisorNodeName);
        this.graph.addConditionalEdges(mainAgentNodeName, (AsyncEdgeAction)mainAgentToSupervisor, mainAgentEdgeMap);
        SupervisorNodeFromState supervisorNodeFromState = new SupervisorNodeFromState(routingKey, config.getSubAgents(), this.entryNode);
        this.graph.addParallelConditionalEdges(supervisorNodeName, AsyncMultiCommandAction.node_async((MultiCommandAction)supervisorNodeFromState), edgeRoutingMap);
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.SUPERVISOR.getType();
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        super.validateConfig(config);
        this.validateSupervisorConfig(config);
    }

    private void validateSupervisorConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config.getSubAgents() == null || config.getSubAgents().isEmpty()) {
            throw new IllegalArgumentException("Supervisor flow requires at least one sub-agent");
        }
        if (config.getMainAgent() == null) {
            throw new IllegalArgumentException("Supervisor flow requires mainAgent (ReactAgent)");
        }
        if (!(config.getRootAgent() instanceof FlowAgent)) {
            throw new IllegalArgumentException("Supervisor flow requires root agent to be a FlowAgent");
        }
    }
}

