/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.AbstractFlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;

public class SequentialGraphBuildingStrategy
extends AbstractFlowGraphBuildingStrategy {
    @Override
    protected void buildCoreGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        this.validateSequentialConfig(config);
        String sequentialStartNode = this.getRootAgent().name();
        this.graph.addNode(sequentialStartNode, AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        if (!this.beforeModelHooks.isEmpty()) {
            this.connectBeforeModelHookEdges(this.graph, sequentialStartNode, this.beforeModelHooks);
        }
        Agent currentAgent = this.getRootAgent();
        for (Agent subAgent : config.getSubAgents()) {
            FlowGraphBuildingStrategy.addSubAgentNode(subAgent, this.graph);
            this.graph.addEdge(currentAgent.name(), subAgent.name());
            currentAgent = subAgent;
        }
        String finalNode = !this.afterModelHooks.isEmpty() ? this.connectAfterModelHookEdges(this.graph, currentAgent.name(), this.afterModelHooks) : currentAgent.name();
        this.graph.addEdge(finalNode, this.exitNode);
    }

    @Override
    protected void connectBeforeModelHooks() throws GraphStateException {
    }

    @Override
    protected void connectAfterModelHooks() throws GraphStateException {
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.SEQUENTIAL.getType();
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        super.validateConfig(config);
        this.validateSequentialConfig(config);
    }

    private void validateSequentialConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config.getSubAgents() == null || config.getSubAgents().isEmpty()) {
            throw new IllegalArgumentException("Sequential flow requires at least one sub-agent");
        }
        if (!(config.getRootAgent() instanceof FlowAgent)) {
            throw new IllegalArgumentException("Sequential flow requires root agent to be a FlowAgent");
        }
    }
}

