/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.action.AsyncMultiCommandAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.MultiCommandAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.RoutingNode;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.AbstractFlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import java.util.HashMap;
import java.util.Map;

public class RoutingGraphBuildingStrategy
extends AbstractFlowGraphBuildingStrategy {
    @Override
    protected void buildCoreGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        this.validateRoutingConfig(config);
        this.graph.addNode(this.rootAgent.name(), AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        String routingNodeName = this.rootAgent.name() + "_routing";
        this.graph.addNode(routingNodeName, AsyncNodeAction.node_async(state -> Map.of()));
        Object firstBeforeModelNode = routingNodeName;
        if (!this.beforeModelHooks.isEmpty()) {
            firstBeforeModelNode = this.connectBeforeModelHookEdges(this.graph, routingNodeName, this.beforeModelHooks);
        }
        this.graph.addEdge(this.rootAgent.name(), (String)firstBeforeModelNode);
        Object routingExitNode = routingNodeName;
        if (!this.afterModelHooks.isEmpty()) {
            routingExitNode = this.connectAfterModelHookEdges(this.graph, routingNodeName, this.afterModelHooks);
        }
        HashMap<String, String> edgeRoutingMap = new HashMap<String, String>();
        for (Agent subAgent : config.getSubAgents()) {
            FlowGraphBuildingStrategy.addSubAgentNode(subAgent, this.graph);
            edgeRoutingMap.put(subAgent.name(), subAgent.name());
            this.graph.addEdge(subAgent.name(), this.exitNode);
        }
        RoutingNode routingNode = new RoutingNode(config.getChatModel(), this.rootAgent, config.getSubAgents());
        this.graph.addParallelConditionalEdges((String)routingExitNode, AsyncMultiCommandAction.node_async((MultiCommandAction)routingNode), edgeRoutingMap);
    }

    @Override
    protected void connectBeforeModelHooks() throws GraphStateException {
    }

    @Override
    protected void connectAfterModelHooks() throws GraphStateException {
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.ROUTING.getType();
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        super.validateConfig(config);
        this.validateRoutingConfig(config);
    }

    private void validateRoutingConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config.getSubAgents() == null || config.getSubAgents().isEmpty()) {
            throw new IllegalArgumentException("Routing flow requires at least one sub-agent");
        }
        if (config.getChatModel() == null) {
            throw new IllegalArgumentException("Routing flow requires a ChatModel for decision making");
        }
        if (!(config.getRootAgent() instanceof FlowAgent)) {
            throw new IllegalArgumentException("Routing flow requires root agent to be a FlowAgent");
        }
    }
}

