/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.ParallelAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.EnhancedParallelResultAggregator;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.AbstractFlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import java.util.ArrayList;

public class ParallelGraphBuildingStrategy
extends AbstractFlowGraphBuildingStrategy {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildCoreGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        void var8_12;
        this.validateParallelConfig(config);
        ParallelAgent parallelRootAgent = (ParallelAgent)this.getRootAgent();
        String aggregatorNodeName = this.getRootAgent().name() + "_aggregator";
        Object mergeStrategy = config.getCustomProperty("mergeStrategy");
        Integer maxConcurrency = (Integer)config.getCustomProperty("maxConcurrency");
        ArrayList<BaseAgent> baseAgentList = new ArrayList<BaseAgent>(config.getSubAgents().size());
        for (Agent agent : config.getSubAgents()) {
            baseAgentList.add((BaseAgent)agent);
        }
        this.graph.addNode(aggregatorNodeName, AsyncNodeAction.node_async((NodeAction)new EnhancedParallelResultAggregator(parallelRootAgent.mergeOutputKey(), baseAgentList, mergeStrategy, maxConcurrency)));
        String parallelStartNode = this.getRootAgent().name();
        this.graph.addNode(parallelStartNode, AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        if (!this.beforeModelHooks.isEmpty()) {
            this.connectBeforeModelHookEdges(this.graph, parallelStartNode, this.beforeModelHooks);
        }
        for (Agent subAgent : config.getSubAgents()) {
            FlowGraphBuildingStrategy.addSubAgentNode(subAgent, this.graph);
            this.graph.addEdge(parallelStartNode, subAgent.name());
            this.graph.addEdge(subAgent.name(), aggregatorNodeName);
        }
        String string = aggregatorNodeName;
        if (!this.afterModelHooks.isEmpty()) {
            String string2 = this.connectAfterModelHookEdges(this.graph, aggregatorNodeName, this.afterModelHooks);
        }
        this.graph.addEdge((String)var8_12, this.exitNode);
    }

    @Override
    protected void connectBeforeModelHooks() throws GraphStateException {
    }

    @Override
    protected void connectAfterModelHooks() throws GraphStateException {
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.PARALLEL.getType();
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        super.validateConfig(config);
        this.validateParallelConfig(config);
    }

    private void validateParallelConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config.getSubAgents() == null || config.getSubAgents().isEmpty()) {
            throw new IllegalArgumentException("Parallel flow requires at least one sub-agent");
        }
        if (config.getSubAgents().size() < 2) {
            throw new IllegalArgumentException("Parallel flow requires at least 2 sub-agents for meaningful parallel execution");
        }
        if (!(config.getRootAgent() instanceof FlowAgent)) {
            throw new IllegalArgumentException("Parallel flow requires root agent to be a FlowAgent");
        }
        Integer maxConcurrency = (Integer)config.getCustomProperty("maxConcurrency");
        if (maxConcurrency != null && maxConcurrency < 1) {
            throw new IllegalArgumentException("maxConcurrency must be at least 1, but got: " + maxConcurrency);
        }
    }
}

