/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.KeyStrategy;
import com.alibaba.cloud.ai.graph.KeyStrategyFactory;
import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.loop.LoopStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.AbstractFlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.state.strategy.ReplaceStrategy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LoopGraphBuildingStrategy
extends AbstractFlowGraphBuildingStrategy {
    @Override
    protected void buildCoreGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        Agent rootAgent = this.getRootAgent();
        LoopStrategy loopStrategy = (LoopStrategy)config.getCustomProperty("loopStrategy");
        Agent subAgent = config.getSubAgents().get(0);
        this.graph.addNode(rootAgent.name(), AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        this.graph.addNode(loopStrategy.loopInitNodeName(), AsyncNodeAction.node_async(loopStrategy::loopInit));
        this.graph.addEdge(rootAgent.name(), loopStrategy.loopInitNodeName());
        this.graph.addNode(loopStrategy.loopDispatchNodeName(), AsyncNodeAction.node_async(loopStrategy::loopDispatch));
        this.graph.addEdge(loopStrategy.loopInitNodeName(), loopStrategy.loopDispatchNodeName());
        this.graph.addNode(subAgent.name(), subAgent.getGraph());
        String loopEntryNode = !this.beforeModelHooks.isEmpty() ? this.connectBeforeModelHookEdges(this.graph, subAgent.name(), this.beforeModelHooks) : subAgent.name();
        String afterSubAgentNode = !this.afterModelHooks.isEmpty() ? this.connectAfterModelHookEdges(this.graph, subAgent.name(), this.afterModelHooks) : subAgent.name();
        this.graph.addEdge(afterSubAgentNode, loopStrategy.loopDispatchNodeName());
        this.graph.addConditionalEdges(loopStrategy.loopDispatchNodeName(), AsyncEdgeAction.edge_async(state -> {
            Boolean shouldContinue = (Boolean)state.value(loopStrategy.loopFlagKey(), (Object)false);
            return shouldContinue != false ? "continue" : "break";
        }), Map.of("continue", loopEntryNode, "break", this.exitNode));
    }

    @Override
    protected void connectBeforeAgentHooks() throws GraphStateException {
        if (!this.beforeAgentHooks.isEmpty()) {
            this.chainBeforeAgentHooks(this.graph, this.beforeAgentHooks, this.getRootAgent().name());
        }
    }

    @Override
    protected void connectBeforeModelHooks() throws GraphStateException {
    }

    @Override
    protected void connectAfterModelHooks() throws GraphStateException {
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.LOOP.getType();
    }

    @Override
    public KeyStrategyFactory generateKeyStrategyFactory(FlowGraphBuilder.FlowGraphConfig config) {
        KeyStrategyFactory baseFactory = super.generateKeyStrategyFactory(config);
        LoopStrategy loopStrategy = (LoopStrategy)config.getCustomProperty("loopStrategy");
        return () -> {
            Map baseStrategies = baseFactory.apply();
            Map<String, KeyStrategy> loopStrategies = loopStrategy.tempKeys().stream().collect(Collectors.toMap(key -> key, key -> new ReplaceStrategy(), (k1, k2) -> k1));
            return Stream.of(baseStrategies, loopStrategies).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k1));
        };
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        super.validateConfig(config);
        Object loopStrategyObj = config.getCustomProperty("loopStrategy");
        if (!(loopStrategyObj instanceof LoopStrategy)) {
            throw new IllegalArgumentException("Loop flow requires a valid LoopStrategy. Got: " + (loopStrategyObj != null ? loopStrategyObj.getClass().getName() : "null"));
        }
        List<Agent> subAgents = config.getSubAgents();
        if (subAgents == null || subAgents.size() != 1) {
            throw new IllegalArgumentException("Loop flow requires exactly one sub-agent. Got: " + (subAgents != null ? subAgents.size() : 0));
        }
    }
}

