/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.ConditionalGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.LoopGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.ParallelGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.RoutingGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.SequentialGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.SupervisorGraphBuildingStrategy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class FlowGraphBuildingStrategyRegistry {
    private static final FlowGraphBuildingStrategyRegistry INSTANCE = new FlowGraphBuildingStrategyRegistry();
    private final Map<String, Supplier<FlowGraphBuildingStrategy>> strategyFactories = new ConcurrentHashMap<String, Supplier<FlowGraphBuildingStrategy>>();

    private FlowGraphBuildingStrategyRegistry() {
        this.registerDefaultStrategies();
    }

    public static FlowGraphBuildingStrategyRegistry getInstance() {
        return INSTANCE;
    }

    public void registerStrategy(FlowGraphBuildingStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("Strategy cannot be null");
        }
        String type = strategy.getStrategyType();
        if (type == null || type.trim().isEmpty()) {
            throw new IllegalArgumentException("Strategy type cannot be null or empty");
        }
        if (this.strategyFactories.containsKey(type)) {
            throw new IllegalArgumentException("Strategy type '" + type + "' is already registered");
        }
        this.strategyFactories.put(type, () -> strategy);
    }

    public void registerStrategy(String type, Supplier<FlowGraphBuildingStrategy> factory) {
        if (type == null || type.trim().isEmpty()) {
            throw new IllegalArgumentException("Strategy type cannot be null or empty");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Strategy factory cannot be null");
        }
        if (this.strategyFactories.containsKey(type)) {
            throw new IllegalArgumentException("Strategy type '" + type + "' is already registered");
        }
        this.strategyFactories.put(type, factory);
    }

    public FlowGraphBuildingStrategy createStrategy(String type) {
        if (type == null || type.trim().isEmpty()) {
            throw new IllegalArgumentException("Strategy type cannot be null or empty");
        }
        Supplier<FlowGraphBuildingStrategy> factory = this.strategyFactories.get(type);
        if (factory == null) {
            throw new IllegalArgumentException("No strategy registered for type: " + type);
        }
        return factory.get();
    }

    public FlowGraphBuildingStrategy getStrategy(String type) {
        return this.createStrategy(type);
    }

    public boolean hasStrategy(String type) {
        return type != null && this.strategyFactories.containsKey(type);
    }

    public Set<String> getRegisteredTypes() {
        return Set.copyOf(this.strategyFactories.keySet());
    }

    public Supplier<FlowGraphBuildingStrategy> unregisterStrategy(String type) {
        return this.strategyFactories.remove(type);
    }

    public void clear() {
        this.strategyFactories.clear();
    }

    private void registerDefaultStrategies() {
        this.registerStrategy(FlowAgentEnum.SEQUENTIAL.getType(), SequentialGraphBuildingStrategy::new);
        this.registerStrategy(FlowAgentEnum.ROUTING.getType(), RoutingGraphBuildingStrategy::new);
        this.registerStrategy(FlowAgentEnum.PARALLEL.getType(), ParallelGraphBuildingStrategy::new);
        this.registerStrategy(FlowAgentEnum.CONDITIONAL.getType(), ConditionalGraphBuildingStrategy::new);
        this.registerStrategy(FlowAgentEnum.LOOP.getType(), LoopGraphBuildingStrategy::new);
        this.registerStrategy(FlowAgentEnum.SUPERVISOR.getType(), SupervisorGraphBuildingStrategy::new);
    }
}

