/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.ConditionEvaluator;
import com.alibaba.cloud.ai.graph.agent.flow.node.ConditionEvaluatorAction;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.AbstractFlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import java.util.HashMap;
import java.util.Map;

public class ConditionalGraphBuildingStrategy
extends AbstractFlowGraphBuildingStrategy {
    @Override
    protected void buildCoreGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        Object convergencePoint;
        this.validateConditionalConfig(config);
        Agent rootAgent = this.getRootAgent();
        String conditionalStartNode = rootAgent.name();
        this.graph.addNode(conditionalStartNode, AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        if (!this.beforeModelHooks.isEmpty()) {
            this.connectBeforeModelHookEdges(this.graph, conditionalStartNode, this.beforeModelHooks);
        }
        String conditionNodeName = rootAgent.name() + "_condition";
        this.graph.addNode(conditionNodeName, AsyncNodeAction.node_async((NodeAction)new ConditionEvaluator()));
        this.graph.addEdge(rootAgent.name(), conditionNodeName);
        HashMap<String, String> conditionRoutingMap = new HashMap<String, String>();
        for (Map.Entry<String, Agent> entry : config.getConditionalAgents().entrySet()) {
            String condition = entry.getKey();
            Agent subAgent = entry.getValue();
            FlowGraphBuildingStrategy.addSubAgentNode(subAgent, this.graph);
            conditionRoutingMap.put(condition, subAgent.name());
        }
        if (!this.afterModelHooks.isEmpty()) {
            Object prevHook = convergencePoint = Hook.getFullHookName((Hook)this.afterModelHooks.get(0)) + ".afterModel";
            for (int i = 1; i < this.afterModelHooks.size(); ++i) {
                String currentHook = Hook.getFullHookName((Hook)this.afterModelHooks.get(i)) + ".afterModel";
                this.graph.addEdge((String)prevHook, currentHook);
                prevHook = currentHook;
            }
            this.graph.addEdge((String)prevHook, this.exitNode);
        } else {
            convergencePoint = this.exitNode;
        }
        for (Agent subAgent : config.getConditionalAgents().values()) {
            this.graph.addEdge(subAgent.name(), (String)convergencePoint);
        }
        conditionRoutingMap.put("default", this.exitNode);
        this.graph.addConditionalEdges(conditionNodeName, (AsyncEdgeAction)new ConditionEvaluatorAction(), conditionRoutingMap);
    }

    @Override
    protected void connectBeforeModelHooks() throws GraphStateException {
    }

    @Override
    protected void connectAfterModelHooks() throws GraphStateException {
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.CONDITIONAL.getType();
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        super.validateConfig(config);
        this.validateConditionalConfig(config);
    }

    private void validateConditionalConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config.getConditionalAgents() == null || config.getConditionalAgents().isEmpty()) {
            throw new IllegalArgumentException("Conditional flow requires at least one conditional agent mapping");
        }
        if (!(config.getRootAgent() instanceof FlowAgent)) {
            throw new IllegalArgumentException("Conditional flow requires root agent to be a FlowAgent");
        }
        for (String condition : config.getConditionalAgents().keySet()) {
            if (condition != null && !condition.trim().isEmpty()) continue;
            throw new IllegalArgumentException("Condition keys cannot be null or empty");
        }
    }
}

