/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.action.MultiCommand;
import com.alibaba.cloud.ai.graph.action.MultiCommandAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorNodeFromState
implements MultiCommandAction {
    public static final Logger logger = LoggerFactory.getLogger(SupervisorNodeFromState.class);
    public static final String SUPERVISOR_NEXT_KEY = "supervisor_next";
    private final String routingKey;
    private final List<Agent> subAgents;
    private final String entryNode;

    public SupervisorNodeFromState(String routingKey, List<Agent> subAgents, String entryNode) {
        this.routingKey = routingKey != null ? routingKey : SUPERVISOR_NEXT_KEY;
        this.subAgents = subAgents != null ? subAgents : List.of();
        this.entryNode = entryNode;
    }

    public SupervisorNodeFromState(List<Agent> subAgents) {
        this(SUPERVISOR_NEXT_KEY, subAgents, "");
    }

    private static List<String> toAgentNames(Object value) {
        if (value == null) {
            return List.of();
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.stream().filter(e -> e != null && !"FINISH".equalsIgnoreCase(String.valueOf(e).trim())).map(e -> String.valueOf(e).trim()).collect(Collectors.toList());
        }
        return List.of();
    }

    public MultiCommand apply(OverAllState state, RunnableConfig config) throws Exception {
        Object value = state.value(this.routingKey).orElse(null);
        List<String> agentNames = SupervisorNodeFromState.toAgentNames(value);
        List validNames = agentNames.stream().filter(name -> this.subAgents.stream().anyMatch(a -> a.name().equals(name))).collect(Collectors.toList());
        logger.info("SupervisorNodeFromState: routingKey='{}', value='{}', parsed agentNames={}, validAgentNames={}", new Object[]{this.routingKey, value, agentNames, validNames});
        if (validNames.isEmpty()) {
            logger.error("SupervisorNodeFromState: no valid sub-agent names in state key '{}', value: {}", (Object)this.routingKey, value);
            return new MultiCommand(List.of(this.entryNode), Map.of());
        }
        return new MultiCommand(validNames, Map.of());
    }
}

