/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.util.StringUtils;

public class MainAgentToSupervisorEdgeAction
implements AsyncEdgeAction {
    public static final Logger logger = LoggerFactory.getLogger(MainAgentToSupervisorEdgeAction.class);
    private final String routingKey;
    private final String supervisorNodeName;

    public MainAgentToSupervisorEdgeAction(String routingKey, String supervisorNodeName) {
        this.routingKey = routingKey != null ? routingKey : "supervisor_next";
        this.supervisorNodeName = supervisorNodeName;
    }

    public MainAgentToSupervisorEdgeAction(String supervisorNodeName) {
        this("supervisor_next", supervisorNodeName);
    }

    private static boolean isFinishOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)value;
            String text = assistantMessage.getText();
            if (!StringUtils.hasText((String)text)) {
                return true;
            }
            return MainAgentToSupervisorEdgeAction.isFinishOrEmptyText(text.trim());
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.isEmpty() || list.stream().allMatch(e -> e == null || "FINISH".equalsIgnoreCase(String.valueOf(e).trim()));
        }
        String s = String.valueOf(value).trim();
        return s.isEmpty() || "FINISH".equalsIgnoreCase(s);
    }

    private static boolean isFinishOrEmptyText(String text) {
        if (!StringUtils.hasText((String)text) || "FINISH".equalsIgnoreCase(text) || "[]".equals(text)) {
            return true;
        }
        try {
            List list = (List)JsonParser.fromJson((String)text, List.class);
            return list == null || list.isEmpty() || list.stream().allMatch(e -> e == null || "FINISH".equalsIgnoreCase(String.valueOf(e).trim()));
        }
        catch (Exception e2) {
            return false;
        }
    }

    public CompletableFuture<String> apply(OverAllState state) {
        Object value = state.value(this.routingKey).orElse(null);
        if (MainAgentToSupervisorEdgeAction.isFinishOrEmpty(value)) {
            logger.info("MainAgentToSupervisorEdgeAction: routing to END as value for key '{}' is finish or empty: {}", (Object)this.routingKey, value);
            return CompletableFuture.completedFuture("__END__");
        }
        return CompletableFuture.completedFuture(this.supervisorNodeName);
    }
}

