/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.node;

import com.alibaba.cloud.ai.graph.GraphResponse;
import com.alibaba.cloud.ai.graph.KeyStrategy;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.ParallelAgent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedParallelResultAggregator
implements NodeAction {
    private static final Logger logger = LoggerFactory.getLogger(EnhancedParallelResultAggregator.class);
    private final String outputKey;
    private final List<BaseAgent> subAgents;
    private final Object mergeStrategy;
    private final Integer maxConcurrency;

    public EnhancedParallelResultAggregator(String outputKey, List<BaseAgent> subAgents, Object mergeStrategy, Integer maxConcurrency) {
        this.outputKey = outputKey;
        this.subAgents = subAgents;
        this.mergeStrategy = mergeStrategy != null ? mergeStrategy : KeyStrategy.REPLACE;
        this.maxConcurrency = maxConcurrency;
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        Object finalResult;
        logger.debug("Starting enhanced result aggregation for {} sub-agents", (Object)this.subAgents.size());
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> subAgentResults = new HashMap<String, Object>();
        for (BaseAgent subAgent : this.subAgents) {
            String subAgentOutputKey = subAgent.getOutputKey();
            if (subAgentOutputKey == null) continue;
            Optional agentResult = state.value(subAgentOutputKey);
            if (agentResult.isPresent()) {
                Object t = agentResult.get();
                if (t instanceof GraphResponse) {
                    Object t2;
                    GraphResponse graphResponse = (GraphResponse)t;
                    if (graphResponse.resultValue().isPresent() && (t2 = graphResponse.resultValue().get()) instanceof Map) {
                        Map map2 = (Map)t2;
                        subAgentResults.put(subAgentOutputKey, map2.get(subAgentOutputKey));
                    } else {
                        subAgentResults.put(subAgentOutputKey, graphResponse.resultValue().get());
                    }
                } else {
                    subAgentResults.put(subAgentOutputKey, agentResult.get());
                }
                logger.debug("Collected result from {}: {} = {}", new Object[]{subAgent.name(), subAgentOutputKey, agentResult.get()});
                continue;
            }
            logger.warn("No output found for sub-agent: {} (outputKey: {})", (Object)subAgent.name(), (Object)subAgentOutputKey);
        }
        Object object = this.mergeStrategy;
        if (object instanceof ParallelAgent.MergeStrategy) {
            ParallelAgent.MergeStrategy strategy = (ParallelAgent.MergeStrategy)object;
            finalResult = strategy.merge(subAgentResults, state);
        } else {
            finalResult = new HashMap(subAgentResults);
        }
        if (this.outputKey != null && !this.outputKey.trim().isEmpty()) {
            result.put(this.outputKey, finalResult);
            logger.debug("Enhanced result aggregation completed. Final result stored under key: {}", (Object)this.outputKey);
        } else {
            logger.debug("Enhanced result aggregation completed. No outputKey specified, skipping merged result storage.");
        }
        Map releaseStrategyResults = subAgentResults.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), KeyStrategy.REPLACE), HashMap::putAll);
        state.updateStateWithKeyStrategies(subAgentResults, releaseStrategyResults);
        result.putAll(subAgentResults);
        return result;
    }
}

