/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.builder;

import com.alibaba.cloud.ai.graph.CompileConfig;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.checkpoint.BaseCheckpointSaver;
import com.alibaba.cloud.ai.graph.checkpoint.config.SaverConfig;
import com.alibaba.cloud.ai.graph.serializer.StateSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class FlowAgentBuilder<T extends FlowAgent, B extends FlowAgentBuilder<T, B>> {
    public String name;
    public String description;
    public CompileConfig compileConfig;
    public BaseCheckpointSaver saver;
    public List<Agent> subAgents;
    public StateSerializer stateSerializer;
    public Executor executor;
    public List<Hook> hooks;

    public B name(String name) {
        this.name = name;
        return this.self();
    }

    public B description(String description) {
        this.description = description;
        return this.self();
    }

    public B compileConfig(CompileConfig compileConfig) {
        this.compileConfig = compileConfig;
        return this.self();
    }

    public B saver(BaseCheckpointSaver saver) {
        this.saver = saver;
        return this.self();
    }

    public B subAgents(List<Agent> subAgents) {
        this.subAgents = subAgents;
        return this.self();
    }

    public B stateSerializer(StateSerializer stateSerializer) {
        this.stateSerializer = stateSerializer;
        return this.self();
    }

    public B executor(Executor executor) {
        this.executor = executor;
        return this.self();
    }

    public B hooks(Hook ... hooks) {
        if (this.hooks == null) {
            this.hooks = new ArrayList<Hook>();
        }
        this.hooks.addAll(Arrays.asList(hooks));
        return this.self();
    }

    public B hooks(List<? extends Hook> hooks) {
        if (this.hooks == null) {
            this.hooks = new ArrayList<Hook>();
        }
        this.hooks.addAll(hooks);
        return this.self();
    }

    protected abstract B self();

    protected void validate() {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name must be provided");
        }
        if (this.subAgents == null || this.subAgents.isEmpty()) {
            throw new IllegalArgumentException("At least one sub-agent must be provided for flow");
        }
    }

    public T build() {
        if (this.saver != null) {
            if (this.compileConfig == null) {
                this.compileConfig = CompileConfig.builder().saverConfig(SaverConfig.builder().register(this.saver).build()).build();
            }
            this.compileConfig = CompileConfig.builder((CompileConfig)this.compileConfig).saverConfig(SaverConfig.builder().register(this.saver).build()).build();
        }
        return this.doBuild();
    }

    public abstract T doBuild();
}

