/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent;

import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowAgentBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import org.springframework.ai.chat.model.ChatModel;

public class SupervisorAgent
extends FlowAgent {
    private final ChatModel chatModel;
    private final String systemPrompt;
    private final String instruction;
    private final ReactAgent mainAgent;

    protected SupervisorAgent(SupervisorAgentBuilder builder) {
        super(builder.name, builder.description, builder.compileConfig, builder.subAgents, builder.stateSerializer, builder.executor, builder.hooks);
        this.chatModel = builder.chatModel;
        this.systemPrompt = builder.systemPrompt;
        this.instruction = builder.instruction;
        this.mainAgent = builder.mainAgent;
    }

    public static SupervisorAgentBuilder builder() {
        return new SupervisorAgentBuilder();
    }

    @Override
    protected StateGraph buildSpecificGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        config.setChatModel(this.chatModel);
        config.setMainAgent(this.mainAgent);
        return FlowGraphBuilder.buildGraph(FlowAgentEnum.SUPERVISOR.getType(), config);
    }

    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public ReactAgent getMainAgent() {
        return this.mainAgent;
    }

    public static class SupervisorAgentBuilder
    extends FlowAgentBuilder<SupervisorAgent, SupervisorAgentBuilder> {
        private ChatModel chatModel;
        private String systemPrompt;
        private String instruction;
        private ReactAgent mainAgent;

        public SupervisorAgentBuilder model(ChatModel chatModel) {
            this.chatModel = chatModel;
            return this;
        }

        public SupervisorAgentBuilder mainAgent(ReactAgent mainAgent) {
            this.mainAgent = mainAgent;
            return this;
        }

        @Deprecated
        public SupervisorAgentBuilder systemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this;
        }

        @Deprecated
        public SupervisorAgentBuilder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        @Override
        protected SupervisorAgentBuilder self() {
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.mainAgent == null) {
                throw new IllegalArgumentException("mainAgent (ReactAgent) must be provided for supervisor agent");
            }
        }

        @Override
        public SupervisorAgent doBuild() {
            this.validate();
            return new SupervisorAgent(this);
        }
    }
}

