/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent;

import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowAgentBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import org.springframework.ai.chat.model.ChatModel;

public class LlmRoutingAgent
extends FlowAgent {
    private final ChatModel chatModel;
    private final String fallbackAgent;
    private final String systemPrompt;
    private final String instruction;

    protected LlmRoutingAgent(LlmRoutingAgentBuilder builder) {
        super(builder.name, builder.description, builder.compileConfig, builder.subAgents, builder.stateSerializer, builder.executor, builder.hooks);
        this.chatModel = builder.chatModel;
        this.fallbackAgent = builder.fallbackAgent;
        this.systemPrompt = builder.systemPrompt;
        this.instruction = builder.instruction;
    }

    public static LlmRoutingAgentBuilder builder() {
        return new LlmRoutingAgentBuilder();
    }

    public String getFallbackAgent() {
        return this.fallbackAgent;
    }

    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public String getInstruction() {
        return this.instruction;
    }

    @Override
    protected StateGraph buildSpecificGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        config.setChatModel(this.chatModel);
        return FlowGraphBuilder.buildGraph(FlowAgentEnum.ROUTING.getType(), config);
    }

    public static class LlmRoutingAgentBuilder
    extends FlowAgentBuilder<LlmRoutingAgent, LlmRoutingAgentBuilder> {
        private ChatModel chatModel;
        private String fallbackAgent;
        private String systemPrompt;
        private String instruction;

        public LlmRoutingAgentBuilder model(ChatModel chatModel) {
            this.chatModel = chatModel;
            return this;
        }

        public LlmRoutingAgentBuilder fallbackAgent(String fallbackAgent) {
            this.fallbackAgent = fallbackAgent;
            return this;
        }

        public LlmRoutingAgentBuilder systemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this;
        }

        public LlmRoutingAgentBuilder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        @Override
        protected LlmRoutingAgentBuilder self() {
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.chatModel == null) {
                throw new IllegalArgumentException("ChatModel must be provided for LLM routing agent");
            }
        }

        @Override
        public LlmRoutingAgent doBuild() {
            this.validate();
            return new LlmRoutingAgent(this);
        }
    }
}

