/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent;

import com.alibaba.cloud.ai.graph.CompileConfig;
import com.alibaba.cloud.ai.graph.CompiledGraph;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.scheduling.ScheduleConfig;
import com.alibaba.cloud.ai.graph.scheduling.ScheduledAgentTask;
import com.alibaba.cloud.ai.graph.serializer.StateSerializer;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class FlowAgent
extends Agent {
    protected List<String> interruptBefore;
    protected List<Agent> subAgents;
    protected StateSerializer stateSerializer;
    protected List<Hook> hooks;

    protected FlowAgent(String name, String description, CompileConfig compileConfig, List<Agent> subAgents) {
        super(name, description);
        this.compileConfig = compileConfig;
        this.subAgents = subAgents;
    }

    protected FlowAgent(String name, String description, CompileConfig compileConfig, List<Agent> subAgents, StateSerializer stateSerializer) {
        super(name, description);
        this.compileConfig = compileConfig;
        this.subAgents = subAgents;
        this.stateSerializer = stateSerializer;
    }

    protected FlowAgent(String name, String description, CompileConfig compileConfig, List<Agent> subAgents, StateSerializer stateSerializer, Executor executor) {
        super(name, description);
        this.compileConfig = compileConfig;
        this.subAgents = subAgents;
        this.stateSerializer = stateSerializer;
        this.executor = executor;
    }

    protected FlowAgent(String name, String description, CompileConfig compileConfig, List<Agent> subAgents, StateSerializer stateSerializer, Executor executor, List<Hook> hooks) {
        super(name, description);
        this.compileConfig = compileConfig;
        this.subAgents = subAgents;
        this.stateSerializer = stateSerializer;
        this.executor = executor;
        this.hooks = hooks;
    }

    @Override
    protected StateGraph initGraph() throws GraphStateException {
        FlowGraphBuilder.FlowGraphConfig config = FlowGraphBuilder.FlowGraphConfig.builder().name(this.name()).rootAgent(this).subAgents(this.subAgents());
        if (this.stateSerializer != null) {
            config.stateSerializer(this.stateSerializer);
        }
        if (this.hooks != null && !this.hooks.isEmpty()) {
            config.hooks(this.hooks);
        }
        return this.buildSpecificGraph(config);
    }

    @Override
    public ScheduledAgentTask schedule(ScheduleConfig scheduleConfig) {
        CompiledGraph compiledGraph = this.getAndCompileGraph();
        return compiledGraph.schedule(scheduleConfig);
    }

    public StateGraph asStateGraph() {
        return this.getGraph();
    }

    protected abstract StateGraph buildSpecificGraph(FlowGraphBuilder.FlowGraphConfig var1) throws GraphStateException;

    public List<Agent> subAgents() {
        return this.subAgents;
    }

    public List<Hook> hooks() {
        return this.hooks;
    }
}

