/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.tools.model;

import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class TaskTool
implements BiFunction<TaskRequest, ToolContext, String> {
    private final Map<String, ReactAgent> subAgents;

    public TaskTool(Map<String, ReactAgent> subAgents) {
        this.subAgents = subAgents;
    }

    @Override
    public String apply(TaskRequest request, ToolContext toolContext) {
        if (!this.subAgents.containsKey(request.subagentType)) {
            return "Error: invoked agent of type " + request.subagentType + ", the only allowed types are " + this.subAgents.keySet();
        }
        ReactAgent subAgent = this.subAgents.get(request.subagentType);
        try {
            AssistantMessage result = subAgent.call(request.description);
            return result.getText();
        }
        catch (Exception e) {
            return "Error executing subagent task: " + e.getMessage();
        }
    }

    public static ToolCallback createTaskToolCallback(Map<String, ReactAgent> subAgents, String description) {
        return FunctionToolCallback.builder((String)"task", (BiFunction)new TaskTool(subAgents)).description(description).inputType(TaskRequest.class).build();
    }

    public static class TaskRequest {
        @JsonProperty(required=true)
        @JsonPropertyDescription(value="Detailed description of the task to be performed by the subagent")
        public String description;
        @JsonProperty(required=true, value="subagent_type")
        @JsonPropertyDescription(value="The type of subagent to use for this task")
        public String subagentType;

        public TaskRequest() {
        }

        public TaskRequest(String description, String subagentType) {
            this.description = description;
            this.subagentType = subagentType;
        }
    }
}

