/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiFunction;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class WriteFileTool
implements BiFunction<WriteFileRequest, ToolContext, String> {
    public static final String DESCRIPTION = "Writes to a new file in the filesystem.\n\nUsage:\n- The file_path parameter must be an absolute path, not a relative path\n- The content parameter must be a string\n- The write_file tool will create a new file.\n- When writing to a file, the content will completely replace the existing content.\n";

    @Override
    public String apply(WriteFileRequest request, ToolContext toolContext) {
        try {
            Path path = Paths.get(request.filePath, new String[0]);
            return WriteFileTool.writeFileContent(path, request.content);
        }
        catch (Exception e) {
            return "Error writing file: " + e.getMessage();
        }
    }

    public static String writeFileContent(Path filePath, String content) {
        try {
            if (Files.exists(filePath, new LinkOption[0])) {
                return "Error: Cannot write to " + filePath + " because it already exists. Read and then make an edit, or write to a new path.";
            }
            Path parent = filePath.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(filePath, content != null ? content.getBytes(StandardCharsets.UTF_8) : new byte[]{}, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            return "Successfully created file: " + filePath;
        }
        catch (IOException e) {
            return "Error writing file '" + filePath + "': " + e.getMessage();
        }
    }

    public static ToolCallback createWriteFileToolCallback(String description) {
        return FunctionToolCallback.builder((String)"write_file", (BiFunction)new WriteFileTool()).description(description).inputType(WriteFileRequest.class).build();
    }

    public static class WriteFileRequest {
        @JsonProperty(required=true, value="file_path")
        @JsonPropertyDescription(value="The absolute path of the file to create")
        public String filePath;
        @JsonProperty(required=true)
        @JsonPropertyDescription(value="The content to write to the file")
        public String content;

        public WriteFileRequest() {
        }

        public WriteFileRequest(String filePath, String content) {
            this.filePath = filePath;
            this.content = content;
        }
    }
}

