/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem;

import com.alibaba.cloud.ai.graph.agent.extension.file.FileInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class ListFilesTool
implements BiFunction<String, ToolContext, String> {
    public static final String DESCRIPTION = "Lists all files in the filesystem, filtering by directory.\n\nUsage:\n- The path parameter must be an absolute path, not a relative path\n- The list_files tool will return a list of all files in the specified directory.\n- This is very useful for exploring the file system and finding the right file to read or edit.\n- You should almost ALWAYS use this tool before using the Read or Edit tools.\n";

    @Override
    public String apply(@ToolParam(description="The directory path to list files from") String path, ToolContext toolContext) {
        try {
            Path dirPath = Paths.get(path, new String[0]);
            List<FileInfo> fileInfos = ListFilesTool.listFilesContent(dirPath, null, false);
            ArrayList<String> filePaths = new ArrayList<String>();
            for (FileInfo info : fileInfos) {
                filePaths.add(info.getPath());
            }
            return filePaths.isEmpty() ? "Directory is empty" : String.join((CharSequence)"\n", filePaths);
        }
        catch (Exception e) {
            return "Error listing directory '" + path + "': " + e.getMessage();
        }
    }

    public static List<FileInfo> listFilesContent(Path dirPath, Path cwd, boolean virtualMode) {
        ArrayList<FileInfo> results = new ArrayList<FileInfo>();
        try {
            Object cwdStr;
            if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) {
                return results;
            }
            Object object = cwdStr = cwd != null ? cwd.toString() : null;
            if (cwdStr != null && !((String)cwdStr).endsWith("/")) {
                cwdStr = (String)cwdStr + "/";
            }
            try (Stream<Path> paths = Files.list(dirPath);){
                for (Path childPath : paths.toList()) {
                    try {
                        BasicFileAttributes attrs;
                        String relativePath;
                        boolean isFile = Files.isRegularFile(childPath, LinkOption.NOFOLLOW_LINKS);
                        boolean isDir = Files.isDirectory(childPath, LinkOption.NOFOLLOW_LINKS);
                        String absPath = childPath.toString();
                        if (!virtualMode || cwd == null) {
                            BasicFileAttributes attrs2;
                            if (isFile) {
                                try {
                                    attrs2 = Files.readAttributes(childPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                                    results.add(new FileInfo(absPath, false, attrs2.size(), ListFilesTool.formatTimestamp(attrs2.lastModifiedTime().toInstant())));
                                }
                                catch (IOException e) {
                                    results.add(new FileInfo(absPath, false, null, null));
                                }
                                continue;
                            }
                            if (!isDir) continue;
                            try {
                                attrs2 = Files.readAttributes(childPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                                results.add(new FileInfo(absPath + "/", true, 0L, ListFilesTool.formatTimestamp(attrs2.lastModifiedTime().toInstant())));
                            }
                            catch (IOException e) {
                                results.add(new FileInfo(absPath + "/", true, null, null));
                            }
                            continue;
                        }
                        if (cwdStr != null && absPath.startsWith((String)cwdStr)) {
                            relativePath = absPath.substring(((String)cwdStr).length());
                        } else if (cwdStr != null && absPath.startsWith(cwd.toString())) {
                            relativePath = absPath.substring(cwd.toString().length());
                            if (relativePath.startsWith("/")) {
                                relativePath = relativePath.substring(1);
                            }
                        } else {
                            relativePath = absPath;
                        }
                        String virtPath = "/" + relativePath;
                        if (isFile) {
                            try {
                                attrs = Files.readAttributes(childPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                                results.add(new FileInfo(virtPath, false, attrs.size(), ListFilesTool.formatTimestamp(attrs.lastModifiedTime().toInstant())));
                            }
                            catch (IOException e) {
                                results.add(new FileInfo(virtPath, false, null, null));
                            }
                            continue;
                        }
                        if (!isDir) continue;
                        try {
                            attrs = Files.readAttributes(childPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                            results.add(new FileInfo(virtPath + "/", true, 0L, ListFilesTool.formatTimestamp(attrs.lastModifiedTime().toInstant())));
                        }
                        catch (IOException e) {
                            results.add(new FileInfo(virtPath + "/", true, null, null));
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            results.sort(Comparator.comparing(FileInfo::getPath));
            return results;
        }
        catch (Exception e) {
            return results;
        }
    }

    private static String formatTimestamp(Instant instant) {
        return instant.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static ToolCallback createListFilesToolCallback(String description) {
        return FunctionToolCallback.builder((String)"ls", (BiFunction)new ListFilesTool()).description(description).inputType(String.class).build();
    }
}

