/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem;

import com.alibaba.cloud.ai.graph.agent.extension.file.FileInfo;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.EditFileTool;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.ListFilesTool;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.ReadFileTool;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.WriteFileTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;

public class FileSystemTools {
    private static final int DEFAULT_MAX_FILE_SIZE_MB = 10;
    private final Path cwd;
    private final boolean virtualMode;
    private final long maxFileSizeBytes;

    public FileSystemTools() {
        this(null, false, 10);
    }

    public FileSystemTools(String rootDir, boolean virtualMode, int maxFileSizeMb) {
        this.cwd = rootDir != null ? Paths.get(rootDir, new String[0]).toAbsolutePath().normalize() : Paths.get("", new String[0]).toAbsolutePath();
        this.virtualMode = virtualMode;
        this.maxFileSizeBytes = (long)maxFileSizeMb * 1024L * 1024L;
    }

    private Path resolvePath(String key) throws IllegalArgumentException {
        if (this.virtualMode) {
            Object vpath;
            Object object = vpath = key.startsWith("/") ? key : "/" + key;
            if (((String)vpath).contains("..") || ((String)vpath).startsWith("~")) {
                throw new IllegalArgumentException("Path traversal not allowed");
            }
            Path full = this.cwd.resolve(((String)vpath).substring(1)).normalize();
            if (!full.startsWith(this.cwd)) {
                throw new IllegalArgumentException("Path:" + full + " outside root directory: " + this.cwd);
            }
            return full;
        }
        Path path = Paths.get(key, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        return this.cwd.resolve(path).normalize();
    }

    @Tool(name="read_file", description="Reads a file from the filesystem. You can access any file directly by using this tool.\nAssume this tool is able to read all files on the machine. If the User provides a path to a file assume that path is valid. It is okay to read a file that does not exist; an error will be returned.\n\nUsage:\n- The file_path parameter must be an absolute path, not a relative path\n- By default, it reads up to 500 lines starting from the beginning of the file\n- **IMPORTANT for large files and codebase exploration**: Use pagination with offset and limit parameters to avoid context overflow\n  - First scan: read_file(path, limit=100) to see file structure\n  - Read more sections: read_file(path, offset=100, limit=200) for next 200 lines\n  - Only omit limit (read full file) when necessary for editing\n- Specify offset and limit: read_file(path, offset=0, limit=100) reads first 100 lines\n- Any lines longer than 10000 characters will be truncated\n- Results are returned using cat -n format, with line numbers starting at 1\n- You have the capability to call multiple tools in a single response. It is always better to speculatively read multiple files as a batch that are potentially useful.\n- If you read a file that exists but has empty contents you will receive a system reminder warning in place of file contents.\n- You should almost ALWAYS use the list_files tool before using this tool to verify the file path.\n")
    public String readFile(@ToolParam(description="The absolute path of the file to read") String filePath, @ToolParam(description="Line offset to start reading from (default: 0)", required=false) Integer offset, @ToolParam(description="Maximum number of lines to read (default: 500)", required=false) Integer limit, ToolContext toolContext) {
        try {
            Path resolvedPath = this.resolvePath(filePath);
            return ReadFileTool.readFileContent(resolvedPath, offset, limit, true);
        }
        catch (IllegalArgumentException e) {
            return "Error: " + e.getMessage();
        }
        catch (Exception e) {
            return "Error reading file '" + filePath + "': " + e.getMessage();
        }
    }

    @Tool(name="write_file", description="Writes content to a new file in the filesystem.\n\nUsage:\n- The file_path parameter must be an absolute path, not a relative path\n- This tool will create a new file. If the file already exists, an error will be returned.\n- To modify an existing file, use the edit_file tool instead.\n- Parent directories will be created automatically if they don't exist.\n")
    public String writeFile(@ToolParam(description="The absolute path of the file to write") String filePath, @ToolParam(description="The content to write to the file") String content, ToolContext toolContext) {
        try {
            Path resolvedPath = this.resolvePath(filePath);
            return WriteFileTool.writeFileContent(resolvedPath, content);
        }
        catch (IllegalArgumentException e) {
            return "Error: " + e.getMessage();
        }
        catch (Exception e) {
            return "Error writing file '" + filePath + "': " + e.getMessage();
        }
    }

    @Tool(name="edit_file", description="Edits a file by replacing string occurrences.\n\nUsage:\n- The file_path parameter must be an absolute path, not a relative path\n- You must use the read_file tool at least once before editing to read the file's contents\n- When editing text, ensure you preserve the exact indentation (tabs/spaces) as it appears in the file\n- The edit will FAIL if old_string is not unique in the file. Either provide a larger string with more surrounding context to make it unique or use replace_all=true to change every instance\n- Use replace_all=true for replacing and renaming strings across the file\n")
    public String editFile(@ToolParam(description="The absolute path of the file to modify") String filePath, @ToolParam(description="The text to replace") String oldString, @ToolParam(description="The text to replace it with (must be different from old_string)") String newString, @ToolParam(description="Replace all occurrences of old_string (default false)", required=false) Boolean replaceAll, ToolContext toolContext) {
        try {
            Path resolvedPath = this.resolvePath(filePath);
            boolean replaceAllFlag = Boolean.TRUE.equals(replaceAll);
            return EditFileTool.editFileContent(resolvedPath, oldString, newString, replaceAllFlag);
        }
        catch (IllegalArgumentException e) {
            return "Error: " + e.getMessage();
        }
        catch (Exception e) {
            return "Error editing file '" + filePath + "': " + e.getMessage();
        }
    }

    @Tool(name="list_files", description="Lists all files and directories in the specified directory.\n\nUsage:\n- The path parameter must be an absolute path, not a relative path\n- The list_files tool will return a list of all files and directories in the specified directory (non-recursive)\n- Directories are indicated with a trailing / in their path\n- This is very useful for exploring the file system and finding the right file to read or edit\n- You should almost ALWAYS use this tool before using the read_file or edit_file tools\n")
    public String listFiles(@ToolParam(description="The directory path to list files from") String path, ToolContext toolContext) {
        try {
            Path dirPath = this.resolvePath(path);
            if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) {
                return "Error: Directory not found: " + path;
            }
            List<FileInfo> results = ListFilesTool.listFilesContent(dirPath, this.virtualMode ? this.cwd : null, this.virtualMode);
            StringBuilder result = new StringBuilder();
            for (FileInfo info : results) {
                result.append(info.getPath());
                if (info.getSize() != null) {
                    result.append(" (").append(info.getSize()).append(" bytes)");
                }
                if (info.getModifiedAt() != null) {
                    result.append(" [").append(info.getModifiedAt()).append("]");
                }
                result.append("\n");
            }
            return !result.isEmpty() ? result.toString().trim() : "Directory is empty";
        }
        catch (IllegalArgumentException e) {
            return "Error: " + e.getMessage();
        }
        catch (Exception e) {
            return "Error listing directory '" + path + "': " + e.getMessage();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String rootDir;
        private boolean virtualMode = false;
        private int maxFileSizeMb = 10;

        public Builder rootDir(String rootDir) {
            this.rootDir = rootDir;
            return this;
        }

        public Builder virtualMode(boolean virtualMode) {
            this.virtualMode = virtualMode;
            return this;
        }

        public Builder maxFileSizeMb(int maxFileSizeMb) {
            this.maxFileSizeMb = maxFileSizeMb;
            return this;
        }

        public FileSystemTools build() {
            return new FileSystemTools(this.rootDir, this.virtualMode, this.maxFileSizeMb);
        }
    }
}

