/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.function.BiFunction;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class EditFileTool
implements BiFunction<EditFileRequest, ToolContext, String> {
    public static final String DESCRIPTION = "Performs exact string replacements in files.\n\nUsage:\n- You must use your `read_file` tool at least once before editing.\n- When editing text from read_file output, preserve exact indentation\n- ALWAYS prefer editing existing files. NEVER write new files unless explicitly required.\n- The edit will FAIL if `old_string` is not unique in the file.\n- After editing, verify the changes by using the read_file tool.\n";

    @Override
    public String apply(EditFileRequest request, ToolContext toolContext) {
        try {
            Path path = Paths.get(request.filePath, new String[0]);
            return EditFileTool.editFileContent(path, request.oldString, request.newString, request.replaceAll);
        }
        catch (Exception e) {
            return "Error editing file: " + e.getMessage();
        }
    }

    public static String editFileContent(Path filePath, String oldString, String newString, boolean replaceAll) {
        try {
            int replaceIndex;
            if (!Files.exists(filePath, new LinkOption[0]) || !Files.isRegularFile(filePath, LinkOption.NOFOLLOW_LINKS)) {
                return "Error: File '" + filePath + "' not found";
            }
            String content = Files.readString(filePath);
            int occurrences = EditFileTool.countOccurrences(content, oldString);
            if (occurrences == 0) {
                return "Error: String not found in file: '" + oldString + "'";
            }
            if (!replaceAll && occurrences > 1) {
                return "Error: String '" + oldString + "' appears " + occurrences + " times in file. Use replaceAll=true to replace all instances, or provide a more specific string with surrounding context.";
            }
            Object newContent = replaceAll ? content.replace(oldString, newString) : ((replaceIndex = content.indexOf(oldString)) != -1 ? content.substring(0, replaceIndex) + newString + content.substring(replaceIndex + oldString.length()) : content);
            Files.writeString(filePath, (CharSequence)newContent, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            return String.format("Successfully edited file: %s (replaced %d occurrence(s))", filePath, occurrences);
        }
        catch (IOException e) {
            return "Error editing file '" + filePath + "': " + e.getMessage();
        }
    }

    private static int countOccurrences(String content, String search) {
        int count = 0;
        int index = 0;
        while ((index = content.indexOf(search, index)) != -1) {
            ++count;
            index += search.length();
        }
        return count;
    }

    public static ToolCallback createEditFileToolCallback(String description) {
        return FunctionToolCallback.builder((String)"edit_file", (BiFunction)new EditFileTool()).description(description).inputType(EditFileRequest.class).build();
    }

    public static class EditFileRequest {
        @JsonProperty(required=true, value="file_path")
        @JsonPropertyDescription(value="The absolute path of the file to edit")
        public String filePath;
        @JsonProperty(required=true, value="old_string")
        @JsonPropertyDescription(value="The exact string to find and replace")
        public String oldString;
        @JsonProperty(required=true, value="new_string")
        @JsonPropertyDescription(value="The new string to replace with")
        public String newString;
        @JsonProperty(value="replace_all")
        @JsonPropertyDescription(value="If true, replace all occurrences; if false, only replace if unique (default: false)")
        public boolean replaceAll = false;

        public EditFileRequest() {
        }

        public EditFileRequest(String filePath, String oldString, String newString, boolean replaceAll) {
            this.filePath = filePath;
            this.oldString = oldString;
            this.newString = newString;
            this.replaceAll = replaceAll;
        }
    }
}

