/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.a2a;

import com.alibaba.cloud.ai.graph.CompileConfig;
import com.alibaba.cloud.ai.graph.CompiledGraph;
import com.alibaba.cloud.ai.graph.KeyStrategy;
import com.alibaba.cloud.ai.graph.KeyStrategyFactory;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.SubGraphNode;
import com.alibaba.cloud.ai.graph.action.AsyncNodeActionWithConfig;
import com.alibaba.cloud.ai.graph.action.NodeActionWithConfig;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import com.alibaba.cloud.ai.graph.agent.a2a.A2aNodeActionWithConfig;
import com.alibaba.cloud.ai.graph.agent.a2a.AgentCardProvider;
import com.alibaba.cloud.ai.graph.agent.a2a.AgentCardWrapper;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.internal.node.Node;
import com.alibaba.cloud.ai.graph.scheduling.ScheduleConfig;
import com.alibaba.cloud.ai.graph.scheduling.ScheduledAgentTask;
import com.alibaba.cloud.ai.graph.state.strategy.AppendStrategy;
import io.a2a.spec.AgentCard;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Logger;

public class A2aRemoteAgent
extends BaseAgent {
    Logger logger = Logger.getLogger(A2aRemoteAgent.class.getName());
    private final AgentCardWrapper agentCard;
    private KeyStrategyFactory keyStrategyFactory;
    private String instruction;
    private boolean streaming;
    private boolean shareState;

    private A2aRemoteAgent(Builder builder) {
        super(builder.name, builder.description, builder.includeContents, builder.returnReasoningContents, builder.outputKey, builder.outputKeyStrategy);
        this.agentCard = builder.agentCard;
        this.keyStrategyFactory = builder.keyStrategyFactory;
        this.compileConfig = builder.compileConfig;
        this.includeContents = builder.includeContents;
        this.streaming = builder.streaming;
        this.instruction = builder.instruction;
        this.shareState = builder.shareState;
    }

    @Override
    protected StateGraph initGraph() throws GraphStateException {
        if (this.keyStrategyFactory == null) {
            this.keyStrategyFactory = () -> {
                HashMap<String, AppendStrategy> keyStrategyHashMap = new HashMap<String, AppendStrategy>();
                keyStrategyHashMap.put("messages", new AppendStrategy());
                return keyStrategyHashMap;
            };
        }
        StateGraph graph = new StateGraph(this.name, this.keyStrategyFactory);
        graph.addNode("A2aNode", AsyncNodeActionWithConfig.node_async((NodeActionWithConfig)new A2aNodeActionWithConfig(this.agentCard, this.name, this.includeContents, this.outputKey, this.instruction, this.streaming, this.shareState, this.compileConfig)));
        graph.addEdge("__START__", "A2aNode");
        graph.addEdge("A2aNode", "__END__");
        return graph;
    }

    @Override
    public ScheduledAgentTask schedule(ScheduleConfig scheduleConfig) {
        throw new UnsupportedOperationException("A2aRemoteAgent has not support schedule.");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Node asNode(boolean includeContents, boolean returnReasoningContents) {
        return new A2aRemoteAgentNode(this.name, includeContents, returnReasoningContents, this.instruction, this.agentCard, this.streaming, this.shareState, this.getAndCompileGraph());
    }

    public static class Builder {
        private String name;
        private String description;
        private String instruction;
        private String outputKey = "output";
        private KeyStrategy outputKeyStrategy;
        private boolean returnReasoningContents = false;
        private AgentCardWrapper agentCard;
        private AgentCardProvider agentCardProvider;
        private boolean includeContents = true;
        private KeyStrategyFactory keyStrategyFactory;
        private CompileConfig compileConfig;
        private boolean streaming = false;
        private boolean shareState = true;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public Builder outputKeyStrategy(KeyStrategy outputKeyStrategy) {
            this.outputKeyStrategy = outputKeyStrategy;
            return this;
        }

        public Builder returnReasoningContents(boolean returnReasoningContents) {
            this.returnReasoningContents = returnReasoningContents;
            return this;
        }

        public Builder agentCard(AgentCard agentCard) {
            this.agentCard = new AgentCardWrapper(agentCard);
            return this;
        }

        public Builder agentCardProvider(AgentCardProvider agentCardProvider) {
            this.agentCardProvider = agentCardProvider;
            return this;
        }

        public Builder includeContents(boolean includeContents) {
            this.includeContents = includeContents;
            return this;
        }

        public Builder state(KeyStrategyFactory keyStrategyFactory) {
            this.keyStrategyFactory = keyStrategyFactory;
            return this;
        }

        public Builder compileConfig(CompileConfig compileConfig) {
            this.compileConfig = compileConfig;
            return this;
        }

        public Builder streaming(boolean streaming) {
            this.streaming = streaming;
            return this;
        }

        public Builder shareState(boolean shareState) {
            this.shareState = shareState;
            return this;
        }

        public A2aRemoteAgent build() {
            if (this.name == null || this.name.trim().isEmpty()) {
                throw new IllegalArgumentException("Name must be provided");
            }
            if (this.description == null || this.description.trim().isEmpty()) {
                throw new IllegalArgumentException("Description must be provided");
            }
            if (this.agentCard == null) {
                if (null == this.agentCardProvider) {
                    throw new IllegalArgumentException("AgentCard or AgentCardProvider must be provided");
                }
                this.agentCard = this.agentCardProvider.supportGetAgentCardByName() ? this.agentCardProvider.getAgentCard(this.name) : this.agentCardProvider.getAgentCard();
            }
            this.streaming = this.agentCard.capabilities().streaming();
            return new A2aRemoteAgent(this);
        }
    }

    private class A2aRemoteAgentNode
    extends Node
    implements SubGraphNode {
        private final CompiledGraph subGraph;

        public A2aRemoteAgentNode(String id, boolean includeContents, boolean returnReasoningContents, String instruction, AgentCardWrapper agentCard, boolean streaming, boolean shareState, CompiledGraph subGraph) {
            super(Objects.requireNonNull(id, "id cannot be null"), config -> AsyncNodeActionWithConfig.node_async((NodeActionWithConfig)new A2aNodeActionWithConfig(agentCard, subGraph.stateGraph.getName(), includeContents, A2aRemoteAgent.this.outputKey, instruction, streaming, shareState, config)));
            this.subGraph = subGraph;
        }

        public StateGraph subGraph() {
            return this.subGraph.stateGraph;
        }
    }
}

