/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent;

import com.alibaba.cloud.ai.graph.CompileConfig;
import com.alibaba.cloud.ai.graph.CompiledGraph;
import com.alibaba.cloud.ai.graph.GraphResponse;
import com.alibaba.cloud.ai.graph.KeyStrategy;
import com.alibaba.cloud.ai.graph.KeyStrategyFactory;
import com.alibaba.cloud.ai.graph.NodeOutput;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.SubGraphNode;
import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeActionWithConfig;
import com.alibaba.cloud.ai.graph.action.EdgeAction;
import com.alibaba.cloud.ai.graph.action.NodeActionWithConfig;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import com.alibaba.cloud.ai.graph.agent.Builder;
import com.alibaba.cloud.ai.graph.agent.Prioritized;
import com.alibaba.cloud.ai.graph.agent.exception.AgentException;
import com.alibaba.cloud.ai.graph.agent.factory.AgentBuilderFactory;
import com.alibaba.cloud.ai.graph.agent.factory.DefaultAgentBuilderFactory;
import com.alibaba.cloud.ai.graph.agent.hook.AgentHook;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.agent.hook.HookPosition;
import com.alibaba.cloud.ai.graph.agent.hook.InterruptionHook;
import com.alibaba.cloud.ai.graph.agent.hook.JumpTo;
import com.alibaba.cloud.ai.graph.agent.hook.ModelHook;
import com.alibaba.cloud.ai.graph.agent.hook.ToolInjection;
import com.alibaba.cloud.ai.graph.agent.hook.hip.HumanInTheLoopHook;
import com.alibaba.cloud.ai.graph.agent.hook.messages.MessagesAgentHook;
import com.alibaba.cloud.ai.graph.agent.hook.messages.MessagesModelHook;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolInterceptor;
import com.alibaba.cloud.ai.graph.agent.node.AgentLlmNode;
import com.alibaba.cloud.ai.graph.agent.node.AgentToolNode;
import com.alibaba.cloud.ai.graph.exception.GraphRunnerException;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.internal.node.Node;
import com.alibaba.cloud.ai.graph.internal.node.ResumableSubGraphAction;
import com.alibaba.cloud.ai.graph.serializer.AgentInstructionMessage;
import com.alibaba.cloud.ai.graph.serializer.StateSerializer;
import com.alibaba.cloud.ai.graph.serializer.plain_text.jackson.SpringAIJacksonStateSerializer;
import com.alibaba.cloud.ai.graph.state.strategy.AppendStrategy;
import com.alibaba.cloud.ai.graph.state.strategy.ReplaceStrategy;
import com.alibaba.cloud.ai.graph.utils.TypeRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class ReactAgent
extends BaseAgent {
    Logger logger = LoggerFactory.getLogger(ReactAgent.class);
    private final ConcurrentMap<String, Map<String, Object>> threadIdStateMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private final AgentLlmNode llmNode;
    private final AgentToolNode toolNode;
    private List<? extends Hook> hooks;
    private List<ModelInterceptor> modelInterceptors;
    private List<ToolInterceptor> toolInterceptors;
    private String instruction;
    private StateSerializer stateSerializer;
    private final Boolean hasTools;

    public ReactAgent(AgentLlmNode llmNode, AgentToolNode toolNode, CompileConfig compileConfig, Builder builder) {
        super(builder.name, builder.description, builder.includeContents, builder.returnReasoningContents, builder.outputKey, builder.outputKeyStrategy);
        this.instruction = builder.instruction;
        this.llmNode = llmNode;
        this.toolNode = toolNode;
        this.compileConfig = compileConfig;
        this.hooks = builder.hooks;
        this.modelInterceptors = builder.modelInterceptors;
        this.toolInterceptors = builder.toolInterceptors;
        this.includeContents = builder.includeContents;
        this.inputSchema = builder.inputSchema;
        this.inputType = builder.inputType;
        this.outputSchema = builder.outputSchema;
        this.outputType = builder.outputType;
        this.stateSerializer = Objects.requireNonNullElseGet(builder.stateSerializer, () -> new SpringAIJacksonStateSerializer(OverAllState::new));
        this.executor = builder.executor;
        List<ModelInterceptor> mergedModelInterceptors = this.collectAndMergeModelInterceptors();
        List<ToolInterceptor> mergedToolInterceptors = this.collectAndMergeToolInterceptors();
        if (mergedModelInterceptors != null && !mergedModelInterceptors.isEmpty()) {
            this.llmNode.setModelInterceptors(mergedModelInterceptors);
        }
        if (mergedToolInterceptors != null && !mergedToolInterceptors.isEmpty()) {
            this.toolNode.setToolInterceptors(mergedToolInterceptors);
        }
        this.hasTools = toolNode.getToolCallbacks() != null && !toolNode.getToolCallbacks().isEmpty();
    }

    public static Builder builder() {
        return new DefaultAgentBuilderFactory().builder();
    }

    public static Builder builder(AgentBuilderFactory agentBuilderFactory) {
        return agentBuilderFactory.builder();
    }

    public AssistantMessage call(String message) throws GraphRunnerException {
        return this.doMessageInvoke(message, null);
    }

    public AssistantMessage call(String message, RunnableConfig config) throws GraphRunnerException {
        return this.doMessageInvoke(message, config);
    }

    public AssistantMessage call(UserMessage message) throws GraphRunnerException {
        return this.doMessageInvoke(message, null);
    }

    public AssistantMessage call(UserMessage message, RunnableConfig config) throws GraphRunnerException {
        return this.doMessageInvoke(message, config);
    }

    public AssistantMessage call(List<Message> messages) throws GraphRunnerException {
        return this.doMessageInvoke(messages, null);
    }

    public AssistantMessage call(List<Message> messages, RunnableConfig config) throws GraphRunnerException {
        return this.doMessageInvoke(messages, config);
    }

    public AssistantMessage call(Map<String, Object> inputs) throws GraphRunnerException {
        return this.doMessageInvoke(inputs, null);
    }

    public AssistantMessage call(Map<String, Object> inputs, RunnableConfig config) throws GraphRunnerException {
        return this.doMessageInvoke(inputs, config);
    }

    public void interrupt(RunnableConfig config) {
        this.updateAgentState(List.of(), config);
    }

    public void interrupt(List<Message> messages, RunnableConfig config) {
        this.updateAgentState(messages, config);
    }

    public void interrupt(String userMessage, RunnableConfig config) {
        this.updateAgentState(List.of(UserMessage.builder().text(userMessage).build()), config);
    }

    public void updateAgentState(Object state, RunnableConfig config) {
        String threadId = (String)config.threadId().orElseThrow(() -> new IllegalArgumentException("threadId must be provided in RunnableConfig for interruption."));
        Map stateStatus = this.threadIdStateMap.computeIfAbsent(threadId, k -> new ConcurrentHashMap());
        stateStatus.put("INTERRUPTION_FEEDBACK", state);
    }

    private AssistantMessage doMessageInvoke(Object message, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.extractAssistantMessage(this.doInvoke(inputs, config));
    }

    private AssistantMessage doMessageInvoke(Map<String, Object> inputs, RunnableConfig config) throws GraphRunnerException {
        return this.extractAssistantMessage(this.doInvoke(inputs, config));
    }

    private AssistantMessage extractAssistantMessage(Optional<OverAllState> state) {
        if (StringUtils.hasLength((String)this.outputKey)) {
            return state.flatMap(s -> s.value(this.outputKey)).map(msg -> (AssistantMessage)msg).orElseThrow(() -> new IllegalStateException("Output key " + this.outputKey + " not found in agent state"));
        }
        return (AssistantMessage)state.flatMap(s -> s.value("messages")).stream().flatMap(messageList -> ((List)messageList).stream().filter(msg -> msg instanceof AssistantMessage).map(msg -> (AssistantMessage)msg)).reduce((first, second) -> second).orElseThrow(() -> new AgentException("No AssistantMessage found in 'messages' state"));
    }

    public StateGraph getStateGraph() {
        return this.getGraph();
    }

    public CompiledGraph getCompiledGraph() {
        return this.compiledGraph;
    }

    @Override
    public Node asNode(boolean includeContents, boolean returnReasoningContents) {
        if (this.compiledGraph == null) {
            this.compiledGraph = this.getAndCompileGraph();
        }
        return new AgentSubGraphNode(this.name, includeContents, returnReasoningContents, this.compiledGraph, this.instruction);
    }

    @Override
    protected StateGraph initGraph() throws GraphStateException {
        MessagesModelHook messagesModelHook;
        ModelHook modelHook;
        MessagesAgentHook messagesAgentHook;
        AgentHook agentHook;
        if (this.hooks == null) {
            this.hooks = new ArrayList<Hook>();
        }
        HashSet<String> hookNames = new HashSet<String>();
        for (Hook hook : this.hooks) {
            if (!hookNames.add(Hook.getFullHookName(hook))) {
                throw new IllegalArgumentException("Duplicate hook instances found");
            }
            hook.setAgentName(this.name);
            hook.setAgent(this);
        }
        StateGraph graph = new StateGraph(this.name, this.buildMessagesKeyStrategyFactory(this.hooks), this.stateSerializer);
        graph.addNode("_AGENT_MODEL_", AsyncNodeActionWithConfig.node_async((NodeActionWithConfig)this.llmNode));
        if (this.hasTools.booleanValue()) {
            graph.addNode("_AGENT_TOOL_", AsyncNodeActionWithConfig.node_async((NodeActionWithConfig)this.toolNode));
        }
        this.setupToolsForHooks(this.hooks, this.toolNode);
        List<Hook> list = ReactAgent.filterHooksByPosition(this.hooks, HookPosition.BEFORE_AGENT);
        List<Hook> afterAgentHooks = ReactAgent.filterHooksByPosition(this.hooks, HookPosition.AFTER_AGENT);
        List<Hook> beforeModelHooks = ReactAgent.filterHooksByPosition(this.hooks, HookPosition.BEFORE_MODEL);
        List<Hook> afterModelHooks = ReactAgent.filterHooksByPosition(this.hooks, HookPosition.AFTER_MODEL);
        for (Hook hook : list) {
            if (hook instanceof AgentHook) {
                agentHook = (AgentHook)hook;
                graph.addNode(Hook.getFullHookName(hook) + ".before", agentHook::beforeAgent);
                continue;
            }
            if (!(hook instanceof MessagesAgentHook)) continue;
            messagesAgentHook = (MessagesAgentHook)hook;
            graph.addNode(Hook.getFullHookName(hook) + ".before", (AsyncNodeActionWithConfig)MessagesAgentHook.beforeAgentAction(messagesAgentHook));
        }
        for (Hook hook : afterAgentHooks) {
            if (hook instanceof AgentHook) {
                agentHook = (AgentHook)hook;
                graph.addNode(Hook.getFullHookName(hook) + ".after", agentHook::afterAgent);
                continue;
            }
            if (!(hook instanceof MessagesAgentHook)) continue;
            messagesAgentHook = (MessagesAgentHook)hook;
            graph.addNode(Hook.getFullHookName(hook) + ".after", (AsyncNodeActionWithConfig)MessagesAgentHook.afterAgentAction(messagesAgentHook));
        }
        for (Hook hook : beforeModelHooks) {
            if (hook instanceof ModelHook) {
                modelHook = (ModelHook)hook;
                if (hook instanceof InterruptionHook) {
                    InterruptionHook interruptionHook = (InterruptionHook)hook;
                    graph.addNode(Hook.getFullHookName(hook) + ".beforeModel", (AsyncNodeActionWithConfig)interruptionHook);
                    continue;
                }
                graph.addNode(Hook.getFullHookName(hook) + ".beforeModel", modelHook::beforeModel);
                continue;
            }
            if (!(hook instanceof MessagesModelHook)) continue;
            messagesModelHook = (MessagesModelHook)hook;
            graph.addNode(Hook.getFullHookName(hook) + ".beforeModel", (AsyncNodeActionWithConfig)MessagesModelHook.beforeModelAction(messagesModelHook));
        }
        for (Hook hook : afterModelHooks) {
            if (hook instanceof ModelHook) {
                modelHook = (ModelHook)hook;
                if (hook instanceof HumanInTheLoopHook) {
                    HumanInTheLoopHook humanInTheLoopHook = (HumanInTheLoopHook)hook;
                    graph.addNode(Hook.getFullHookName(hook) + ".afterModel", (AsyncNodeActionWithConfig)humanInTheLoopHook);
                    continue;
                }
                graph.addNode(Hook.getFullHookName(hook) + ".afterModel", modelHook::afterModel);
                continue;
            }
            if (!(hook instanceof MessagesModelHook)) continue;
            messagesModelHook = (MessagesModelHook)hook;
            graph.addNode(Hook.getFullHookName(hook) + ".afterModel", (AsyncNodeActionWithConfig)MessagesModelHook.afterModelAction(messagesModelHook));
        }
        String entryNode = ReactAgent.determineEntryNode(list, beforeModelHooks);
        String loopEntryNode = ReactAgent.determineLoopEntryNode(beforeModelHooks);
        String loopExitNode = ReactAgent.determineLoopExitNode(afterModelHooks);
        String exitNode = ReactAgent.determineExitNode(afterAgentHooks);
        graph.addEdge("__START__", entryNode);
        ReactAgent.setupHookEdges(graph, list, afterAgentHooks, beforeModelHooks, afterModelHooks, entryNode, loopEntryNode, loopExitNode, exitNode, this);
        return graph;
    }

    private void setupToolsForHooks(List<? extends Hook> hooks, AgentToolNode toolNode) {
        if (hooks == null || hooks.isEmpty() || toolNode == null) {
            return;
        }
        List<ToolCallback> availableTools = toolNode.getToolCallbacks();
        if (availableTools == null || availableTools.isEmpty()) {
            return;
        }
        for (Hook hook : hooks) {
            ToolInjection toolInjection;
            ToolCallback toolToInject;
            if (!(hook instanceof ToolInjection) || (toolToInject = this.findToolForHook(toolInjection = (ToolInjection)((Object)hook), availableTools)) == null) continue;
            toolInjection.injectTool(toolToInject);
        }
    }

    private ToolCallback findToolForHook(ToolInjection toolInjection, List<ToolCallback> availableTools) {
        String requiredToolName = toolInjection.getRequiredToolName();
        Class<? extends ToolCallback> requiredToolType = toolInjection.getRequiredToolType();
        if (requiredToolName != null) {
            for (ToolCallback tool : availableTools) {
                String toolName = tool.getToolDefinition().name();
                if (!requiredToolName.equals(toolName)) continue;
                return tool;
            }
        }
        if (requiredToolType != null) {
            for (ToolCallback tool : availableTools) {
                if (!requiredToolType.isInstance(tool)) continue;
                return tool;
            }
        }
        if (requiredToolName == null && requiredToolType == null && !availableTools.isEmpty()) {
            return availableTools.get(0);
        }
        return null;
    }

    private static List<Hook> filterHooksByPosition(List<? extends Hook> hooks, HookPosition position) {
        List filtered = hooks.stream().filter(hook -> {
            HookPosition[] positions = hook.getHookPositions();
            return Arrays.asList(positions).contains((Object)position);
        }).collect(Collectors.toList());
        ArrayList<Hook> prioritizedHooks = new ArrayList<Hook>();
        ArrayList<Hook> nonPrioritizedHooks = new ArrayList<Hook>();
        for (Hook hook2 : filtered) {
            if (hook2 instanceof Prioritized) {
                prioritizedHooks.add(hook2);
                continue;
            }
            nonPrioritizedHooks.add(hook2);
        }
        prioritizedHooks.sort(Comparator.comparingInt(h -> h.getOrder()));
        ArrayList<Hook> result = new ArrayList<Hook>(prioritizedHooks);
        result.addAll(nonPrioritizedHooks);
        return result;
    }

    private static String determineEntryNode(List<Hook> agentHooks, List<Hook> modelHooks) {
        if (!agentHooks.isEmpty()) {
            return Hook.getFullHookName(agentHooks.get(0)) + ".before";
        }
        if (!modelHooks.isEmpty()) {
            return Hook.getFullHookName(modelHooks.get(0)) + ".beforeModel";
        }
        return "_AGENT_MODEL_";
    }

    private static String determineLoopEntryNode(List<Hook> modelHooks) {
        if (!modelHooks.isEmpty()) {
            return Hook.getFullHookName(modelHooks.get(0)) + ".beforeModel";
        }
        return "_AGENT_MODEL_";
    }

    private static String determineLoopExitNode(List<Hook> modelHooks) {
        if (!modelHooks.isEmpty()) {
            return Hook.getFullHookName(modelHooks.get(0)) + ".afterModel";
        }
        return "_AGENT_MODEL_";
    }

    private static String determineExitNode(List<Hook> agentHooks) {
        if (!agentHooks.isEmpty()) {
            return Hook.getFullHookName(agentHooks.get(agentHooks.size() - 1)) + ".after";
        }
        return "__END__";
    }

    private static void setupHookEdges(StateGraph graph, List<Hook> beforeAgentHooks, List<Hook> afterAgentHooks, List<Hook> beforeModelHooks, List<Hook> afterModelHooks, String entryNode, String loopEntryNode, String loopExitNode, String exitNode, ReactAgent agentInstance) throws GraphStateException {
        ReactAgent.chainHook(graph, beforeAgentHooks, ".before", loopEntryNode, loopEntryNode, exitNode);
        ReactAgent.chainHook(graph, beforeModelHooks, ".beforeModel", "_AGENT_MODEL_", loopEntryNode, exitNode);
        if (!afterModelHooks.isEmpty()) {
            ReactAgent.chainModelHookReverse(graph, afterModelHooks, ".afterModel", "_AGENT_MODEL_", loopEntryNode, exitNode);
        }
        if (!afterAgentHooks.isEmpty()) {
            ReactAgent.chainAgentHookReverse(graph, afterAgentHooks, ".after", exitNode, loopEntryNode, exitNode);
        }
        if (agentInstance.hasTools.booleanValue()) {
            ReactAgent.setupToolRouting(graph, loopExitNode, loopEntryNode, exitNode, agentInstance);
        } else if (!loopExitNode.equals("_AGENT_MODEL_")) {
            ReactAgent.addHookEdge(graph, loopExitNode, exitNode, loopEntryNode, exitNode, afterModelHooks.get(afterModelHooks.size() - 1).canJumpTo());
        } else {
            graph.addEdge(loopExitNode, exitNode);
        }
    }

    private static void chainModelHookReverse(StateGraph graph, List<Hook> hooks, String nameSuffix, String defaultNext, String modelDestination, String endDestination) throws GraphStateException {
        graph.addEdge(defaultNext, Hook.getFullHookName(hooks.get(hooks.size() - 1)) + nameSuffix);
        for (int i = hooks.size() - 1; i > 0; --i) {
            Hook m1 = hooks.get(i);
            Hook m2 = hooks.get(i - 1);
            ReactAgent.addHookEdge(graph, Hook.getFullHookName(m1) + nameSuffix, Hook.getFullHookName(m2) + nameSuffix, modelDestination, endDestination, m1.canJumpTo());
        }
    }

    private static void chainAgentHookReverse(StateGraph graph, List<Hook> hooks, String nameSuffix, String defaultNext, String modelDestination, String endDestination) throws GraphStateException {
        if (!hooks.isEmpty()) {
            Hook first = hooks.get(0);
            ReactAgent.addHookEdge(graph, Hook.getFullHookName(first) + nameSuffix, "__END__", modelDestination, endDestination, first.canJumpTo());
        }
        for (int i = hooks.size() - 1; i > 0; --i) {
            Hook m1 = hooks.get(i);
            Hook m2 = hooks.get(i - 1);
            ReactAgent.addHookEdge(graph, Hook.getFullHookName(m1) + nameSuffix, Hook.getFullHookName(m2) + nameSuffix, modelDestination, endDestination, m1.canJumpTo());
        }
    }

    private static void chainHook(StateGraph graph, List<Hook> hooks, String nameSuffix, String defaultNext, String modelDestination, String endDestination) throws GraphStateException {
        for (int i = 0; i < hooks.size() - 1; ++i) {
            Hook m1 = hooks.get(i);
            Hook m2 = hooks.get(i + 1);
            ReactAgent.addHookEdge(graph, Hook.getFullHookName(m1) + nameSuffix, Hook.getFullHookName(m2) + nameSuffix, modelDestination, endDestination, m1.canJumpTo());
        }
        if (!hooks.isEmpty()) {
            Hook last = hooks.get(hooks.size() - 1);
            ReactAgent.addHookEdge(graph, Hook.getFullHookName(last) + nameSuffix, defaultNext, modelDestination, endDestination, last.canJumpTo());
        }
    }

    private static void addHookEdge(StateGraph graph, String name, String defaultDestination, String modelDestination, String endDestination, List<JumpTo> canJumpTo) throws GraphStateException {
        if (canJumpTo != null && !canJumpTo.isEmpty()) {
            EdgeAction router = state -> {
                Object jumpToValue = state.value("jump_to").orElse(null);
                JumpTo jumpTo = null;
                if (jumpToValue != null) {
                    if (jumpToValue instanceof JumpTo) {
                        jumpTo = jumpToValue;
                    } else if (jumpToValue instanceof String) {
                        jumpTo = JumpTo.fromStringOrNull(jumpToValue);
                    }
                }
                return ReactAgent.resolveJump(jumpTo, modelDestination, endDestination, defaultDestination);
            };
            HashMap<String, String> destinations = new HashMap<String, String>();
            destinations.put(defaultDestination, defaultDestination);
            if (canJumpTo.contains((Object)JumpTo.end)) {
                destinations.put(endDestination, endDestination);
            }
            if (canJumpTo.contains((Object)JumpTo.tool)) {
                destinations.put("_AGENT_TOOL_", "_AGENT_TOOL_");
            }
            if (canJumpTo.contains((Object)JumpTo.model) && !name.equals(modelDestination)) {
                destinations.put(modelDestination, modelDestination);
            }
            graph.addConditionalEdges(name, AsyncEdgeAction.edge_async((EdgeAction)router), destinations);
        } else {
            graph.addEdge(name, defaultDestination);
        }
    }

    private static void setupToolRouting(StateGraph graph, String loopExitNode, String loopEntryNode, String exitNode, ReactAgent agentInstance) throws GraphStateException {
        graph.addConditionalEdges(loopExitNode, AsyncEdgeAction.edge_async((EdgeAction)agentInstance.makeModelToTools(loopEntryNode, exitNode)), Map.of("_AGENT_TOOL_", "_AGENT_TOOL_", exitNode, exitNode, loopEntryNode, loopEntryNode));
        graph.addConditionalEdges("_AGENT_TOOL_", AsyncEdgeAction.edge_async((EdgeAction)agentInstance.makeToolsToModelEdge(loopEntryNode, exitNode)), Map.of(loopEntryNode, loopEntryNode, exitNode, exitNode));
    }

    private static String resolveJump(JumpTo jumpTo, String modelDestination, String endDestination, String defaultDestination) {
        if (jumpTo == null) {
            return defaultDestination;
        }
        return switch (jumpTo) {
            default -> throw new IncompatibleClassChangeError();
            case JumpTo.model -> modelDestination;
            case JumpTo.end -> endDestination;
            case JumpTo.tool -> "_AGENT_TOOL_";
        };
    }

    private KeyStrategyFactory buildMessagesKeyStrategyFactory(List<? extends Hook> hooks) {
        return () -> {
            HashMap<String, Object> keyStrategyHashMap = new HashMap<String, Object>();
            if (this.outputKey != null && !this.outputKey.isEmpty()) {
                keyStrategyHashMap.put(this.outputKey, this.outputKeyStrategy == null ? new ReplaceStrategy() : this.outputKeyStrategy);
            }
            keyStrategyHashMap.put("messages", new AppendStrategy());
            if (hooks != null) {
                for (Hook hook : hooks) {
                    Map<String, KeyStrategy> hookStrategies = hook.getKeyStrategys();
                    if (hookStrategies == null || hookStrategies.isEmpty()) continue;
                    keyStrategyHashMap.putAll(hookStrategies);
                }
            }
            return keyStrategyHashMap;
        };
    }

    private EdgeAction makeModelToTools(String modelDestination, String endDestination) {
        return state -> {
            List messages;
            Object jumpToValue = state.value("jump_to").orElse(null);
            if (jumpToValue != null) {
                JumpTo jumpTo = null;
                if (jumpToValue instanceof JumpTo) {
                    jumpTo = jumpToValue;
                } else if (jumpToValue instanceof String) {
                    jumpTo = JumpTo.fromStringOrNull(jumpToValue);
                }
                if (jumpTo != null) {
                    return switch (jumpTo) {
                        default -> throw new IncompatibleClassChangeError();
                        case JumpTo.model -> modelDestination;
                        case JumpTo.end -> endDestination;
                        case JumpTo.tool -> "_AGENT_TOOL_";
                    };
                }
            }
            if ((messages = state.value("messages").orElse(List.of())).isEmpty()) {
                this.logger.warn("No messages found in state when routing from model to tools");
                return endDestination;
            }
            Message lastMessage = (Message)messages.get(messages.size() - 1);
            if (lastMessage instanceof AssistantMessage) {
                AssistantMessage assistantMessage = (AssistantMessage)lastMessage;
                if (assistantMessage.hasToolCalls()) {
                    return "_AGENT_TOOL_";
                }
                return endDestination;
            }
            if (lastMessage instanceof ToolResponseMessage) {
                if (messages.size() < 2) {
                    throw new RuntimeException("Less than 2 messages in state when last message is ToolResponseMessage");
                }
                Message secondLastMessage = (Message)messages.get(messages.size() - 2);
                if (secondLastMessage instanceof AssistantMessage) {
                    AssistantMessage assistantMessage = (AssistantMessage)secondLastMessage;
                    ToolResponseMessage toolResponseMessage = (ToolResponseMessage)lastMessage;
                    if (assistantMessage.hasToolCalls()) {
                        Set requestedToolIds = assistantMessage.getToolCalls().stream().map(AssistantMessage.ToolCall::id).collect(Collectors.toSet());
                        Set executedToolIds = toolResponseMessage.getResponses().stream().map(ToolResponseMessage.ToolResponse::id).collect(Collectors.toSet());
                        if (executedToolIds.containsAll(requestedToolIds)) {
                            return modelDestination;
                        }
                        return "_AGENT_TOOL_";
                    }
                }
            }
            return endDestination;
        };
    }

    private EdgeAction makeToolsToModelEdge(String modelDestination, String endDestination) {
        return state -> {
            boolean allReturnDirect;
            ToolResponseMessage toolResponseMessage = this.fetchLastToolResponseMessage(state);
            if (toolResponseMessage != null && !toolResponseMessage.getResponses().isEmpty() && (allReturnDirect = toolResponseMessage.getResponses().stream().allMatch(toolResponse -> {
                String toolName = toolResponse.name();
                return false;
            }))) {
                return endDestination;
            }
            return modelDestination;
        };
    }

    private ToolResponseMessage fetchLastToolResponseMessage(OverAllState state) {
        List messages = state.value("messages").orElse(List.of());
        ToolResponseMessage toolResponseMessage = null;
        for (int i = messages.size() - 1; i >= 0; --i) {
            if (!(messages.get(i) instanceof ToolResponseMessage)) continue;
            toolResponseMessage = (ToolResponseMessage)messages.get(i);
            break;
        }
        return toolResponseMessage;
    }

    private List<ModelInterceptor> collectAndMergeModelInterceptors() {
        ArrayList<ModelInterceptor> result = new ArrayList<ModelInterceptor>();
        HashSet<String> addedNames = new HashSet<String>();
        if (this.modelInterceptors != null && !this.modelInterceptors.isEmpty()) {
            for (ModelInterceptor modelInterceptor : this.modelInterceptors) {
                result.add(modelInterceptor);
                addedNames.add(modelInterceptor.getName());
            }
        }
        if (this.hooks != null && !this.hooks.isEmpty()) {
            for (Hook hook : this.hooks) {
                List<ModelInterceptor> hookInterceptors = hook.getModelInterceptors();
                if (hookInterceptors == null || hookInterceptors.isEmpty()) continue;
                for (ModelInterceptor interceptor : hookInterceptors) {
                    String name = interceptor.getName();
                    if (!addedNames.contains(name)) {
                        result.add(interceptor);
                        addedNames.add(name);
                        continue;
                    }
                    this.logger.info("Skipping model interceptor '{}' from hook '{}' because an interceptor with the same name already exists in ReactAgent configuration", (Object)name, (Object)hook.getName());
                }
            }
        }
        return result.isEmpty() ? null : result;
    }

    private List<ToolInterceptor> collectAndMergeToolInterceptors() {
        ArrayList<ToolInterceptor> result = new ArrayList<ToolInterceptor>();
        HashSet<String> addedNames = new HashSet<String>();
        if (this.toolInterceptors != null && !this.toolInterceptors.isEmpty()) {
            for (ToolInterceptor toolInterceptor : this.toolInterceptors) {
                result.add(toolInterceptor);
                addedNames.add(toolInterceptor.getName());
            }
        }
        if (this.hooks != null && !this.hooks.isEmpty()) {
            for (Hook hook : this.hooks) {
                List<ToolInterceptor> hookInterceptors = hook.getToolInterceptors();
                if (hookInterceptors == null || hookInterceptors.isEmpty()) continue;
                for (ToolInterceptor interceptor : hookInterceptors) {
                    String name = interceptor.getName();
                    if (!addedNames.contains(name)) {
                        result.add(interceptor);
                        addedNames.add(name);
                        continue;
                    }
                    this.logger.info("Skipping tool interceptor '{}' from hook '{}' because an interceptor with the same name already exists in ReactAgent configuration", (Object)name, (Object)hook.getName());
                }
            }
        }
        return result.isEmpty() ? null : result;
    }

    public String instruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
        this.llmNode.setInstruction(instruction);
    }

    public void setSystemPrompt(String systemPrompt) {
        this.llmNode.setSystemPrompt(systemPrompt);
    }

    public Map<String, Object> getThreadState(String threadId) {
        return (Map)this.threadIdStateMap.get(threadId);
    }

    private class AgentSubGraphNode
    extends Node
    implements SubGraphNode {
        private final CompiledGraph subGraph;

        public AgentSubGraphNode(String id, boolean includeContents, boolean returnReasoningContents, CompiledGraph subGraph, String instruction) {
            super(Objects.requireNonNull(id, "id cannot be null"), config -> {
                ReactAgent reactAgent = ReactAgent.this;
                Objects.requireNonNull(reactAgent);
                return AsyncNodeActionWithConfig.node_async((NodeActionWithConfig)reactAgent.new AgentToSubCompiledGraphNodeAdapter(id, includeContents, returnReasoningContents, subGraph, instruction, config));
            });
            this.subGraph = subGraph;
        }

        public StateGraph subGraph() {
            return this.subGraph.stateGraph;
        }

        public Map<String, KeyStrategy> keyStrategies() {
            return this.subGraph.getKeyStrategyMap();
        }
    }

    public class AgentToSubCompiledGraphNodeAdapter
    implements NodeActionWithConfig,
    ResumableSubGraphAction {
        private String nodeId;
        private boolean includeContents;
        private boolean returnReasoningContents;
        private String instruction;
        private CompiledGraph childGraph;
        private CompileConfig parentCompileConfig;

        public AgentToSubCompiledGraphNodeAdapter(String nodeId, boolean includeContents, boolean returnReasoningContents, CompiledGraph childGraph, String instruction, CompileConfig parentCompileConfig) {
            this.nodeId = nodeId;
            this.includeContents = includeContents;
            this.returnReasoningContents = returnReasoningContents;
            this.instruction = instruction;
            this.childGraph = childGraph;
            this.parentCompileConfig = parentCompileConfig;
        }

        public String getResumeSubGraphId() {
            return ResumableSubGraphAction.resumeSubGraphId((String)this.nodeId);
        }

        public Map<String, Object> apply(OverAllState parentState, RunnableConfig config) throws Exception {
            Flux subGraphResult;
            boolean resumeSubgraph = config.metadata(ResumableSubGraphAction.resumeSubGraphId((String)this.nodeId), (TypeRef)new TypeRef<Boolean>(){}).orElse(false);
            RunnableConfig subGraphRunnableConfig = this.getSubGraphRunnableConfig(config);
            Object parentMessages = null;
            AgentInstructionMessage instructionMessage = null;
            if (StringUtils.hasLength((String)this.instruction)) {
                instructionMessage = AgentInstructionMessage.builder().text(this.instruction).build();
            }
            if (this.includeContents) {
                stateForChild = new HashMap(parentState.data());
                ArrayList<Object> newMessages = stateForChild.get("messages") != null ? new ArrayList((List)stateForChild.remove("messages")) : new ArrayList<AgentInstructionMessage>();
                if (StringUtils.hasLength((String)this.instruction)) {
                    newMessages.add(instructionMessage);
                }
                stateForChild.put("messages", newMessages);
                subGraphResult = this.childGraph.graphResponseStream(stateForChild, subGraphRunnableConfig);
            } else {
                stateForChild = new HashMap(parentState.data());
                parentMessages = stateForChild.remove("messages");
                if (StringUtils.hasLength((String)this.instruction)) {
                    stateForChild.put("messages", instructionMessage);
                }
                subGraphResult = this.childGraph.graphResponseStream(stateForChild, subGraphRunnableConfig);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            String outputKeyToParent = StringUtils.hasLength((String)ReactAgent.this.outputKey) ? ReactAgent.this.outputKey : "messages";
            result.put(outputKeyToParent, this.getGraphResponseFlux(parentState, (Flux<GraphResponse<NodeOutput>>)subGraphResult, instructionMessage));
            if (parentMessages != null) {
                result.put("messages", parentMessages);
            }
            return result;
        }

        @NotNull
        private Flux<GraphResponse<NodeOutput>> getGraphResponseFlux(OverAllState parentState, Flux<GraphResponse<NodeOutput>> subGraphResult, AgentInstructionMessage instructionMessage) {
            return subGraphResult.buffer(2, 1).flatMap(window -> {
                if (window.size() == 1) {
                    return Flux.just(this.processLastResponse((GraphResponse<NodeOutput>)((GraphResponse)window.get(0)), parentState, instructionMessage));
                }
                return Flux.just((Object)((GraphResponse)window.get(0)));
            }, 1);
        }

        private GraphResponse<NodeOutput> processLastResponse(GraphResponse<NodeOutput> lastResponse, OverAllState parentState, AgentInstructionMessage instructionMessage) {
            ArrayList messages;
            Map resultMap;
            Object resultValue;
            if (lastResponse == null) {
                return lastResponse;
            }
            if (lastResponse.resultValue().isPresent() && (resultValue = lastResponse.resultValue().get()) instanceof Map && (resultMap = (Map)resultValue).get("messages") instanceof List && !(messages = new ArrayList((List)resultMap.get("messages"))).isEmpty()) {
                List<AgentInstructionMessage> finalMessages;
                parentState.value("messages").ifPresent(parentMsgs -> {
                    if (parentMsgs instanceof List) {
                        messages.removeAll((List)parentMsgs);
                    }
                });
                if (this.returnReasoningContents) {
                    finalMessages = messages;
                } else if (!messages.isEmpty()) {
                    if (instructionMessage != null) {
                        finalMessages = new ArrayList();
                        finalMessages.add(instructionMessage);
                        finalMessages.add((AgentInstructionMessage)messages.get(messages.size() - 1));
                    } else {
                        finalMessages = List.of(messages.get(messages.size() - 1));
                    }
                } else {
                    finalMessages = List.of();
                }
                HashMap newResultMap = new HashMap(resultMap);
                newResultMap.put("messages", finalMessages);
                return GraphResponse.done(newResultMap);
            }
            return lastResponse;
        }

        private RunnableConfig getSubGraphRunnableConfig(RunnableConfig config) {
            RunnableConfig subGraphRunnableConfig = ((RunnableConfig.Builder)RunnableConfig.builder((RunnableConfig)config).checkPointId(null).nextNode(null).addMetadata("_AGENT_", (Object)ResumableSubGraphAction.subGraphId((String)this.nodeId))).build();
            subGraphRunnableConfig.clearContext();
            Optional parentSaver = this.parentCompileConfig.checkpointSaver();
            Optional subGraphSaver = this.childGraph.compileConfig.checkpointSaver();
            if (subGraphSaver.isPresent()) {
                if (parentSaver.isEmpty()) {
                    throw new IllegalStateException("Missing CheckpointSaver in parent graph!");
                }
                if (parentSaver.get() == subGraphSaver.get()) {
                    subGraphRunnableConfig = ((RunnableConfig.Builder)RunnableConfig.builder((RunnableConfig)config).threadId(config.threadId().map(threadId -> String.format("%s_%s", threadId, ResumableSubGraphAction.subGraphId((String)this.nodeId))).orElseGet(() -> ResumableSubGraphAction.subGraphId((String)this.nodeId))).nextNode(null).checkPointId(null).addMetadata("_AGENT_", (Object)ResumableSubGraphAction.subGraphId((String)this.nodeId))).build();
                    subGraphRunnableConfig.clearContext();
                }
            }
            return subGraphRunnableConfig;
        }
    }
}

