/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent;

import com.alibaba.cloud.ai.graph.agent.Builder;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.agent.interceptor.Interceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolInterceptor;
import com.alibaba.cloud.ai.graph.agent.node.AgentLlmNode;
import com.alibaba.cloud.ai.graph.agent.node.AgentToolNode;
import io.micrometer.observation.ObservationRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.execution.DefaultToolExecutionExceptionProcessor;
import org.springframework.ai.tool.execution.ToolExecutionExceptionProcessor;
import org.springframework.util.StringUtils;

public class DefaultBuilder
extends Builder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBuilder.class);
    public static final String POSSIBLE_LLM_TOOL_NAME_CHANGE_WARNING = "LLM may have adapted the tool name '{}', especially if the name was truncated due to length limits. If this is the case, you can customize the prefixing and processing logic using McpToolNamePrefixGenerator";

    @Override
    public ReactAgent build() {
        List<ToolCallback> allTools;
        if (!StringUtils.hasText((String)this.name)) {
            throw new IllegalArgumentException("Agent name must not be empty");
        }
        if (this.chatClient == null && this.model == null) {
            throw new IllegalArgumentException("Either chatClient or model must be provided");
        }
        if (this.chatClient == null) {
            ChatClient.Builder clientBuilder = ChatClient.builder((ChatModel)this.model, (ObservationRegistry)(this.observationRegistry == null ? ObservationRegistry.NOOP : this.observationRegistry), (ChatClientObservationConvention)this.customObservationConvention, (AdvisorObservationConvention)this.advisorObservationConvention);
            if (this.chatOptions != null) {
                clientBuilder.defaultOptions(this.chatOptions);
            }
            this.chatClient = clientBuilder.build();
        }
        AgentLlmNode.Builder llmNodeBuilder = AgentLlmNode.builder().agentName(this.name).chatOptions(this.chatOptions).chatClient(this.chatClient);
        if (this.outputKey != null && !this.outputKey.isEmpty()) {
            llmNodeBuilder.outputKey(this.outputKey);
        }
        if (this.systemPrompt != null) {
            llmNodeBuilder.systemPrompt(this.systemPrompt);
        }
        if (this.templateRenderer != null) {
            llmNodeBuilder.templateRenderer(this.templateRenderer);
        }
        if (this.instruction != null) {
            llmNodeBuilder.instruction(this.instruction);
        }
        String outputSchema = null;
        if (StringUtils.hasLength((String)this.outputSchema)) {
            outputSchema = this.outputSchema;
        } else if (this.outputType != null) {
            BeanOutputConverter formatProvider = new BeanOutputConverter(this.outputType);
            outputSchema = formatProvider.getFormat();
        }
        if (StringUtils.hasLength((String)outputSchema)) {
            llmNodeBuilder.outputSchema(outputSchema);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.interceptors)) {
            this.modelInterceptors = new ArrayList();
            this.toolInterceptors = new ArrayList();
            for (Interceptor interceptor : this.interceptors) {
                if (interceptor instanceof ModelInterceptor) {
                    this.modelInterceptors.add((ModelInterceptor)interceptor);
                }
                if (!(interceptor instanceof ToolInterceptor)) continue;
                this.toolInterceptors.add((ToolInterceptor)interceptor);
            }
        }
        if (CollectionUtils.isNotEmpty(allTools = this.gatherLocalTools())) {
            llmNodeBuilder.toolCallbacks(Collections.unmodifiableList(allTools));
        }
        if (this.enableLogging) {
            llmNodeBuilder.enableReasoningLog(true);
        }
        AgentLlmNode llmNode = llmNodeBuilder.build();
        AgentToolNode.Builder toolBuilder = AgentToolNode.builder().agentName(this.name).parallelToolExecution(this.parallelToolExecution).maxParallelTools(this.maxParallelTools).toolExecutionTimeout(this.toolExecutionTimeout).wrapSyncToolsAsAsync(this.wrapSyncToolsAsAsync);
        if (this.resolver != null) {
            toolBuilder.toolCallbackResolver(this.resolver);
        }
        if (CollectionUtils.isNotEmpty(allTools)) {
            toolBuilder.toolCallbacks(allTools);
        }
        if (this.enableLogging) {
            toolBuilder.enableActingLog(true);
        }
        if (this.toolExecutionExceptionProcessor == null) {
            toolBuilder.toolExecutionExceptionProcessor((ToolExecutionExceptionProcessor)DefaultToolExecutionExceptionProcessor.builder().alwaysThrow(false).build());
        } else {
            toolBuilder.toolExecutionExceptionProcessor(this.toolExecutionExceptionProcessor);
        }
        if (this.toolContext != null && !this.toolContext.isEmpty()) {
            toolBuilder.toolContext(this.toolContext);
        }
        AgentToolNode toolNode = toolBuilder.build();
        return new ReactAgent(llmNode, toolNode, this.buildConfig(), this);
    }

    protected List<ToolCallback> gatherLocalTools() {
        ArrayList<Object> regularTools;
        block19: {
            regularTools = new ArrayList<Object>();
            if (CollectionUtils.isNotEmpty((Collection)this.tools)) {
                regularTools.addAll(this.tools);
            }
            if (CollectionUtils.isNotEmpty((Collection)this.toolCallbackProviders)) {
                for (ToolCallbackProvider provider : this.toolCallbackProviders) {
                    regularTools.addAll(List.of(provider.getToolCallbacks()));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)this.toolNames)) {
                for (Object toolName : this.toolNames) {
                    if (regularTools.stream().anyMatch(arg_0 -> DefaultBuilder.lambda$gatherLocalTools$0((String)toolName, arg_0))) continue;
                    if (this.resolver == null) {
                        throw new IllegalStateException("ToolCallbackResolver is null; cannot resolve tool name: " + (String)toolName);
                    }
                    ToolCallback toolCallback = this.resolver.resolve((String)toolName);
                    if (toolCallback == null) {
                        logger.warn(POSSIBLE_LLM_TOOL_NAME_CHANGE_WARNING, toolName);
                        throw new IllegalStateException("No ToolCallback found for tool name: " + (String)toolName);
                    }
                    regularTools.add(toolCallback);
                }
            }
            if (regularTools.isEmpty() && this.resolver != null) {
                Object toolName;
                toolName = this.resolver;
                if (toolName instanceof ToolCallbackProvider) {
                    ToolCallbackProvider provider = (ToolCallbackProvider)toolName;
                    ToolCallback[] resolverTools = provider.getToolCallbacks();
                    if (resolverTools != null && resolverTools.length > 0) {
                        regularTools.addAll(List.of(resolverTools));
                        if (logger.isDebugEnabled()) {
                            logger.debug("Extracted {} tools from ToolCallbackResolver (ToolCallbackProvider)", (Object)resolverTools.length);
                        }
                    }
                } else {
                    try {
                        Map toolsMap;
                        Field toolsField = this.resolver.getClass().getDeclaredField("tools");
                        toolsField.setAccessible(true);
                        Object toolsObj = toolsField.get(this.resolver);
                        if (toolsObj instanceof Map && !(toolsMap = (Map)toolsObj).isEmpty()) {
                            regularTools.addAll(toolsMap.values());
                            if (logger.isDebugEnabled()) {
                                logger.debug("Extracted {} tools from ToolCallbackResolver via reflection", (Object)toolsMap.size());
                            }
                        }
                    }
                    catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                        if (!logger.isTraceEnabled()) break block19;
                        logger.trace("Could not extract tools from resolver via reflection: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        List<Object> interceptorTools = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)this.modelInterceptors)) {
            interceptorTools = this.modelInterceptors.stream().flatMap(interceptor -> interceptor.getTools().stream()).toList();
        }
        ArrayList<ToolCallback> hookTools = new ArrayList<ToolCallback>();
        if (CollectionUtils.isNotEmpty((Collection)this.hooks)) {
            for (Hook hook : this.hooks) {
                List<ToolCallback> toolsFromHook = hook.getTools();
                if (!CollectionUtils.isNotEmpty(toolsFromHook)) continue;
                hookTools.addAll(toolsFromHook);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Collected {} tools from hook '{}'", (Object)toolsFromHook.size(), (Object)hook.getName());
            }
        }
        ArrayList<ToolCallback> allTools = new ArrayList<ToolCallback>();
        allTools.addAll(hookTools);
        allTools.addAll(interceptorTools);
        allTools.addAll(regularTools);
        return allTools;
    }

    private static /* synthetic */ boolean lambda$gatherLocalTools$0(String toolName, ToolCallback tool) {
        return tool.getToolDefinition().name().equals(toolName);
    }
}

