/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent;

import com.alibaba.cloud.ai.graph.CompileConfig;
import com.alibaba.cloud.ai.graph.KeyStrategy;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.agent.interceptor.Interceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolInterceptor;
import com.alibaba.cloud.ai.graph.checkpoint.BaseCheckpointSaver;
import com.alibaba.cloud.ai.graph.checkpoint.config.SaverConfig;
import com.alibaba.cloud.ai.graph.serializer.StateSerializer;
import com.alibaba.cloud.ai.graph.serializer.std.SpringAIStateSerializer;
import io.micrometer.observation.ObservationRegistry;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.support.ToolCallbacks;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.execution.ToolExecutionExceptionProcessor;
import org.springframework.ai.tool.resolution.ToolCallbackResolver;
import org.springframework.util.Assert;

public abstract class Builder {
    protected String name;
    protected String description;
    protected String instruction;
    protected String systemPrompt;
    protected TemplateRenderer templateRenderer;
    protected ChatModel model;
    protected ChatOptions chatOptions;
    protected ChatClient chatClient;
    protected List<ToolCallback> tools = new ArrayList<ToolCallback>();
    protected List<ToolCallbackProvider> toolCallbackProviders = new ArrayList<ToolCallbackProvider>();
    protected List<String> toolNames = new ArrayList<String>();
    protected ToolCallbackResolver resolver;
    protected ToolExecutionExceptionProcessor toolExecutionExceptionProcessor;
    protected Map<String, Object> toolContext = new HashMap<String, Object>();
    protected boolean releaseThread;
    protected BaseCheckpointSaver saver;
    protected CompileConfig compileConfig;
    protected List<Hook> hooks = new ArrayList<Hook>();
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    protected List<ModelInterceptor> modelInterceptors = new ArrayList<ModelInterceptor>();
    protected List<ToolInterceptor> toolInterceptors = new ArrayList<ToolInterceptor>();
    protected boolean includeContents = true;
    protected boolean returnReasoningContents;
    protected String outputKey;
    protected KeyStrategy outputKeyStrategy;
    protected String inputSchema;
    protected Type inputType;
    protected String outputSchema;
    protected Class<?> outputType;
    protected ObservationRegistry observationRegistry;
    protected ChatClientObservationConvention customObservationConvention;
    protected AdvisorObservationConvention advisorObservationConvention;
    protected boolean enableLogging;
    protected StateSerializer stateSerializer;
    protected Executor executor;
    protected boolean parallelToolExecution = false;
    protected int maxParallelTools = 5;
    protected Duration toolExecutionTimeout = Duration.ofMinutes(5L);
    protected boolean wrapSyncToolsAsAsync = false;

    public Builder name(String name) {
        this.name = name;
        return this;
    }

    @Deprecated
    public Builder chatClient(ChatClient chatClient) {
        this.chatClient = chatClient;
        return this;
    }

    public Builder model(ChatModel model) {
        this.model = model;
        return this;
    }

    public Builder chatOptions(ChatOptions chatOptions) {
        this.chatOptions = chatOptions;
        return this;
    }

    public Builder tools(List<ToolCallback> tools) {
        Assert.notNull(tools, (String)"tools cannot be null");
        Assert.noNullElements(tools, (String)"tools cannot contain null elements");
        this.tools.addAll(tools);
        return this;
    }

    public Builder tools(ToolCallback ... tools) {
        Assert.notNull((Object)tools, (String)"tools cannot be null");
        Assert.noNullElements((Object[])tools, (String)"tools cannot contain null elements");
        this.tools.addAll(List.of(tools));
        return this;
    }

    public Builder methodTools(Object ... toolObjects) {
        Assert.notNull((Object)toolObjects, (String)"toolObjects cannot be null");
        Assert.noNullElements((Object[])toolObjects, (String)"toolObjects cannot contain null elements");
        this.tools.addAll(Arrays.asList(ToolCallbacks.from((Object[])toolObjects)));
        return this;
    }

    public Builder toolCallbackProviders(ToolCallbackProvider ... toolCallbackProviders) {
        Assert.notNull((Object)toolCallbackProviders, (String)"toolCallbackProviders cannot be null");
        Assert.noNullElements((Object[])toolCallbackProviders, (String)"toolCallbackProviders cannot contain null elements");
        this.toolCallbackProviders.addAll(List.of(toolCallbackProviders));
        return this;
    }

    public Builder toolNames(String ... toolNames) {
        Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements((Object[])toolNames, (String)"toolNames cannot contain null elements");
        this.toolNames.addAll(List.of(toolNames));
        return this;
    }

    public Builder resolver(ToolCallbackResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public Builder toolExecutionExceptionProcessor(ToolExecutionExceptionProcessor toolExecutionExceptionProcessor) {
        this.toolExecutionExceptionProcessor = toolExecutionExceptionProcessor;
        return this;
    }

    public Builder toolContext(Map<String, Object> toolContext) {
        Assert.notNull(toolContext, (String)"toolContext cannot be null");
        Assert.noNullElements(toolContext.keySet(), (String)"toolContext keys cannot contain null elements");
        Assert.noNullElements(toolContext.values(), (String)"toolContext values cannot contain null elements");
        this.toolContext.putAll(toolContext);
        return this;
    }

    public Builder releaseThread(boolean releaseThread) {
        this.releaseThread = releaseThread;
        return this;
    }

    public Builder saver(BaseCheckpointSaver saver) {
        Assert.notNull((Object)saver, (String)"saver cannot be null");
        this.saver = saver;
        return this;
    }

    public Builder compileConfig(CompileConfig compileConfig) {
        Assert.notNull((Object)compileConfig, (String)"compileConfig cannot be null");
        this.compileConfig = compileConfig;
        return this;
    }

    public Builder description(String description) {
        this.description = description;
        return this;
    }

    public Builder instruction(String instruction) {
        this.instruction = instruction;
        return this;
    }

    public Builder systemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
        return this;
    }

    public Builder templateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
        return this;
    }

    public Builder outputKey(String outputKey) {
        this.outputKey = outputKey;
        return this;
    }

    public Builder outputKeyStrategy(KeyStrategy outputKeyStrategy) {
        this.outputKeyStrategy = outputKeyStrategy;
        return this;
    }

    public Builder inputSchema(String inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    public Builder inputType(Type inputType) {
        this.inputType = inputType;
        return this;
    }

    public Builder outputSchema(String outputSchema) {
        this.outputSchema = outputSchema;
        return this;
    }

    public Builder outputType(Class<?> outputType) {
        this.outputType = outputType;
        return this;
    }

    public Builder includeContents(boolean includeContents) {
        this.includeContents = includeContents;
        return this;
    }

    public Builder returnReasoningContents(boolean returnReasoningContents) {
        this.returnReasoningContents = returnReasoningContents;
        return this;
    }

    public Builder hooks(List<? extends Hook> hooks) {
        Assert.notNull(hooks, (String)"hooks cannot be null");
        Assert.noNullElements(hooks, (String)"hooks cannot contain null elements");
        this.hooks.addAll(hooks);
        return this;
    }

    public Builder hooks(Hook ... hooks) {
        Assert.notNull((Object)hooks, (String)"hooks cannot be null");
        Assert.noNullElements((Object[])hooks, (String)"hooks cannot contain null elements");
        this.hooks.addAll(List.of(hooks));
        return this;
    }

    public Builder interceptors(List<? extends Interceptor> interceptors) {
        Assert.notNull(interceptors, (String)"interceptors cannot be null");
        Assert.noNullElements(interceptors, (String)"interceptors cannot contain null elements");
        this.interceptors.addAll(interceptors);
        return this;
    }

    public Builder interceptors(Interceptor ... interceptors) {
        Assert.notNull((Object)interceptors, (String)"interceptors cannot be null");
        Assert.noNullElements((Object[])interceptors, (String)"interceptors cannot contain null elements");
        this.interceptors.addAll(List.of(interceptors));
        return this;
    }

    public Builder observationRegistry(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
        return this;
    }

    public Builder customObservationConvention(ChatClientObservationConvention customObservationConvention) {
        this.customObservationConvention = customObservationConvention;
        return this;
    }

    public Builder advisorObservationConvention(AdvisorObservationConvention advisorObservationConvention) {
        this.advisorObservationConvention = advisorObservationConvention;
        return this;
    }

    public Builder enableLogging(boolean enableLogging) {
        this.enableLogging = enableLogging;
        return this;
    }

    public Builder stateSerializer(StateSerializer stateSerializer) {
        this.stateSerializer = stateSerializer;
        return this;
    }

    @Deprecated
    public Builder stateSerializer(SpringAIStateSerializer stateSerializer) {
        this.stateSerializer = stateSerializer;
        return this;
    }

    public Builder executor(Executor executor) {
        Assert.notNull((Object)executor, (String)"executor cannot be null");
        this.executor = executor;
        return this;
    }

    public Builder parallelToolExecution(boolean parallel) {
        this.parallelToolExecution = parallel;
        return this;
    }

    public Builder maxParallelTools(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("maxParallelTools must be at least 1");
        }
        this.maxParallelTools = max;
        return this;
    }

    public Builder toolExecutionTimeout(Duration timeout) {
        this.toolExecutionTimeout = Objects.requireNonNull(timeout, "timeout cannot be null");
        return this;
    }

    public Builder wrapSyncToolsAsAsync(boolean wrap) {
        this.wrapSyncToolsAsAsync = wrap;
        return this;
    }

    protected CompileConfig buildConfig() {
        if (this.compileConfig != null) {
            return this.compileConfig;
        }
        SaverConfig saverConfig = SaverConfig.builder().register(this.saver).build();
        return CompileConfig.builder().saverConfig(saverConfig).recursionLimit(Integer.MAX_VALUE).releaseThread(this.releaseThread).build();
    }

    public abstract ReactAgent build();
}

