/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent;

import com.alibaba.cloud.ai.graph.CompileConfig;
import com.alibaba.cloud.ai.graph.CompiledGraph;
import com.alibaba.cloud.ai.graph.NodeOutput;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.exception.GraphRunnerException;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.scheduling.ScheduleConfig;
import com.alibaba.cloud.ai.graph.scheduling.ScheduledAgentTask;
import com.alibaba.cloud.ai.graph.state.StateSnapshot;
import com.alibaba.cloud.ai.graph.streaming.OutputType;
import com.alibaba.cloud.ai.graph.streaming.StreamingOutput;
import com.alibaba.cloud.ai.graph.utils.Messageutils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.scheduling.Trigger;
import reactor.core.publisher.Flux;

public abstract class Agent {
    protected String name;
    protected String description;
    protected CompileConfig compileConfig;
    protected volatile CompiledGraph compiledGraph;
    protected volatile StateGraph graph;
    protected Executor executor;

    protected Agent(String name, String description) {
        this.name = name;
        this.description = description;
    }

    protected Agent() {
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public StateGraph getGraph() {
        if (this.graph == null) {
            try {
                this.graph = this.initGraph();
            }
            catch (GraphStateException e) {
                throw new RuntimeException(e);
            }
        }
        return this.graph;
    }

    public synchronized CompiledGraph getAndCompileGraph() {
        if (this.compiledGraph != null) {
            return this.compiledGraph;
        }
        StateGraph graph = this.getGraph();
        try {
            this.compiledGraph = this.compileConfig == null ? graph.compile() : graph.compile(this.compileConfig);
        }
        catch (GraphStateException e) {
            throw new RuntimeException(e);
        }
        return this.compiledGraph;
    }

    public ScheduledAgentTask schedule(Trigger trigger, Map<String, Object> input) throws GraphStateException, GraphRunnerException {
        ScheduleConfig scheduleConfig = ScheduleConfig.builder().trigger(trigger).inputs(input).build();
        return this.schedule(scheduleConfig);
    }

    public ScheduledAgentTask schedule(ScheduleConfig scheduleConfig) throws GraphStateException {
        CompiledGraph compiledGraph = this.getAndCompileGraph();
        return compiledGraph.schedule(scheduleConfig);
    }

    public StateSnapshot getCurrentState(RunnableConfig config) throws GraphRunnerException {
        return this.compiledGraph.getState(config);
    }

    public Optional<OverAllState> invoke(String message) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doInvoke(inputs, null);
    }

    public Optional<OverAllState> invoke(String message, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doInvoke(inputs, config);
    }

    public Optional<OverAllState> invoke(UserMessage message) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doInvoke(inputs, null);
    }

    public Optional<OverAllState> invoke(UserMessage message, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doInvoke(inputs, config);
    }

    public Optional<OverAllState> invoke(List<Message> messages) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(messages);
        return this.doInvoke(inputs, null);
    }

    public Optional<OverAllState> invoke(List<Message> messages, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(messages);
        return this.doInvoke(inputs, config);
    }

    public Optional<OverAllState> invoke(Map<String, Object> inputs) throws GraphRunnerException {
        return this.doInvoke(inputs, null);
    }

    public Optional<OverAllState> invoke(Map<String, Object> inputs, RunnableConfig config) throws GraphRunnerException {
        return this.doInvoke(inputs, config);
    }

    public Optional<NodeOutput> invokeAndGetOutput(String message) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doInvokeAndGetOutput(inputs, null);
    }

    public Optional<NodeOutput> invokeAndGetOutput(String message, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doInvokeAndGetOutput(inputs, config);
    }

    public Optional<NodeOutput> invokeAndGetOutput(UserMessage message) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doInvokeAndGetOutput(inputs, null);
    }

    public Optional<NodeOutput> invokeAndGetOutput(UserMessage message, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doInvokeAndGetOutput(inputs, config);
    }

    public Optional<NodeOutput> invokeAndGetOutput(List<Message> messages) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(messages);
        return this.doInvokeAndGetOutput(inputs, null);
    }

    public Optional<NodeOutput> invokeAndGetOutput(List<Message> messages, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(messages);
        return this.doInvokeAndGetOutput(inputs, config);
    }

    public Optional<NodeOutput> invokeAndGetOutput(Map<String, Object> inputs) throws GraphRunnerException {
        return this.doInvokeAndGetOutput(inputs, null);
    }

    public Optional<NodeOutput> invokeAndGetOutput(Map<String, Object> inputs, RunnableConfig config) throws GraphRunnerException {
        return this.doInvokeAndGetOutput(inputs, config);
    }

    public Flux<Message> streamMessages(String message) throws GraphRunnerException {
        return this.stream(message).transform(this::extractMessages);
    }

    public Flux<Message> streamMessages(String message, RunnableConfig config) throws GraphRunnerException {
        return this.stream(message, config).transform(this::extractMessages);
    }

    public Flux<Message> streamMessages(UserMessage message) throws GraphRunnerException {
        return this.stream(message).transform(this::extractMessages);
    }

    public Flux<Message> streamMessages(UserMessage message, RunnableConfig config) throws GraphRunnerException {
        return this.stream(message, config).transform(this::extractMessages);
    }

    public Flux<Message> streamMessages(List<Message> messages) throws GraphRunnerException {
        return this.stream(messages).transform(this::extractMessages);
    }

    public Flux<Message> streamMessages(List<Message> messages, RunnableConfig config) throws GraphRunnerException {
        return this.stream(messages, config).transform(this::extractMessages);
    }

    public Flux<Message> streamMessages(Map<String, Object> inputs) throws GraphRunnerException {
        return this.stream(inputs).transform(this::extractMessages);
    }

    public Flux<Message> streamMessages(Map<String, Object> inputs, RunnableConfig config) throws GraphRunnerException {
        return this.stream(inputs, config).transform(this::extractMessages);
    }

    public Flux<NodeOutput> stream(String message) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doStream(inputs, this.buildStreamConfig(null));
    }

    public Flux<NodeOutput> stream(String message, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doStream(inputs, config);
    }

    public Flux<NodeOutput> stream(UserMessage message) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doStream(inputs, this.buildStreamConfig(null));
    }

    public Flux<NodeOutput> stream(UserMessage message, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        return this.doStream(inputs, config);
    }

    public Flux<NodeOutput> stream(List<Message> messages) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(messages);
        return this.doStream(inputs, this.buildStreamConfig(null));
    }

    public Flux<NodeOutput> stream(List<Message> messages, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(messages);
        return this.doStream(inputs, config);
    }

    public Flux<NodeOutput> stream(Map<String, Object> inputs) throws GraphRunnerException {
        return this.doStream(inputs, this.buildStreamConfig(null));
    }

    public Flux<NodeOutput> stream(Map<String, Object> inputs, RunnableConfig config) throws GraphRunnerException {
        return this.doStream(inputs, config);
    }

    protected Optional<OverAllState> doInvoke(Map<String, Object> input, RunnableConfig runnableConfig) {
        CompiledGraph compiledGraph = this.getAndCompileGraph();
        return compiledGraph.invoke(input, this.buildNonStreamConfig(runnableConfig));
    }

    protected Optional<NodeOutput> doInvokeAndGetOutput(Map<String, Object> input, RunnableConfig runnableConfig) {
        CompiledGraph compiledGraph = this.getAndCompileGraph();
        return compiledGraph.invokeAndGetOutput(input, this.buildNonStreamConfig(runnableConfig));
    }

    protected Flux<NodeOutput> doStream(Map<String, Object> input, RunnableConfig runnableConfig) {
        CompiledGraph compiledGraph = this.getAndCompileGraph();
        return compiledGraph.stream(input, this.buildStreamConfig(runnableConfig));
    }

    protected RunnableConfig buildNonStreamConfig(RunnableConfig config) {
        RunnableConfig.Builder builder = config == null ? RunnableConfig.builder() : RunnableConfig.builder((RunnableConfig)config);
        ((RunnableConfig.Builder)builder.addMetadata("_stream_", (Object)false)).addMetadata("_AGENT_", (Object)this.name);
        this.applyExecutorConfig(builder);
        return builder.build();
    }

    protected RunnableConfig buildStreamConfig(RunnableConfig config) {
        RunnableConfig.Builder builder = config == null ? RunnableConfig.builder() : RunnableConfig.builder((RunnableConfig)config);
        builder.addMetadata("_AGENT_", (Object)this.name);
        this.applyExecutorConfig(builder);
        return builder.build();
    }

    protected void applyExecutorConfig(RunnableConfig.Builder builder) {
        if (this.executor != null) {
            builder.defaultParallelExecutor(this.executor);
        }
    }

    protected Map<String, Object> buildMessageInput(Object message) {
        List messages = message instanceof List ? (List)message : Messageutils.convertToMessages((Object)message);
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("messages", messages);
        UserMessage lastUserMessage = null;
        for (int i = messages.size() - 1; i >= 0; --i) {
            Message msg = (Message)messages.get(i);
            if (!(msg instanceof UserMessage)) continue;
            lastUserMessage = (UserMessage)msg;
            break;
        }
        if (lastUserMessage != null) {
            inputs.put("input", lastUserMessage.getText());
        }
        return inputs;
    }

    protected abstract StateGraph initGraph() throws GraphStateException;

    private Flux<Message> extractMessages(Flux<NodeOutput> stream) {
        return stream.filter(o -> {
            StreamingOutput so;
            return o instanceof StreamingOutput && this.isMessageOutputType((so = (StreamingOutput)o).getOutputType()) && so.message() != null;
        }).map(o -> ((StreamingOutput)o).message());
    }

    private boolean isMessageOutputType(OutputType type) {
        return type == OutputType.AGENT_MODEL_STREAMING || type == OutputType.AGENT_TOOL_FINISHED;
    }
}

