/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm;

import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.LabelNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import com.alibaba.deps.org.objectweb.asm.tree.TryCatchBlockNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class TryCatchBlock {
    private final MethodNode methodNode;
    private final LabelNode startLabelNode = new LabelNode();
    private final LabelNode endLabelNode = new LabelNode();

    public TryCatchBlock(MethodNode methodNode) {
        this(methodNode, Type.getType(Throwable.class).getInternalName());
    }

    public TryCatchBlock(MethodNode methodNode, String exception) {
        this.methodNode = methodNode;
        TryCatchBlockNode tryCatchBlockNode = new TryCatchBlockNode(this.startLabelNode, this.endLabelNode, this.endLabelNode, exception);
        if (this.methodNode.tryCatchBlocks == null) {
            this.methodNode.tryCatchBlocks = new ArrayList();
        }
        this.methodNode.tryCatchBlocks.add(tryCatchBlockNode);
    }

    public LabelNode getStartLabelNode() {
        return this.startLabelNode;
    }

    public LabelNode getEndLabelNode() {
        return this.endLabelNode;
    }

    public void sort() {
        if (this.methodNode.tryCatchBlocks == null) {
            return;
        }
        Collections.sort(this.methodNode.tryCatchBlocks, new Comparator<TryCatchBlockNode>(){

            @Override
            public int compare(TryCatchBlockNode t1, TryCatchBlockNode t2) {
                int len1 = this.blockLength(t1);
                int len2 = this.blockLength(t2);
                return len1 - len2;
            }

            private int blockLength(TryCatchBlockNode block) {
                int startidx = ((TryCatchBlock)TryCatchBlock.this).methodNode.instructions.indexOf((AbstractInsnNode)block.start);
                int endidx = ((TryCatchBlock)TryCatchBlock.this).methodNode.instructions.indexOf((AbstractInsnNode)block.end);
                return endidx - startidx;
            }
        });
        for (int i = 0; i < this.methodNode.tryCatchBlocks.size(); ++i) {
            ((TryCatchBlockNode)this.methodNode.tryCatchBlocks.get(i)).updateIndex(i);
        }
    }
}

