/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.binding;

import com.alibaba.bytekit.asm.binding.Binding;
import com.alibaba.bytekit.asm.binding.BindingContext;
import com.alibaba.bytekit.utils.AsmOpUtils;
import com.alibaba.bytekit.utils.MatchUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.deps.org.objectweb.asm.tree.LocalVariableNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LocalVarNamesBinding
extends Binding {
    private String excludePattern;
    private boolean ignoreThis;

    public LocalVarNamesBinding(String excludePattern, boolean ignoreThis) {
        this.excludePattern = excludePattern;
        this.ignoreThis = ignoreThis;
    }

    public LocalVarNamesBinding() {
    }

    @Override
    public void pushOntoStack(InsnList instructions, BindingContext bindingContext) {
        AbstractInsnNode currentInsnNode = bindingContext.getLocation().getInsnNode();
        LinkedList<LocalVariableNode> localVariables = new LinkedList<LocalVariableNode>(bindingContext.getMethodProcessor().getMethodNode().localVariables);
        if (this.excludePattern != null && !this.excludePattern.isEmpty()) {
            Iterator it = localVariables.iterator();
            while (it.hasNext()) {
                LocalVariableNode localVariableNode = (LocalVariableNode)it.next();
                if (MatchUtils.wildcardMatch(localVariableNode.name, this.excludePattern)) {
                    it.remove();
                }
                if (!this.ignoreThis || !localVariableNode.name.equals("this")) continue;
                it.remove();
            }
        }
        List<LocalVariableNode> results = AsmOpUtils.validVariables(localVariables, currentInsnNode);
        AsmOpUtils.push(instructions, results.size());
        AsmOpUtils.newArray(instructions, AsmOpUtils.STRING_TYPE);
        for (int i = 0; i < results.size(); ++i) {
            AsmOpUtils.dup(instructions);
            AsmOpUtils.push(instructions, i);
            AsmOpUtils.push(instructions, results.get((int)i).name);
            AsmOpUtils.arrayStore(instructions, AsmOpUtils.STRING_TYPE);
        }
    }

    @Override
    public Type getType(BindingContext bindingContext) {
        return AsmOpUtils.STRING_ARRAY_TYPE;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }
}

