/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.instrument;

import com.alibaba.bytekit.asm.inst.impl.InstrumentImpl;
import com.alibaba.bytekit.asm.instrument.DefineConfig;
import com.alibaba.bytekit.asm.instrument.InstrumentConfig;
import com.alibaba.bytekit.asm.instrument.InstrumentParseResult;
import com.alibaba.bytekit.log.Logger;
import com.alibaba.bytekit.log.Loggers;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.bytekit.utils.ReflectUtils;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import com.alibaba.deps.org.objectweb.asm.tree.ClassNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.List;

public class InstrumentTransformer
implements ClassFileTransformer {
    private final Logger logger = Loggers.getLogger(this.getClass());
    private InstrumentParseResult instrumentParseResult;

    public InstrumentTransformer(InstrumentParseResult instrumentParseResult) {
        this.instrumentParseResult = instrumentParseResult;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        List<InstrumentConfig> instrumentConfigs = this.instrumentParseResult.getInstrumentConfigs();
        ClassNode originClassNode = null;
        ClassNode targetClassNode = null;
        ClassReader classReader = null;
        for (InstrumentConfig config : instrumentConfigs) {
            if (!config.getClassMatcher().match(loader, className, classBeingRedefined, protectionDomain, classfileBuffer)) continue;
            if (originClassNode == null) {
                originClassNode = new ClassNode(589824);
                classReader = AsmUtils.toClassNode(classfileBuffer, originClassNode);
                originClassNode = AsmUtils.removeJSRInstructions(originClassNode);
                targetClassNode = AsmUtils.copy(originClassNode);
            }
            ClassNode instrumentClassNode = config.getInstrumentClassNode();
            if (config.isUpdateMajorVersion()) {
                AsmUtils.updateMajorVersion(instrumentClassNode, targetClassNode);
            }
            if (!originClassNode.name.equals(instrumentClassNode.name)) {
                instrumentClassNode = AsmUtils.renameClass(instrumentClassNode, originClassNode.name);
            }
            for (MethodNode methodNode : instrumentClassNode.methods) {
                MethodNode findMethod;
                if (AsmUtils.isAbstract(methodNode) || AsmUtils.isConstructor(methodNode) || (findMethod = AsmUtils.findMethod(originClassNode.methods, methodNode)) == null) continue;
                MethodNode updatedMethodNode = InstrumentImpl.replaceInvokeOrigin(originClassNode.name, findMethod, methodNode);
                updatedMethodNode.access = findMethod.access;
                AsmUtils.replaceMethod(targetClassNode, updatedMethodNode);
            }
        }
        if (targetClassNode != null) {
            if (loader != null) {
                List<DefineConfig> defineConfigs = this.instrumentParseResult.getDefineConfigs();
                for (DefineConfig defineConfig : defineConfigs) {
                    try {
                        ReflectUtils.defineClass(defineConfig.getClassName(), defineConfig.getClassBytes(), loader);
                    }
                    catch (Throwable e) {
                        String errorMessage;
                        Throwable cause = e.getCause();
                        if (cause instanceof LinkageError && (errorMessage = cause.getMessage()) != null && errorMessage.contains("duplicate class definition")) continue;
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("transform class: " + className + " error! can not define class: " + defineConfig.getClassName(), e);
                        }
                        return null;
                    }
                }
            }
            AsmUtils.fixMajorVersion(targetClassNode);
            byte[] resutlBytes = AsmUtils.toBytes(targetClassNode, loader, classReader);
            return resutlBytes;
        }
        return null;
    }
}

