/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.instrument;

import com.alibaba.bytekit.asm.inst.impl.InstrumentImpl;
import com.alibaba.bytekit.asm.instrument.InstrumentConfig;
import com.alibaba.bytekit.asm.instrument.InstrumentParseResult;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.ClassNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.List;

public class InstrumentTransformer
implements ClassFileTransformer {
    private InstrumentParseResult instrumentParseResult;

    public InstrumentTransformer(InstrumentParseResult instrumentParseResult) {
        this.instrumentParseResult = instrumentParseResult;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        List<InstrumentConfig> instrumentConfigs = this.instrumentParseResult.getInstrumentConfigs();
        ClassNode originClassNode = null;
        ClassNode targetClassNode = null;
        ClassReader classReader = null;
        for (InstrumentConfig config : instrumentConfigs) {
            if (!config.getClassMatcher().match(loader, className, classBeingRedefined, protectionDomain, classfileBuffer)) continue;
            if (originClassNode == null) {
                originClassNode = new ClassNode(589824);
                classReader = AsmUtils.toClassNode(classfileBuffer, originClassNode);
                targetClassNode = AsmUtils.copy(originClassNode);
            }
            ClassNode instrumentClassNode = config.getInstrumentClassNode();
            if (!originClassNode.name.equals(instrumentClassNode.name)) {
                byte[] renameClass = AsmUtils.renameClass(AsmUtils.toBytes(instrumentClassNode), Type.getObjectType((String)originClassNode.name).getClassName());
                instrumentClassNode = AsmUtils.toClassNode(renameClass);
            }
            for (MethodNode methodNode : instrumentClassNode.methods) {
                MethodNode findMethod;
                if (AsmUtils.isAbstract(methodNode) || AsmUtils.isConstructor(methodNode) || (findMethod = AsmUtils.findMethod(originClassNode.methods, methodNode)) == null) continue;
                MethodNode updatedMethodNode = InstrumentImpl.replaceInvokeOrigin(originClassNode.name, findMethod, methodNode);
                updatedMethodNode.access = findMethod.access;
                AsmUtils.replaceMethod(targetClassNode, updatedMethodNode);
            }
        }
        if (targetClassNode != null) {
            byte[] resutlBytes = AsmUtils.toBytes(targetClassNode, loader, classReader);
            return resutlBytes;
        }
        return null;
    }
}

