/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.utils;

import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.commons.Method;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.FieldInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.deps.org.objectweb.asm.tree.InsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.IntInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.LabelNode;
import com.alibaba.deps.org.objectweb.asm.tree.LdcInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import com.alibaba.deps.org.objectweb.asm.tree.TypeInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.VarInsnNode;
import java.util.ArrayList;
import java.util.List;

public class AsmOpUtils {
    private static final Type BYTE_TYPE = Type.getObjectType((String)"java/lang/Byte");
    private static final Type BOOLEAN_TYPE = Type.getObjectType((String)"java/lang/Boolean");
    private static final Type SHORT_TYPE = Type.getObjectType((String)"java/lang/Short");
    private static final Type CHARACTER_TYPE = Type.getObjectType((String)"java/lang/Character");
    private static final Type INTEGER_TYPE = Type.getObjectType((String)"java/lang/Integer");
    private static final Type FLOAT_TYPE = Type.getObjectType((String)"java/lang/Float");
    private static final Type LONG_TYPE = Type.getObjectType((String)"java/lang/Long");
    private static final Type DOUBLE_TYPE = Type.getObjectType((String)"java/lang/Double");
    public static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");
    public static final Type OBJECT_ARRAY_TYPE = Type.getType(Object[].class);
    public static final Type STRING_TYPE = Type.getObjectType((String)"java/lang/String");
    public static final Type STRING_ARRAY_TYPE = Type.getType(String[].class);
    private static final Type NUMBER_TYPE = Type.getObjectType((String)"java/lang/Number");
    private static final Method BOOLEAN_VALUE = Method.getMethod((String)"boolean booleanValue()");
    private static final Method CHAR_VALUE = Method.getMethod((String)"char charValue()");
    private static final Method BYTE_VALUE = Method.getMethod((String)"byte byteValue()");
    private static final Method SHORT_VALUE = Method.getMethod((String)"short shortValue()");
    private static final Method INT_VALUE = Method.getMethod((String)"int intValue()");
    private static final Method FLOAT_VALUE = Method.getMethod((String)"float floatValue()");
    private static final Method LONG_VALUE = Method.getMethod((String)"long longValue()");
    private static final Method DOUBLE_VALUE = Method.getMethod((String)"double doubleValue()");

    public static boolean isBoxType(Type type) {
        return BYTE_TYPE.equals((Object)type) || BOOLEAN_TYPE.equals((Object)type) || SHORT_TYPE.equals((Object)type) || CHARACTER_TYPE.equals((Object)type) || INTEGER_TYPE.equals((Object)type) || FLOAT_TYPE.equals((Object)type) || LONG_TYPE.equals((Object)type) || DOUBLE_TYPE.equals((Object)type);
    }

    public static Type getBoxedType(Type type) {
        switch (type.getSort()) {
            case 3: {
                return BYTE_TYPE;
            }
            case 1: {
                return BOOLEAN_TYPE;
            }
            case 4: {
                return SHORT_TYPE;
            }
            case 2: {
                return CHARACTER_TYPE;
            }
            case 5: {
                return INTEGER_TYPE;
            }
            case 6: {
                return FLOAT_TYPE;
            }
            case 7: {
                return LONG_TYPE;
            }
            case 8: {
                return DOUBLE_TYPE;
            }
        }
        return type;
    }

    public static Method getUnBoxMethod(Type type) {
        switch (type.getSort()) {
            case 3: {
                return BYTE_VALUE;
            }
            case 1: {
                return BOOLEAN_VALUE;
            }
            case 4: {
                return SHORT_VALUE;
            }
            case 2: {
                return CHAR_VALUE;
            }
            case 5: {
                return INT_VALUE;
            }
            case 6: {
                return FLOAT_VALUE;
            }
            case 7: {
                return LONG_VALUE;
            }
            case 8: {
                return DOUBLE_VALUE;
            }
        }
        throw new IllegalArgumentException(type + " is not a primitive type.");
    }

    public static void newInstance(InsnList instructions, Type type) {
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, type.getInternalName()));
    }

    public static void push(InsnList insnList, int value) {
        if (value >= -1 && value <= 5) {
            insnList.add((AbstractInsnNode)new InsnNode(3 + value));
        } else if (value >= -128 && value <= 127) {
            insnList.add((AbstractInsnNode)new IntInsnNode(16, value));
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            insnList.add((AbstractInsnNode)new IntInsnNode(17, value));
        } else {
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        }
    }

    public static void push(InsnList insnList, String value) {
        if (value == null) {
            insnList.add((AbstractInsnNode)new InsnNode(1));
        } else {
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        }
    }

    public static void pushNUll(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(1));
    }

    public static void ldc(InsnList insnList, Object value) {
        insnList.add((AbstractInsnNode)new LdcInsnNode(value));
    }

    public static void newArray(InsnList insnList, Type type) {
        insnList.add((AbstractInsnNode)new TypeInsnNode(189, type.getInternalName()));
    }

    public static void dup(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(89));
    }

    public static void dup2(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(92));
    }

    public static void dupX1(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(90));
    }

    public static void dupX2(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(91));
    }

    public static void dup2X1(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(93));
    }

    public static void dup2X2(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(94));
    }

    public static void pop(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(87));
    }

    public static void pop2(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(88));
    }

    public static void swap(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(95));
    }

    public static void swap(InsnList insnList, Type prev, Type type) {
        if (type.getSize() == 1) {
            if (prev.getSize() == 1) {
                AsmOpUtils.swap(insnList);
            } else {
                AsmOpUtils.dupX2(insnList);
                AsmOpUtils.pop(insnList);
            }
        } else if (prev.getSize() == 1) {
            AsmOpUtils.dup2X1(insnList);
            AsmOpUtils.pop2(insnList);
        } else {
            AsmOpUtils.dup2X2(insnList);
            AsmOpUtils.pop2(insnList);
        }
    }

    public static void box(InsnList instructions, Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (type == Type.VOID_TYPE) {
            instructions.add((AbstractInsnNode)new InsnNode(1));
        } else {
            Type boxed = AsmOpUtils.getBoxedType(type);
            AsmOpUtils.newInstance(instructions, boxed);
            if (type.getSize() == 2) {
                AsmOpUtils.dupX2(instructions);
                AsmOpUtils.dupX2(instructions);
                AsmOpUtils.pop(instructions);
            } else {
                AsmOpUtils.dupX1(instructions);
                AsmOpUtils.swap(instructions);
            }
            AsmOpUtils.invokeConstructor(instructions, boxed, new Method("<init>", Type.VOID_TYPE, new Type[]{type}));
        }
    }

    public static void invokeConstructor(InsnList instructions, Type type, Method method) {
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, owner, method.getName(), method.getDescriptor(), false));
    }

    public static void unbox(InsnList instructions, Type type) {
        Type t = NUMBER_TYPE;
        Method sig = null;
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                t = CHARACTER_TYPE;
                sig = CHAR_VALUE;
                break;
            }
            case 1: {
                t = BOOLEAN_TYPE;
                sig = BOOLEAN_VALUE;
                break;
            }
            case 8: {
                sig = DOUBLE_VALUE;
                break;
            }
            case 6: {
                sig = FLOAT_VALUE;
                break;
            }
            case 7: {
                sig = LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                sig = INT_VALUE;
            }
        }
        if (sig == null) {
            instructions.add((AbstractInsnNode)new TypeInsnNode(192, type.getInternalName()));
        } else {
            instructions.add((AbstractInsnNode)new TypeInsnNode(192, t.getInternalName()));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, t.getInternalName(), sig.getName(), sig.getDescriptor(), false));
        }
    }

    public static boolean needBox(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void getStatic(InsnList insnList, Type owner, String name, Type type) {
        insnList.add((AbstractInsnNode)new FieldInsnNode(178, owner.getInternalName(), name, type.getDescriptor()));
    }

    public static void getField(InsnList insnList, Type owner, String name, Type type) {
        insnList.add((AbstractInsnNode)new FieldInsnNode(180, owner.getInternalName(), name, type.getDescriptor()));
    }

    public static void arrayStore(InsnList instructions, Type type) {
        instructions.add((AbstractInsnNode)new InsnNode(type.getOpcode(79)));
    }

    public static void arrayLoad(InsnList instructions, Type type) {
        instructions.add((AbstractInsnNode)new InsnNode(type.getOpcode(46)));
    }

    public static void loadThis(InsnList instructions) {
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
    }

    public static void loadArgArray(InsnList instructions, MethodNode methodNode) {
        boolean isStatic = AsmUtils.isStatic(methodNode);
        Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
        AsmOpUtils.push(instructions, argumentTypes.length);
        AsmOpUtils.newArray(instructions, OBJECT_TYPE);
        for (int i = 0; i < argumentTypes.length; ++i) {
            AsmOpUtils.dup(instructions);
            AsmOpUtils.push(instructions, i);
            AsmOpUtils.loadArg(isStatic, instructions, argumentTypes, i);
            AsmOpUtils.box(instructions, argumentTypes[i]);
            AsmOpUtils.arrayStore(instructions, OBJECT_TYPE);
        }
    }

    public static void loadArgs(InsnList instructions, MethodNode methodNode) {
        Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
        boolean isStatic = AsmUtils.isStatic(methodNode);
        for (int i = 0; i < argumentTypes.length; ++i) {
            AsmOpUtils.loadArg(isStatic, instructions, argumentTypes, i);
        }
    }

    public static void loadArg(boolean staticAccess, InsnList instructions, Type[] argumentTypes, int i) {
        int index = AsmOpUtils.getArgIndex(staticAccess, argumentTypes, i);
        Type type = argumentTypes[i];
        instructions.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), index));
    }

    static int getArgIndex(boolean staticAccess, Type[] argumentTypes, int arg) {
        int index = staticAccess ? 0 : 1;
        for (int i = 0; i < arg; ++i) {
            index += argumentTypes[i].getSize();
        }
        return index;
    }

    public static void loadVar(InsnList instructions, Type type, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), index));
    }

    public static void storeVar(InsnList instructions, Type type, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(54), index));
    }

    private static void typeInsn(InsnList instructions, int opcode, Type type) {
        instructions.add((AbstractInsnNode)new TypeInsnNode(opcode, type.getInternalName()));
    }

    public static void checkCast(InsnList instructions, Type type) {
        if (!type.equals((Object)OBJECT_TYPE)) {
            AsmOpUtils.typeInsn(instructions, 192, type);
        }
    }

    public static void throwException(InsnList instructions) {
        instructions.add((AbstractInsnNode)new InsnNode(191));
    }

    public static boolean isReturnCode(int opcode) {
        return opcode >= 172 && opcode <= 177;
    }

    public static List<LocalVariableNode> validVariables(List<LocalVariableNode> localVariables, AbstractInsnNode currentInsnNode) {
        ArrayList<LocalVariableNode> results = new ArrayList<LocalVariableNode>();
        block0: for (LocalVariableNode localVariableNode : localVariables) {
            for (LabelNode iter = localVariableNode.start; iter != null && !iter.equals(localVariableNode.end); iter = iter.getNext()) {
                if (!iter.equals(currentInsnNode)) continue;
                results.add(localVariableNode);
                continue block0;
            }
        }
        return results;
    }
}

