/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.instrument;

import com.alibaba.bytekit.agent.inst.Instrument;
import com.alibaba.bytekit.asm.instrument.InstrumentConfig;
import com.alibaba.bytekit.asm.instrument.InstrumentParseResult;
import com.alibaba.bytekit.asm.matcher.ClassMatcher;
import com.alibaba.bytekit.asm.matcher.SimpleClassMatcher;
import com.alibaba.bytekit.asm.matcher.SimpleInterfaceMatcher;
import com.alibaba.bytekit.asm.matcher.SimpleSubclassMatcher;
import com.alibaba.bytekit.utils.AsmAnnotationUtils;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.bytekit.utils.IOUtils;
import com.alibaba.bytekit.utils.PropertiesUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.ClassNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class InstrumentTemplate {
    public static final String INSTRUMENT_PROPERTIES = "instrument.properties";
    public static final String INSTRUMENT = "instrument";
    private List<File> jarFiles = new ArrayList<File>();
    private List<byte[]> instrumentClassList = new ArrayList<byte[]>();

    public InstrumentTemplate(File ... jarFiles) {
        for (File file : jarFiles) {
            this.jarFiles.add(file);
        }
    }

    public void addJarFiles(Collection<File> jarFiles) {
        this.jarFiles.addAll(jarFiles);
    }

    public void addJarFile(File jarFile) {
        this.jarFiles.add(jarFile);
    }

    public void addInstrumentClass(byte[] classBytes) {
        this.instrumentClassList.add(classBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentParseResult build() throws IOException {
        InstrumentParseResult result = new InstrumentParseResult();
        for (File file : this.jarFiles) {
            JarFile jarFile;
            block7: {
                jarFile = null;
                try {
                    jarFile = new JarFile(file);
                    JarEntry propertiesEntry = jarFile.getJarEntry(INSTRUMENT_PROPERTIES);
                    if (propertiesEntry == null) break block7;
                    InputStream inputStream = jarFile.getInputStream(propertiesEntry);
                    Properties properties = PropertiesUtils.loadNotNull(inputStream);
                    String value = properties.getProperty(INSTRUMENT);
                    ArrayList<String> classes = new ArrayList<String>();
                    if (value != null) {
                        String[] strings;
                        for (String s : strings = value.split(",")) {
                            if ((s = s.trim()).isEmpty()) continue;
                            classes.add(s);
                        }
                    }
                    for (String clazz : classes) {
                        JarEntry classEntry = jarFile.getJarEntry(clazz.replace('.', '/') + ".class");
                        if (classEntry == null) continue;
                        byte[] classBytes = IOUtils.getBytes(jarFile.getInputStream(classEntry));
                        this.parse(result, classBytes);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(jarFile);
                    throw throwable;
                }
            }
            IOUtils.close(jarFile);
        }
        for (byte[] classBytes : this.instrumentClassList) {
            this.parse(result, classBytes);
        }
        return result;
    }

    private void parse(InstrumentParseResult result, byte[] classBytes) {
        List<String> matchInterfaceList;
        List<String> matchSuperclassList;
        ClassNode classNode = AsmUtils.toClassNode(classBytes);
        AsmUtils.removeLineNumbers(classNode);
        List<String> matchClassList = AsmAnnotationUtils.queryAnnotationInfo(classNode.visibleAnnotations, Type.getDescriptor(Instrument.class), "Class");
        if (matchClassList != null && !matchClassList.isEmpty()) {
            SimpleClassMatcher classMatcher = new SimpleClassMatcher(matchClassList);
            result.addInstrumentConfig(new InstrumentConfig(classNode, classMatcher));
        }
        if (!(matchSuperclassList = AsmAnnotationUtils.queryAnnotationInfo(classNode.visibleAnnotations, Type.getDescriptor(Instrument.class), "Superclass")).isEmpty()) {
            SimpleSubclassMatcher matcher = new SimpleSubclassMatcher(matchSuperclassList);
            result.addInstrumentConfig(new InstrumentConfig(classNode, matcher));
        }
        if (!(matchInterfaceList = AsmAnnotationUtils.queryAnnotationInfo(classNode.visibleAnnotations, Type.getDescriptor(Instrument.class), "Interface")).isEmpty()) {
            SimpleInterfaceMatcher matcher = new SimpleInterfaceMatcher(matchInterfaceList);
            result.addInstrumentConfig(new InstrumentConfig(classNode, matcher));
        }
    }

    public static List<Class<?>> matchedClass(Instrumentation instrumentation, InstrumentConfig instrumentConfig) {
        ArrayList result = new ArrayList();
        ClassMatcher classMatcher = instrumentConfig.getClassMatcher();
        for (Class clazz : instrumentation.getAllLoadedClasses()) {
            if (!classMatcher.match(null, clazz.getName(), clazz, null, null)) continue;
            result.add(clazz);
        }
        return result;
    }
}

