/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.utils;

import com.alibaba.bytekit.asm.ClassLoaderAwareClassWriter;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import com.alibaba.deps.org.objectweb.asm.ClassVisitor;
import com.alibaba.deps.org.objectweb.asm.ClassWriter;
import com.alibaba.deps.org.objectweb.asm.Label;
import com.alibaba.deps.org.objectweb.asm.MethodVisitor;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.commons.ClassRemapper;
import com.alibaba.deps.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.alibaba.deps.org.objectweb.asm.commons.Remapper;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.ClassNode;
import com.alibaba.deps.org.objectweb.asm.tree.FieldNode;
import com.alibaba.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import com.alibaba.deps.org.objectweb.asm.tree.TypeInsnNode;
import com.alibaba.deps.org.objectweb.asm.util.ASMifier;
import com.alibaba.deps.org.objectweb.asm.util.Printer;
import com.alibaba.deps.org.objectweb.asm.util.TraceClassVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AsmUtils {
    public static ClassNode loadClass(Class<?> clazz) throws IOException {
        String resource = clazz.getName().replace('.', '/') + ".class";
        InputStream is = clazz.getClassLoader().getResourceAsStream(resource);
        ClassReader cr = new ClassReader(is);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 4);
        return classNode;
    }

    public static ClassNode toClassNode(byte[] classBytes) {
        ClassReader reader = new ClassReader(classBytes);
        ClassNode result = new ClassNode(589824);
        reader.accept((ClassVisitor)result, 4);
        return result;
    }

    public static ClassReader toClassNode(byte[] classBytes, ClassNode classNode) {
        ClassReader reader = new ClassReader(classBytes);
        reader.accept((ClassVisitor)classNode, 4);
        return reader;
    }

    public static byte[] toBytes(ClassNode classNode, ClassLoader classLoader, ClassReader classReader) {
        int flags = 3;
        ClassLoaderAwareClassWriter writer = new ClassLoaderAwareClassWriter(classReader, flags, classLoader);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] toBytes(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] renameClass(byte[] classBytes, String newClassName) {
        String internalName = newClassName.replace('.', '/');
        ClassReader reader = new ClassReader(classBytes);
        ClassWriter writer = new ClassWriter(0);
        class RenameRemapper
        extends Remapper {
            private String className;
            final /* synthetic */ String val$internalName;

            RenameRemapper(String string) {
                this.val$internalName = string;
            }

            public String map(String typeName) {
                if (typeName.equals(this.className)) {
                    return this.val$internalName;
                }
                return super.map(typeName);
            }

            public void setClassName(String className) {
                this.className = className;
            }
        }
        final RenameRemapper renameRemapper = new RenameRemapper(internalName);
        ClassRemapper adapter = new ClassRemapper((ClassVisitor)writer, renameRemapper){
            {
                super(x0, x1);
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                renameRemapper.setClassName(name);
                super.visit(version, access, name, signature, superName, interfaces);
            }
        };
        reader.accept((ClassVisitor)adapter, 8);
        writer.visitEnd();
        return writer.toByteArray();
    }

    public static void replaceMethod(ClassNode classNode, MethodNode methodNode) {
        for (int index = 0; index < classNode.methods.size(); ++index) {
            MethodNode tmp = (MethodNode)classNode.methods.get(index);
            if (!tmp.name.equals(methodNode.name) || !tmp.desc.equals(methodNode.desc)) continue;
            classNode.methods.set(index, methodNode);
        }
    }

    public static String toASMCode(byte[] bytecode) throws IOException {
        return AsmUtils.toASMCode(bytecode, true);
    }

    public static String toASMCode(byte[] bytecode, boolean debug) throws IOException {
        int flags = 2;
        if (debug) {
            flags = 0;
        }
        ClassReader cr = new ClassReader((InputStream)new ByteArrayInputStream(bytecode));
        StringWriter sw = new StringWriter();
        cr.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new ASMifier(), new PrintWriter(sw)), flags);
        return sw.toString();
    }

    public static String toASMCode(ClassNode classNode) {
        StringWriter sw = new StringWriter();
        classNode.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new ASMifier(), new PrintWriter(sw)));
        return sw.toString();
    }

    public static String toASMCode(MethodNode methodNode) {
        ClassNode classNode = new ClassNode();
        classNode.methods.add(methodNode);
        return AsmUtils.toASMCode(classNode);
    }

    public static MethodNode newMethodNode(MethodNode source) {
        return new MethodNode(589824, source.access, source.name, source.desc, source.signature, source.exceptions.toArray(new String[source.exceptions.size()]));
    }

    public static MethodNode removeJSRInstructions(MethodNode subjectMethod) {
        MethodNode result = AsmUtils.newMethodNode(subjectMethod);
        subjectMethod.accept((MethodVisitor)new JSRInlinerAdapter((MethodVisitor)result, subjectMethod.access, subjectMethod.name, subjectMethod.desc, subjectMethod.signature, subjectMethod.exceptions.toArray(new String[subjectMethod.exceptions.size()])));
        return result;
    }

    public static ClassNode removeJSRInstructions(ClassNode classNode) {
        ClassNode result = new ClassNode(589824);
        classNode.accept(new ClassVisitor(589824, (ClassVisitor)result){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
            }
        });
        return result;
    }

    public static MethodNode removeLineNumbers(MethodNode methodNode) {
        MethodNode result = AsmUtils.newMethodNode(methodNode);
        methodNode.accept(new MethodVisitor(589824, (MethodVisitor)result){

            public void visitLineNumber(int line, Label start) {
            }
        });
        return result;
    }

    public static MethodNode findFirstMethod(Collection<MethodNode> methodNodes, String name) {
        for (MethodNode methodNode : methodNodes) {
            if (!methodNode.name.equals(name)) continue;
            return methodNode;
        }
        return null;
    }

    public static List<MethodNode> findMethods(Collection<MethodNode> methodNodes, String name) {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        for (MethodNode methodNode : methodNodes) {
            if (!methodNode.name.equals(name)) continue;
            result.add(methodNode);
        }
        return result;
    }

    public static MethodNode findMethod(Collection<MethodNode> methodNodes, MethodNode target) {
        return AsmUtils.findMethod(methodNodes, target.name, target.desc);
    }

    public static MethodNode findMethod(Collection<MethodNode> methodNodes, String name, String desc) {
        for (MethodNode methodNode : methodNodes) {
            if (!methodNode.name.equals(name) || !methodNode.desc.equals(desc)) continue;
            return methodNode;
        }
        return null;
    }

    public static AbstractInsnNode findInitConstructorInstruction(MethodNode methodNode) {
        int nested = 0;
        for (AbstractInsnNode insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            MethodInsnNode methodInsnNode;
            if (insnNode instanceof TypeInsnNode) {
                if (insnNode.getOpcode() != 187) continue;
                ++nested;
                continue;
            }
            if (!(insnNode instanceof MethodInsnNode) || (methodInsnNode = (MethodInsnNode)insnNode).getOpcode() != 183 || !methodInsnNode.name.equals("<init>") || --nested >= 0) continue;
            return insnNode.getNext();
        }
        return null;
    }

    public static List<MethodInsnNode> findMethodInsnNodeWithPrefix(MethodNode methodNode, String prefix) {
        ArrayList<MethodInsnNode> result = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (!(insnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            if (!methodInsnNode.name.startsWith(prefix)) continue;
            result.add(methodInsnNode);
        }
        return result;
    }

    public static List<MethodInsnNode> findMethodInsnNode(MethodNode methodNode, String owner, String name) {
        ArrayList<MethodInsnNode> result = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (!(insnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            if (!methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(name)) continue;
            result.add(methodInsnNode);
        }
        return result;
    }

    public static List<MethodInsnNode> findMethodInsnNode(MethodNode methodNode, String owner, String name, String desc) {
        ArrayList<MethodInsnNode> result = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (!(insnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            if (!methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(name) || !methodInsnNode.desc.equals(desc)) continue;
            result.add(methodInsnNode);
        }
        return result;
    }

    public static boolean containsMethodInsnNode(MethodNode methodNode, String owner, String name) {
        for (AbstractInsnNode insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (!(insnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            if (!methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStatic(MethodNode methodNode) {
        return (methodNode.access & 8) != 0;
    }

    public static boolean isStatic(MethodInsnNode methodInsnNode) {
        return methodInsnNode.getOpcode() == 184;
    }

    public static boolean isConstructor(MethodNode methodNode) {
        return methodNode.name != null && methodNode.name.equals("<init>");
    }

    public String[] getParameterNames(MethodNode methodNode) {
        Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
        if (argumentTypes.length == 0) {
            return new String[0];
        }
        List localVariableNodes = methodNode.localVariables;
        int localVariableStartIndex = 1;
        if (AsmUtils.isStatic(methodNode)) {
            localVariableStartIndex = 0;
        }
        if (localVariableNodes == null || localVariableNodes.size() <= localVariableStartIndex || argumentTypes.length + localVariableStartIndex > localVariableNodes.size()) {
            String[] names = new String[argumentTypes.length];
            for (int i = 0; i < argumentTypes.length; ++i) {
                String className = argumentTypes[i].getClassName();
                if (className != null) {
                    int findIndex = className.lastIndexOf(46);
                    if (findIndex == -1) {
                        names[i] = className;
                        continue;
                    }
                    names[i] = className.substring(findIndex + 1);
                    continue;
                }
                names[i] = argumentTypes[i].getDescriptor();
            }
            return names;
        }
        Collections.sort(localVariableNodes, new Comparator<LocalVariableNode>(){

            @Override
            public int compare(LocalVariableNode o1, LocalVariableNode o2) {
                return o1.index - o2.index;
            }
        });
        String[] names = new String[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            String name = ((LocalVariableNode)localVariableNodes.get((int)localVariableStartIndex++)).name;
            names[i] = name != null ? name : "";
        }
        return names;
    }

    public static MethodNode copy(MethodNode source) {
        MethodNode result = AsmUtils.newMethodNode(source);
        source.accept((MethodVisitor)result);
        return result;
    }

    public static ClassNode copy(ClassNode source) {
        ClassNode result = new ClassNode(589824);
        source.accept(new ClassVisitor(589824, (ClassVisitor)result){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
            }
        });
        return result;
    }

    public static String methodDeclaration(MethodInsnNode methodInsnNode) {
        StringBuilder sb = new StringBuilder(128);
        int opcode = methodInsnNode.getOpcode();
        if (opcode == 184) {
            sb.append("static ");
        }
        Type methodType = Type.getMethodType((String)methodInsnNode.desc);
        Type ownerType = Type.getObjectType((String)methodInsnNode.owner);
        if (methodInsnNode.name.equals("<init>")) {
            sb.append(ownerType.getClassName());
        } else {
            sb.append(methodType.getReturnType().getClassName()).append(' ');
            sb.append(methodInsnNode.name);
        }
        sb.append('(');
        Type[] argumentTypes = methodType.getArgumentTypes();
        for (int i = 0; i < argumentTypes.length; ++i) {
            sb.append(argumentTypes[i].getClassName());
            if (i == argumentTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static String methodDeclaration(Type owner, MethodNode methodNode) {
        int exceptionSize;
        int access = methodNode.access;
        StringBuilder sb = new StringBuilder(128);
        if ((access & 1) != 0) {
            sb.append("public ");
        }
        if ((access & 2) != 0) {
            sb.append("private ");
        }
        if ((access & 4) != 0) {
            sb.append("protected ");
        }
        if ((access & 8) != 0) {
            sb.append("static ");
        }
        if ((access & 0x10) != 0) {
            sb.append("final ");
        }
        if ((access & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((access & 0x100) != 0) {
            sb.append("native ");
        }
        if ((access & 0x400) != 0) {
            sb.append("abstract ");
        }
        Type methodType = Type.getMethodType((String)methodNode.desc);
        if (methodNode.name.equals("<init>")) {
            sb.append(owner.getClassName());
        } else {
            sb.append(methodType.getReturnType().getClassName()).append(' ');
            sb.append(methodNode.name);
        }
        sb.append('(');
        Type[] argumentTypes = methodType.getArgumentTypes();
        for (int i = 0; i < argumentTypes.length; ++i) {
            sb.append(argumentTypes[i].getClassName());
            if (i == argumentTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        if (methodNode.exceptions != null && (exceptionSize = methodNode.exceptions.size()) > 0) {
            sb.append(" throws");
            for (int i = 0; i < exceptionSize; ++i) {
                sb.append(' ');
                sb.append(Type.getObjectType((String)((String)methodNode.exceptions.get(i))).getClassName());
                if (i == exceptionSize - 1) continue;
                sb.append(',');
            }
        }
        return sb.toString();
    }

    public static FieldNode findField(List<FieldNode> fields, String name) {
        for (FieldNode field : fields) {
            if (!field.name.equals(name)) continue;
            return field;
        }
        return null;
    }

    public static void addField(ClassNode classNode, FieldNode fieldNode) {
        classNode.fields.add(fieldNode);
    }

    public static void addMethod(ClassNode classNode, MethodNode methodNode) {
        classNode.methods.add(methodNode);
    }

    public static String uniqueNameForMethod(String className, String methodName, String desc) {
        StringBuilder result = new StringBuilder(128);
        result.append(AsmUtils.cleanClassName(className)).append('_').append(methodName);
        for (Type arg : Type.getMethodType((String)desc).getArgumentTypes()) {
            result.append('_').append(AsmUtils.cleanClassName(arg.getClassName()));
        }
        return result.toString();
    }

    private static String cleanClassName(String className) {
        char[] charArray = className.toCharArray();
        int length = charArray.length;
        for (int i = 0; i < length; ++i) {
            switch (charArray[i]) {
                case '.': 
                case '/': 
                case ';': 
                case '<': 
                case '>': 
                case '[': 
                case ']': {
                    charArray[i] = 95;
                }
            }
        }
        return new String(charArray);
    }

    public static int getMajorVersion(int version) {
        return 0xFFFF & version;
    }

    public static int setMajorVersion(int version, int majorVersion) {
        return version & 0xFFFF0000 | majorVersion;
    }
}

