/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.bytekit.utils;

import com.alibaba.arthas.deps.org.objectweb.asm.ClassVisitor;
import com.alibaba.arthas.deps.org.objectweb.asm.MethodVisitor;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.ClassNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.MethodNode;
import com.alibaba.arthas.deps.org.objectweb.asm.util.Printer;
import com.alibaba.arthas.deps.org.objectweb.asm.util.Textifier;
import com.alibaba.arthas.deps.org.objectweb.asm.util.TraceClassVisitor;
import com.alibaba.arthas.deps.org.objectweb.asm.util.TraceMethodVisitor;
import com.taobao.arthas.common.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.benf.cfr.reader.api.CfrDriver;
import org.benf.cfr.reader.api.OutputSinkFactory;

public class Decompiler {
    public static String decompile(byte[] bytecode) throws IOException {
        String result = "";
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        File file = new File(tempDirectory, UUID.randomUUID().toString());
        FileUtils.writeByteArrayToFile((File)file, (byte[])bytecode);
        result = Decompiler.decompile(file.getAbsolutePath(), null);
        return result;
    }

    public static String decompile(String path) throws IOException {
        byte[] byteArray = FileUtils.readFileToByteArray((File)new File(path));
        return Decompiler.decompile(byteArray);
    }

    public static String toString(MethodNode methodNode) {
        Textifier printer = new Textifier();
        TraceMethodVisitor methodPrinter = new TraceMethodVisitor((Printer)printer);
        methodNode.accept((MethodVisitor)methodPrinter);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }

    public static String toString(ClassNode classNode) {
        Textifier printer = new Textifier();
        StringWriter sw = new StringWriter();
        PrintWriter printWriter = new PrintWriter(sw);
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(printWriter);
        classNode.accept((ClassVisitor)traceClassVisitor);
        printer.print(printWriter);
        printer.getText().clear();
        return sw.toString();
    }

    public static String toString(InsnList insnList) {
        Textifier printer = new Textifier();
        TraceMethodVisitor mp = new TraceMethodVisitor((Printer)printer);
        insnList.accept((MethodVisitor)mp);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }

    public static String toString(AbstractInsnNode insn) {
        Textifier printer = new Textifier();
        TraceMethodVisitor mp = new TraceMethodVisitor((Printer)printer);
        insn.accept((MethodVisitor)mp);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }

    public static String decompile(String classFilePath, String methodName) {
        final StringBuilder result = new StringBuilder(8192);
        OutputSinkFactory mySink = new OutputSinkFactory(){

            @Override
            public List<OutputSinkFactory.SinkClass> getSupportedSinks(OutputSinkFactory.SinkType sinkType, Collection<OutputSinkFactory.SinkClass> collection) {
                return Arrays.asList(OutputSinkFactory.SinkClass.STRING, OutputSinkFactory.SinkClass.DECOMPILED, OutputSinkFactory.SinkClass.DECOMPILED_MULTIVER, OutputSinkFactory.SinkClass.EXCEPTION_MESSAGE);
            }

            @Override
            public <T> OutputSinkFactory.Sink<T> getSink(final OutputSinkFactory.SinkType sinkType, OutputSinkFactory.SinkClass sinkClass) {
                return new OutputSinkFactory.Sink<T>(){

                    @Override
                    public void write(T sinkable) {
                        if (sinkType == OutputSinkFactory.SinkType.PROGRESS) {
                            return;
                        }
                        result.append(sinkable);
                    }
                };
            }
        };
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("showversion", "false");
        if (methodName != null) {
            options.put("methodname", methodName);
        }
        CfrDriver driver = new CfrDriver.Builder().withOptions(options).withOutputSink(mySink).build();
        ArrayList<String> toAnalyse = new ArrayList<String>();
        toAnalyse.add(classFilePath);
        driver.analyse(toAnalyse);
        return result.toString();
    }
}

