/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.bytekit.asm.location.filter;

import com.alibaba.arthas.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.taobao.arthas.bytekit.asm.location.LocationType;
import com.taobao.arthas.bytekit.asm.location.filter.LocationFilter;

public class InvokeCheckLocationFilter
implements LocationFilter {
    private String owner;
    private String methodName;
    private LocationType locationType;

    public InvokeCheckLocationFilter(String owner, String methodName, LocationType locationType) {
        this.owner = owner;
        this.methodName = methodName;
        this.locationType = locationType;
    }

    @Override
    public boolean allow(AbstractInsnNode insnNode, LocationType locationType, boolean complete) {
        if (!this.locationType.equals((Object)locationType)) {
            return false;
        }
        MethodInsnNode methodInsnNode = this.findMethodInsnNode(insnNode, complete);
        return methodInsnNode == null || !methodInsnNode.owner.equals(this.owner) || !methodInsnNode.name.equals(this.methodName);
    }

    private MethodInsnNode findMethodInsnNode(AbstractInsnNode insnNode, boolean complete) {
        if (complete) {
            while (insnNode != null) {
                if (!((insnNode = insnNode.getNext()) instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                return methodInsnNode;
            }
        } else {
            while (insnNode != null) {
                if (!((insnNode = insnNode.getPrevious()) instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                return methodInsnNode;
            }
        }
        return null;
    }
}

