/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.bytekit.asm.interceptor.annotation;

import com.alibaba.arthas.deps.org.objectweb.asm.Type;
import com.taobao.arthas.bytekit.asm.interceptor.InterceptorProcessor;
import com.taobao.arthas.bytekit.asm.interceptor.annotation.InterceptorParserHander;
import com.taobao.arthas.bytekit.asm.interceptor.annotation.InterceptorParserUtils;
import com.taobao.arthas.bytekit.asm.interceptor.annotation.None;
import com.taobao.arthas.bytekit.asm.interceptor.parser.InterceptorProcessorParser;
import com.taobao.arthas.bytekit.asm.location.FieldAccessLocationMatcher;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@InterceptorParserHander(parserHander=FieldAccessInterceptorProcessorParser.class)
public @interface AtFieldAccess {
    public boolean inline() default true;

    public Class<? extends Throwable> suppress() default None.class;

    public Class<?> suppressHandler() default Void.class;

    public Class<?> owner() default Void.class;

    public Class<?> type() default Void.class;

    public String name();

    public int count() default -1;

    public int flags() default 3;

    public boolean whenComplete() default false;

    public static class FieldAccessInterceptorProcessorParser
    implements InterceptorProcessorParser {
        @Override
        public InterceptorProcessor parse(Method method, Annotation annotationOnMethod) {
            AtFieldAccess atFieldAccess = (AtFieldAccess)annotationOnMethod;
            String ownerClass = null;
            String fieldDesc = null;
            if (!atFieldAccess.owner().equals(Void.class)) {
                ownerClass = Type.getType(atFieldAccess.owner()).getInternalName();
            }
            if (!atFieldAccess.type().equals(Void.class)) {
                fieldDesc = Type.getType(atFieldAccess.type()).getDescriptor();
            }
            FieldAccessLocationMatcher locationMatcher = new FieldAccessLocationMatcher(ownerClass, fieldDesc, atFieldAccess.name(), atFieldAccess.count(), atFieldAccess.flags(), atFieldAccess.whenComplete());
            return InterceptorParserUtils.createInterceptorProcessor(method, locationMatcher, atFieldAccess.inline(), atFieldAccess.suppress(), atFieldAccess.suppressHandler());
        }
    }
}

