/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.bytekit.asm.binding;

import com.alibaba.arthas.deps.org.objectweb.asm.Type;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.taobao.arthas.bytekit.asm.MethodProcessor;
import com.taobao.arthas.bytekit.asm.binding.Binding;
import com.taobao.arthas.bytekit.asm.binding.BindingContext;
import com.taobao.arthas.bytekit.utils.AsmOpUtils;
import com.taobao.arthas.bytekit.utils.AsmUtils;

public class InvokeReturnBinding
extends Binding {
    @Override
    public void pushOntoStack(InsnList instructions, BindingContext bindingContext) {
        AbstractInsnNode insnNode = bindingContext.getLocation().getInsnNode();
        MethodProcessor methodProcessor = bindingContext.getMethodProcessor();
        if (insnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            String uniqueNameForMethod = AsmUtils.uniqueNameForMethod(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc);
            Type invokeReturnType = Type.getMethodType((String)methodInsnNode.desc).getReturnType();
            if (invokeReturnType.equals((Object)Type.VOID_TYPE)) {
                AsmOpUtils.push(instructions, null);
            } else {
                LocalVariableNode invokeReturnVariableNode = methodProcessor.initInvokeReturnVariableNode(uniqueNameForMethod, Type.getMethodType((String)methodInsnNode.desc).getReturnType());
                AsmOpUtils.loadVar(instructions, invokeReturnType, invokeReturnVariableNode.index);
            }
        } else {
            throw new IllegalArgumentException("InvokeReturnBinding location is not MethodInsnNode, insnNode: " + insnNode);
        }
    }

    @Override
    public boolean fromStack() {
        return true;
    }

    @Override
    public Type getType(BindingContext bindingContext) {
        AbstractInsnNode insnNode = bindingContext.getLocation().getInsnNode();
        if (insnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            Type invokeReturnType = Type.getMethodType((String)methodInsnNode.desc).getReturnType();
            return invokeReturnType;
        }
        throw new IllegalArgumentException("InvokeReturnBinding location is not MethodInsnNode, insnNode: " + insnNode);
    }
}

