/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.bytekit.asm.binding;

import com.alibaba.arthas.deps.org.objectweb.asm.Type;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.InsnList;
import com.taobao.arthas.bytekit.asm.binding.ArgNamesBinding;
import com.taobao.arthas.bytekit.asm.binding.ArgsBinding;
import com.taobao.arthas.bytekit.asm.binding.BindingContext;
import com.taobao.arthas.bytekit.asm.binding.ClassBinding;
import com.taobao.arthas.bytekit.asm.binding.FieldBinding;
import com.taobao.arthas.bytekit.asm.binding.InvokeArgsBinding;
import com.taobao.arthas.bytekit.asm.binding.InvokeInfoBinding;
import com.taobao.arthas.bytekit.asm.binding.InvokeMethodDeclarationBinding;
import com.taobao.arthas.bytekit.asm.binding.InvokeMethodNameBinding;
import com.taobao.arthas.bytekit.asm.binding.InvokeMethodOwnerBinding;
import com.taobao.arthas.bytekit.asm.binding.InvokeReturnBinding;
import com.taobao.arthas.bytekit.asm.binding.LineBinding;
import com.taobao.arthas.bytekit.asm.binding.LocalVarNamesBinding;
import com.taobao.arthas.bytekit.asm.binding.LocalVarsBinding;
import com.taobao.arthas.bytekit.asm.binding.MethodBinding;
import com.taobao.arthas.bytekit.asm.binding.MethodDeclarationBinding;
import com.taobao.arthas.bytekit.asm.binding.MethodInfoBinding;
import com.taobao.arthas.bytekit.asm.binding.MethodNameBinding;
import com.taobao.arthas.bytekit.asm.binding.MonitorBinding;
import com.taobao.arthas.bytekit.asm.binding.ReturnBinding;
import com.taobao.arthas.bytekit.asm.binding.ThisBinding;
import com.taobao.arthas.bytekit.asm.binding.ThrowableBinding;
import com.taobao.arthas.bytekit.asm.binding.annotation.BindingParser;
import com.taobao.arthas.bytekit.asm.binding.annotation.BindingParserHandler;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public abstract class Binding {
    public boolean optional() {
        return false;
    }

    public boolean check(BindingContext bindingContext) {
        return true;
    }

    public abstract void pushOntoStack(InsnList var1, BindingContext var2);

    public abstract Type getType(BindingContext var1);

    public boolean fromStack() {
        return false;
    }

    public static class MonitorBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MonitorBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MonitorBindingParser.class)
    public static @interface Monitor {
        public boolean optional() default false;
    }

    public static class LineBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            Line line = (Line)annotation;
            return new LineBinding(line.exact());
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=LineBindingParser.class)
    public static @interface Line {
        public boolean optional() default false;

        public boolean exact() default false;
    }

    public static class ThrowableBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ThrowableBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ThrowableBindingParser.class)
    public static @interface Throwable {
        public boolean optional() default false;
    }

    public static class ThisBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ThisBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ThisBindingParser.class)
    public static @interface This {
    }

    public static class ReturnBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ReturnBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ReturnBindingParser.class)
    public static @interface Return {
        public boolean optional() default false;
    }

    public static class MethodInfoBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MethodInfoBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MethodInfoBindingParser.class)
    public static @interface MethodInfo {
        public boolean optional() default false;
    }

    public static class MethodDescBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MethodDeclarationBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MethodDescBindingParser.class)
    public static @interface MethodDesc {
        public boolean optional() default false;
    }

    public static class MethodNameBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MethodNameBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MethodNameBindingParser.class)
    public static @interface MethodName {
        public boolean optional() default false;
    }

    public static class MethodBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MethodBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MethodBindingParser.class)
    public static @interface Method {
        public boolean optional() default false;
    }

    public static class InvokeInfoBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeInfoBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeInfoBindingParser.class)
    public static @interface InvokeInfo {
        public boolean optional() default false;
    }

    public static class InvokeMethodDeclarationBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeMethodDeclarationBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeMethodDeclarationBindingParser.class)
    public static @interface InvokeMethodDeclaration {
        public boolean optional() default false;
    }

    public static class InvokeMethodOwnerBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeMethodOwnerBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeMethodOwnerBindingParser.class)
    public static @interface InvokeMethodOwner {
        public boolean optional() default false;
    }

    public static class InvokeMethodNameBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeMethodNameBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeMethodNameBindingParser.class)
    public static @interface InvokeMethodName {
        public boolean optional() default false;
    }

    public static class InvokeReturnBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeReturnBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeReturnBindingParser.class)
    public static @interface InvokeReturn {
        public boolean optional() default false;
    }

    public static class InvokeArgsBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeArgsBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeArgsBindingParser.class)
    public static @interface InvokeArgs {
        public boolean optional() default false;
    }

    public static class FieldBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            Field field = (Field)annotation;
            Type ownerType = Type.getType(field.owner());
            if (field.owner().equals(Void.class)) {
                ownerType = null;
            }
            Type fieldType = Type.getType(field.type());
            if (field.type().equals(Void.class)) {
                fieldType = null;
            }
            return new FieldBinding(ownerType, field.name(), fieldType, field.isStatic(), field.box());
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=FieldBindingParser.class)
    public static @interface Field {
        public boolean optional() default false;

        public java.lang.Class<?> owner() default Void.class;

        public java.lang.Class<?> type() default Void.class;

        public String name();

        public boolean isStatic() default false;

        public boolean box() default false;
    }

    public static class ClassBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ClassBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ClassBindingParser.class)
    public static @interface Class {
        public boolean optional() default false;
    }

    public static class LocalVarNamesBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new LocalVarNamesBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=LocalVarNamesBindingParser.class)
    public static @interface LocalVarNames {
        public boolean optional() default false;
    }

    public static class LocalVarsBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new LocalVarsBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=LocalVarsBindingParser.class)
    public static @interface LocalVars {
        public boolean optional() default false;
    }

    public static class ArgNamesBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ArgNamesBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ArgNamesBindingParser.class)
    public static @interface ArgNames {
        public boolean optional() default false;
    }

    public static class ArgsBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ArgsBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ArgsBindingParser.class)
    public static @interface Args {
        public boolean optional() default false;
    }
}

