/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util;

import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.NacosPropertiesBuilder;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import com.alibaba.nacos.spring.core.env.NacosPropertySourcePostProcessor;
import com.alibaba.nacos.spring.util.NacosUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class NacosConfigUtils {
    private final NacosConfigProperties nacosConfigProperties;
    private final ConfigurableEnvironment environment;
    private Function<Properties, ConfigService> builder;
    private List<DeferNacosPropertySource> nacosPropertySources = new LinkedList<DeferNacosPropertySource>();

    public NacosConfigUtils(NacosConfigProperties nacosConfigProperties, ConfigurableEnvironment environment, Function<Properties, ConfigService> builder) {
        this.nacosConfigProperties = nacosConfigProperties;
        this.environment = environment;
        this.builder = builder;
    }

    public void loadConfig(boolean isLogPre) {
        Properties globalProperties = this.buildGlobalNacosProperties();
        MutablePropertySources mutablePropertySources = this.environment.getPropertySources();
        if (isLogPre) {
            NacosPropertySource first = this.reqGlobalNacosConfig(globalProperties, this.nacosConfigProperties.getType());
            mutablePropertySources.addFirst((PropertySource)first);
            String preName = first.getName();
            for (NacosConfigProperties.Config config : this.nacosConfigProperties.getExtConfig()) {
                NacosPropertySource element = this.reqSubNacosConfig(config, globalProperties, config.getType());
                mutablePropertySources.addAfter(preName, (PropertySource)element);
                preName = element.getName();
            }
        } else {
            mutablePropertySources.addLast((PropertySource)this.reqGlobalNacosConfig(globalProperties, this.nacosConfigProperties.getType()));
            for (NacosConfigProperties.Config config : this.nacosConfigProperties.getExtConfig()) {
                mutablePropertySources.addLast((PropertySource)this.reqSubNacosConfig(config, globalProperties, config.getType()));
            }
        }
    }

    public Properties buildGlobalNacosProperties() {
        return NacosPropertiesBuilder.buildNacosProperties(this.nacosConfigProperties.getServerAddr(), this.nacosConfigProperties.getNamespace(), this.nacosConfigProperties.getEndpoint(), this.nacosConfigProperties.getSecretKey(), this.nacosConfigProperties.getAccessKey(), this.nacosConfigProperties.getRamRoleName(), this.nacosConfigProperties.getConfigLongPollTimeout(), this.nacosConfigProperties.getConfigRetryTime(), this.nacosConfigProperties.getMaxRetry(), this.nacosConfigProperties.isEnableRemoteSyncConfig());
    }

    public Properties buildSubNacosProperties(Properties globalProperties, NacosConfigProperties.Config config) {
        if (StringUtils.isEmpty((Object)config.getServerAddr())) {
            return globalProperties;
        }
        Properties sub = NacosPropertiesBuilder.buildNacosProperties(config.getServerAddr(), config.getNamespace(), config.getEndpoint(), config.getSecretKey(), config.getAccessKey(), config.getRamRoleName(), config.getConfigLongPollTimeout(), config.getConfigRetryTime(), config.getMaxRetry(), config.isEnableRemoteSyncConfig());
        NacosPropertiesBuilder.merge(sub, globalProperties);
        return sub;
    }

    public NacosPropertySource reqGlobalNacosConfig(Properties globalProperties, ConfigType type) {
        NacosPropertySource propertySource = this.reqNacosConfig(globalProperties, this.nacosConfigProperties.getDataId(), this.nacosConfigProperties.getGroup(), type);
        propertySource.setAutoRefreshed(this.nacosConfigProperties.isAutoRefresh());
        this.nacosPropertySources.add(new DeferNacosPropertySource(propertySource, globalProperties, this.environment));
        return propertySource;
    }

    public NacosPropertySource reqSubNacosConfig(NacosConfigProperties.Config config, Properties globalProperties, ConfigType type) {
        Properties subConfigProperties = this.buildSubNacosProperties(globalProperties, config);
        NacosPropertySource nacosPropertySource = this.reqNacosConfig(subConfigProperties, config.getDataId(), config.getGroup(), type);
        nacosPropertySource.setAutoRefreshed(config.isAutoRefresh());
        this.nacosPropertySources.add(new DeferNacosPropertySource(nacosPropertySource, subConfigProperties, this.environment));
        return nacosPropertySource;
    }

    public NacosPropertySource reqNacosConfig(Properties configProperties, String dataId, String groupId, ConfigType type) {
        String config = NacosUtils.getContent((ConfigService)this.builder.apply(configProperties), (String)dataId, (String)groupId);
        NacosPropertySource nacosPropertySource = new NacosPropertySource(dataId, groupId, NacosUtils.buildDefaultPropertySourceName((String)dataId, (String)groupId, (Map)configProperties), config, type.getType());
        nacosPropertySource.setDataId(dataId);
        nacosPropertySource.setType(type.getType());
        nacosPropertySource.setGroupId(groupId);
        return nacosPropertySource;
    }

    public void addListenerIfAutoRefreshed() {
        this.addListenerIfAutoRefreshed(this.nacosPropertySources);
    }

    public void addListenerIfAutoRefreshed(List<DeferNacosPropertySource> deferNacosPropertySources) {
        for (DeferNacosPropertySource deferNacosPropertySource : deferNacosPropertySources) {
            NacosPropertySourcePostProcessor.addListenerIfAutoRefreshed((NacosPropertySource)deferNacosPropertySource.getNacosPropertySource(), (Properties)deferNacosPropertySource.getProperties(), (ConfigurableEnvironment)deferNacosPropertySource.getEnvironment());
        }
    }

    public List<DeferNacosPropertySource> getNacosPropertySources() {
        return this.nacosPropertySources;
    }

    public static class DeferNacosPropertySource {
        private final NacosPropertySource nacosPropertySource;
        private final ConfigurableEnvironment environment;
        private final Properties properties;

        public DeferNacosPropertySource(NacosPropertySource nacosPropertySource, Properties properties, ConfigurableEnvironment environment) {
            this.nacosPropertySource = nacosPropertySource;
            this.properties = properties;
            this.environment = environment;
        }

        public NacosPropertySource getNacosPropertySource() {
            return this.nacosPropertySource;
        }

        public ConfigurableEnvironment getEnvironment() {
            return this.environment;
        }

        public Properties getProperties() {
            return this.properties;
        }
    }
}

