/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.autoconfigure;

import com.alibaba.boot.nacos.config.autoconfigure.NacosConfigEnvironmentProcessor;
import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.NacosConfigPropertiesUtils;
import com.alibaba.boot.nacos.config.util.NacosConfigUtils;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.factory.CacheableEventPublishingNacosServiceFactory;
import com.alibaba.nacos.spring.util.config.NacosConfigLoader;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class NacosConfigApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Logger logger = LoggerFactory.getLogger(NacosConfigApplicationContextInitializer.class);
    private ConfigurableEnvironment environment;
    private NacosConfigProperties nacosConfigProperties;
    private NacosConfigLoader nacosConfigLoader;
    private final NacosConfigEnvironmentProcessor processor;

    public NacosConfigApplicationContextInitializer(NacosConfigEnvironmentProcessor configEnvironmentProcessor) {
        this.processor = configEnvironmentProcessor;
    }

    public void initialize(ConfigurableApplicationContext context) {
        CacheableEventPublishingNacosServiceFactory singleton = CacheableEventPublishingNacosServiceFactory.getSingleton();
        singleton.setApplicationContext((ApplicationContext)context);
        this.environment = context.getEnvironment();
        if (!this.enable()) {
            this.logger.info("[Nacos Config Boot] : The preload configuration is not enabled");
        } else {
            Function<Properties, ConfigService> builder = properties -> {
                try {
                    return singleton.createConfigService(properties);
                }
                catch (NacosException e) {
                    throw new RuntimeException("ConfigService can't be created with properties : " + properties, e);
                }
            };
            this.nacosConfigProperties = NacosConfigPropertiesUtils.buildNacosConfigProperties(this.environment);
            NacosConfigUtils configUtils = new NacosConfigUtils(this.nacosConfigProperties, this.environment, builder);
            if (this.processor.enable((Environment)this.environment)) {
                configUtils.addListenerIfAutoRefreshed(this.processor.getDeferPropertySources());
            } else {
                configUtils.loadConfig(false);
                configUtils.addListenerIfAutoRefreshed();
            }
        }
    }

    private boolean enable() {
        return this.processor.enable((Environment)this.environment) || Boolean.parseBoolean(this.environment.getProperty("nacos.config.bootstrap.enable", "false"));
    }
}

