/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.context.event;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.util.ObjectUtils;

public class AwaitingNonWebApplicationListener
implements SmartApplicationListener {
    private static final Logger logger = LoggerFactory.getLogger(AwaitingNonWebApplicationListener.class);
    private static final Class<? extends ApplicationEvent>[] SUPPORTED_APPLICATION_EVENTS = AwaitingNonWebApplicationListener.of(ApplicationReadyEvent.class, ContextClosedEvent.class);
    private static final AtomicBoolean awaited = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ObjectUtils.containsElement((Object[])SUPPORTED_APPLICATION_EVENTS, eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    private static <T> T[] of(T ... values) {
        return values;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            this.onApplicationReadyEvent((ApplicationReadyEvent)event);
        } else if (event instanceof ContextClosedEvent) {
            this.onContextClosedEvent((ContextClosedEvent)event);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected void onApplicationReadyEvent(ApplicationReadyEvent event) {
        SpringApplication springApplication = event.getSpringApplication();
        if (!WebApplicationType.NONE.equals((Object)springApplication.getWebApplicationType())) {
            return;
        }
        this.await();
    }

    protected void onContextClosedEvent(ContextClosedEvent event) {
        this.release();
        this.shutdown();
    }

    protected void await() {
        if (awaited.get()) {
            return;
        }
        this.executorService.execute(() -> this.executeMutually(() -> {
            while (!awaited.get()) {
                if (logger.isInfoEnabled()) {
                    logger.info(" [Dubbo] Current Spring Boot Application is await...");
                }
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }));
    }

    protected void release() {
        this.executeMutually(() -> {
            while (awaited.compareAndSet(false, true)) {
                if (logger.isInfoEnabled()) {
                    logger.info(" [Dubbo] Current Spring Boot Application is about to shutdown...");
                }
                this.condition.signalAll();
            }
        });
    }

    private void shutdown() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    private void executeMutually(Runnable runnable) {
        try {
            this.lock.lock();
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    static AtomicBoolean getAwaited() {
        return awaited;
    }
}

