/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.streaming.api.functions.source;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.functions.Function;

import java.io.Serializable;

/**
 * New interface for stream data sources in Flink.
 *
 * @param <T> the type parameter
 */
@Public
public interface SourceFunctionV2<T> extends Function, Serializable {

	/**
	 * Is finished boolean.
	 *
	 * @return the boolean
	 */
	boolean isFinished();

	/**
	 * Next source record.
	 * This should be non-blocking operation.
	 *
	 * @return the source record, or null that means there is no data temporarily
	 * @throws Exception the exception
	 */
	SourceRecord<T> next() throws Exception;

	/**
	 * Cancel the source function.
	 */
	void cancel();
}
