/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.ch.qos.logback.classic.spi;

import com.alibaba.arthas.deps.ch.qos.logback.classic.LoggerContext;
import com.alibaba.arthas.deps.ch.qos.logback.classic.util.ContextInitializer;
import com.alibaba.arthas.deps.ch.qos.logback.classic.util.LogbackMDCAdapter;
import com.alibaba.arthas.deps.ch.qos.logback.core.joran.spi.JoranException;
import com.alibaba.arthas.deps.ch.qos.logback.core.status.StatusUtil;
import com.alibaba.arthas.deps.ch.qos.logback.core.util.StatusPrinter;
import com.alibaba.arthas.deps.org.slf4j.ILoggerFactory;
import com.alibaba.arthas.deps.org.slf4j.IMarkerFactory;
import com.alibaba.arthas.deps.org.slf4j.helpers.BasicMarkerFactory;
import com.alibaba.arthas.deps.org.slf4j.helpers.Util;
import com.alibaba.arthas.deps.org.slf4j.spi.MDCAdapter;
import com.alibaba.arthas.deps.org.slf4j.spi.SLF4JServiceProvider;

public class LogbackServiceProvider
implements SLF4JServiceProvider {
    static final String NULL_CS_URL = "http://logback.qos.ch/codes.html#null_CS";
    public static String REQUESTED_API_VERSION = "2.0.99";
    private LoggerContext defaultLoggerContext;
    private IMarkerFactory markerFactory;
    private LogbackMDCAdapter mdcAdapter;

    public void initialize() {
        this.defaultLoggerContext = new LoggerContext();
        this.defaultLoggerContext.setName("default");
        this.initializeLoggerContext();
        this.defaultLoggerContext.start();
        this.markerFactory = new BasicMarkerFactory();
        this.mdcAdapter = new LogbackMDCAdapter();
        this.defaultLoggerContext.setMDCAdapter(this.mdcAdapter);
    }

    private void initializeLoggerContext() {
        try {
            try {
                new ContextInitializer(this.defaultLoggerContext).autoConfig();
            }
            catch (JoranException je) {
                Util.report("Failed to auto configure default logger context", je);
            }
            if (!StatusUtil.contextHasStatusListener(this.defaultLoggerContext)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings(this.defaultLoggerContext);
            }
        }
        catch (Exception t) {
            Util.report("Failed to instantiate [" + LoggerContext.class.getName() + "]", t);
        }
    }

    public ILoggerFactory getLoggerFactory() {
        return this.defaultLoggerContext;
    }

    public IMarkerFactory getMarkerFactory() {
        return this.markerFactory;
    }

    public MDCAdapter getMDCAdapter() {
        return this.mdcAdapter;
    }

    public String getRequestedApiVersion() {
        return REQUESTED_API_VERSION;
    }
}

