/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.ch.qos.logback.classic.model.processor;

import com.alibaba.arthas.deps.ch.qos.logback.classic.Level;
import com.alibaba.arthas.deps.ch.qos.logback.classic.Logger;
import com.alibaba.arthas.deps.ch.qos.logback.classic.LoggerContext;
import com.alibaba.arthas.deps.ch.qos.logback.classic.model.RootLoggerModel;
import com.alibaba.arthas.deps.ch.qos.logback.core.Context;
import com.alibaba.arthas.deps.ch.qos.logback.core.model.Model;
import com.alibaba.arthas.deps.ch.qos.logback.core.model.processor.ModelHandlerBase;
import com.alibaba.arthas.deps.ch.qos.logback.core.model.processor.ModelHandlerException;
import com.alibaba.arthas.deps.ch.qos.logback.core.model.processor.ModelInterpretationContext;
import com.alibaba.arthas.deps.ch.qos.logback.core.util.OptionHelper;

public class RootLoggerModelHandler
extends ModelHandlerBase {
    Logger root;
    boolean inError = false;

    public RootLoggerModelHandler(Context context) {
        super(context);
    }

    public static RootLoggerModelHandler makeInstance(Context context, ModelInterpretationContext ic) {
        return new RootLoggerModelHandler(context);
    }

    protected Class<RootLoggerModel> getSupportedModelClass() {
        return RootLoggerModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        this.inError = false;
        RootLoggerModel rootLoggerModel = (RootLoggerModel)model;
        LoggerContext loggerContext = (LoggerContext)this.context;
        this.root = loggerContext.getLogger("ROOT");
        String levelStr = mic.subst(rootLoggerModel.getLevel());
        if (!OptionHelper.isNullOrEmpty(levelStr)) {
            Level level = Level.toLevel(levelStr);
            this.addInfo("Setting level of ROOT logger to " + level);
            this.root.setLevel(level);
        }
        mic.pushObject(this.root);
    }

    @Override
    public void postHandle(ModelInterpretationContext mic, Model model) {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.root) {
            this.addWarn("The object [" + o + "] on the top the of the stack is not the root logger");
        } else {
            mic.popObject();
        }
    }
}

