/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.launcher;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.widget.Toast;
import com.alibaba.android.arouter.core.InstrumentationHook;
import com.alibaba.android.arouter.core.LogisticsCenter;
import com.alibaba.android.arouter.exception.HandlerException;
import com.alibaba.android.arouter.exception.InitException;
import com.alibaba.android.arouter.exception.NoRouteFoundException;
import com.alibaba.android.arouter.facade.Postcard;
import com.alibaba.android.arouter.facade.callback.InterceptorCallback;
import com.alibaba.android.arouter.facade.callback.NavigationCallback;
import com.alibaba.android.arouter.facade.service.DegradeService;
import com.alibaba.android.arouter.facade.service.PathReplaceService;
import com.alibaba.android.arouter.facade.template.ILogger;
import com.alibaba.android.arouter.facade.template.ISyringe;
import com.alibaba.android.arouter.launcher.ARouter;
import com.alibaba.android.arouter.thread.DefaultPoolExecutor;
import com.alibaba.android.arouter.utils.DefaultLogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;

final class _ARouter {
    static ILogger logger = new DefaultLogger("ARouter::");
    private static volatile boolean monitorMode = false;
    private static volatile boolean debuggable = false;
    private static volatile boolean autoInject = false;
    private static volatile _ARouter instance = null;
    private static volatile boolean hasInit = false;
    private static volatile ThreadPoolExecutor executor = DefaultPoolExecutor.getInstance();
    private static Context mContext;

    private _ARouter() {
    }

    protected static synchronized boolean init(Application application) {
        mContext = application;
        LogisticsCenter.init(mContext, executor);
        logger.info("ARouter::", "ARouter init success!");
        hasInit = true;
        return true;
    }

    static synchronized void destroy() {
        if (!_ARouter.debuggable()) {
            throw new HandlerException("ARouter::destroy can be used in debug mode only!");
        }
        hasInit = false;
        LogisticsCenter.suspend();
        logger.info("ARouter::", "ARouter destroy success!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static _ARouter getInstance() {
        if (!hasInit) {
            throw new InitException("ARouterCore::Init::Invoke init(context) first!");
        }
        if (instance != null) return instance;
        Class<_ARouter> clazz = _ARouter.class;
        synchronized (_ARouter.class) {
            if (instance != null) return instance;
            instance = new _ARouter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static synchronized void openDebug() {
        debuggable = true;
        logger.info("ARouter::", "ARouter openDebug");
    }

    static synchronized void openLog() {
        logger.showLog(true);
        logger.info("ARouter::", "ARouter openLog");
    }

    @Deprecated
    static synchronized void enableAutoInject() {
        autoInject = true;
    }

    @Deprecated
    static boolean canAutoInject() {
        return autoInject;
    }

    @Deprecated
    static void attachBaseContext() {
        Log.i((String)"ARouter::", (String)"ARouter start attachBaseContext");
        try {
            Class<?> mMainThreadClass = Class.forName("android.app.ActivityThread");
            Method getMainThread = mMainThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]);
            getMainThread.setAccessible(true);
            Object currentActivityThread = getMainThread.invoke(null, new Object[0]);
            Field mInstrumentationField = mMainThreadClass.getDeclaredField("mInstrumentation");
            mInstrumentationField.setAccessible(true);
            mInstrumentationField.set(currentActivityThread, (Object)new InstrumentationHook());
            Log.i((String)"ARouter::", (String)"ARouter hook instrumentation success!");
        }
        catch (Exception ex) {
            Log.e((String)"ARouter::", (String)("ARouter hook instrumentation failed! [" + ex.getMessage() + "]"));
        }
    }

    static synchronized void printStackTrace() {
        logger.showStackTrace(true);
        logger.info("ARouter::", "ARouter printStackTrace");
    }

    static synchronized void setExecutor(ThreadPoolExecutor tpe) {
        executor = tpe;
    }

    static synchronized void monitorMode() {
        monitorMode = true;
        logger.info("ARouter::", "ARouter monitorMode on");
    }

    static boolean isMonitorMode() {
        return monitorMode;
    }

    static boolean debuggable() {
        return debuggable;
    }

    static void setLogger(ILogger userLogger) {
        if (null != userLogger) {
            logger = userLogger;
        }
    }

    static void inject(Object thiz) {
        try {
            Class<?> autowiredClass = Class.forName(thiz.getClass().getName() + "$$ARouter$$Autowired");
            ISyringe iSyringe = (ISyringe)autowiredClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            iSyringe.inject(thiz);
        }
        catch (Exception ex) {
            logger.error("ARouter::", "Autowired made exception, message [" + ex.getMessage() + "]");
        }
    }

    protected Postcard build(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new HandlerException("ARouter::Parameter is invalid!");
        }
        PathReplaceService pService = ARouter.getInstance().navigation(PathReplaceService.class);
        if (null != pService) {
            path = pService.forString(path);
        }
        return this.build(path, this.extractGroup(path));
    }

    protected Postcard build(Uri uri) {
        if (null == uri || StringUtils.isEmpty((CharSequence)uri.toString())) {
            throw new HandlerException("ARouter::Parameter invalid!");
        }
        PathReplaceService pService = ARouter.getInstance().navigation(PathReplaceService.class);
        if (null != pService) {
            uri = pService.forUri(uri);
        }
        return new Postcard(uri.getPath(), this.extractGroup(uri.getPath()), uri, null);
    }

    protected Postcard build(String path, String group) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)group)) {
            throw new HandlerException("ARouter::Parameter is invalid!");
        }
        PathReplaceService pService = ARouter.getInstance().navigation(PathReplaceService.class);
        if (null != pService) {
            path = pService.forString(path);
        }
        return new Postcard(path, group);
    }

    private String extractGroup(String path) {
        if (StringUtils.isEmpty((CharSequence)path) || !path.startsWith("/")) {
            throw new HandlerException("ARouter::Extract the default group failed, the path must be start with '/' and contain more than 2 '/'!");
        }
        try {
            String defaultGroup = path.substring(1, path.indexOf("/", 1));
            if (StringUtils.isEmpty((CharSequence)defaultGroup)) {
                throw new HandlerException("ARouter::Extract the default group failed! There's nothing between 2 '/'!");
            }
            return defaultGroup;
        }
        catch (Exception e) {
            logger.warning("ARouter::", "Failed to extract default group! " + e.getMessage());
            return null;
        }
    }

    static void afterInit() {
        LogisticsCenter.initInterceptors();
    }

    protected <T> T navigation(Class<? extends T> service) {
        try {
            Postcard postcard = LogisticsCenter.buildProvider(service.getSimpleName());
            LogisticsCenter.completion(postcard);
            return (T)postcard.getProvider();
        }
        catch (NoRouteFoundException ex) {
            logger.warning("ARouter::", ex.getMessage());
            return null;
        }
    }

    protected Object navigation(final Context context, Postcard postcard, final int requestCode, NavigationCallback callback) {
        try {
            LogisticsCenter.completion(postcard);
        }
        catch (NoRouteFoundException ex) {
            logger.warning("ARouter::", ex.getMessage());
            if (_ARouter.debuggable()) {
                Toast.makeText((Context)mContext, (CharSequence)("There's no route matched!\n Path = [" + postcard.getPath() + "]\n" + " Group = [" + postcard.getGroup() + "]"), (int)1).show();
            }
            if (null != callback) {
                callback.onLost(postcard);
            } else {
                DegradeService degradeService = ARouter.getInstance().navigation(DegradeService.class);
                if (null != degradeService) {
                    degradeService.onLost(context, postcard);
                }
            }
            return null;
        }
        if (null != callback) {
            callback.onFound(postcard);
        }
        if (postcard.isGreenChannal()) {
            return this._navigation(context, postcard, requestCode);
        }
        LogisticsCenter.interceptions(postcard, new InterceptorCallback(){

            @Override
            public void onContinue(Postcard postcard) {
                _ARouter.this._navigation(context, postcard, requestCode);
            }

            @Override
            public void onInterrupt(Throwable exception) {
                logger.info("ARouter::", "Navigation failed, termination by interceptor : " + exception.getMessage());
            }
        });
        return null;
    }

    private Object _navigation(Context context, Postcard postcard, int requestCode) {
        Context currentContext = null == context ? mContext : context;
        switch (postcard.getType()) {
            case ACTIVITY: {
                Intent intent = new Intent(currentContext, postcard.getDestination());
                intent.putExtras(postcard.getExtras());
                int flags = postcard.getFlags();
                if (-1 != flags) {
                    intent.setFlags(flags);
                } else if (!(currentContext instanceof Activity)) {
                    intent.setFlags(0x10000000);
                }
                if (requestCode > 0) {
                    ((Activity)currentContext).startActivityForResult(intent, requestCode);
                    break;
                }
                currentContext.startActivity(intent);
                break;
            }
            case PROVIDER: {
                return postcard.getProvider();
            }
            default: {
                return null;
            }
        }
        return null;
    }
}

