/*
 * Decompiled with CFR 0.152.
 */
package com.tmall.ultraviewpager;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.tmall.ultraviewpager.UltraViewPager;
import com.tmall.ultraviewpager.UltraViewPagerAdapter;
import com.tmall.ultraviewpager.transformer.UltraVerticalTransformer;

public class UltraViewPagerView
extends ViewPager
implements UltraViewPagerAdapter.UltraViewPagerCenterListener {
    private UltraViewPagerAdapter pagerAdapter;
    private boolean needsMeasurePage;
    private float multiScrRatio = Float.NaN;
    private boolean enableLoop;
    private boolean autoMeasureHeight;
    private double itemRatio = Double.NaN;
    private int constrainLength;
    private int itemMarginLeft;
    private int itemMarginTop;
    private int itemMarginRight;
    private int itemMarginBottom;
    private float ratio = Float.NaN;
    private UltraViewPager.ScrollMode scrollMode = UltraViewPager.ScrollMode.HORIZONTAL;

    public UltraViewPagerView(Context context) {
        super(context);
        this.init(context, null);
    }

    public UltraViewPagerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setClipChildren(false);
        this.setOverScrollMode(2);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.onMeasurePage(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onMeasurePage(int widthMeasureSpec, int heightMeasureSpec) {
        int childLength;
        View view;
        int i;
        int childCount;
        Log.d((String)"TEST", (String)("onMeasurePage" + this.getCurrentItem()));
        View child = this.pagerAdapter.getViewAtPosition(this.getCurrentItem());
        if (child == null) {
            child = this.getChildAt(0);
        }
        if (child == null) {
            return;
        }
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            View view2 = this.getChildAt(i2);
            if (view2.getPaddingLeft() == this.itemMarginLeft && view2.getPaddingTop() == this.itemMarginTop && view2.getPaddingRight() == this.itemMarginRight && view2.getPaddingBottom() == this.itemMarginBottom) continue;
            view2.setPadding(this.itemMarginLeft, this.itemMarginTop, this.itemMarginRight, this.itemMarginBottom);
        }
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int childWidthSpec = UltraViewPagerView.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
        int childHeightSpec = UltraViewPagerView.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
        int childWidth = (int)((float)(View.MeasureSpec.getSize((int)childWidthSpec) - this.getPaddingLeft() - this.getPaddingRight()) * this.pagerAdapter.getPageWidth(this.getCurrentItem()));
        int childHeight = View.MeasureSpec.getSize((int)childHeightSpec) - this.getPaddingTop() - this.getPaddingBottom();
        if (!this.needsMeasurePage || childWidth == 0 && childHeight == 0) {
            return;
        }
        if (!Double.isNaN(this.itemRatio)) {
            int itemHeight = (int)((double)childWidth / this.itemRatio);
            childCount = this.getChildCount();
            for (i = 0; i < childCount; ++i) {
                view = this.getChildAt(i);
                view.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)itemHeight, (int)0x40000000));
            }
        } else {
            int childCount2 = this.getChildCount();
            for (int i3 = 0; i3 < childCount2; ++i3) {
                View view3 = this.getChildAt(i3);
                if (this.pagerAdapter.getPageWidth(this.getCurrentItem()) != 1.0f) {
                    view3.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                    continue;
                }
                view3.measure(childWidthSpec, childHeightSpec);
            }
        }
        boolean isHorizontalScroll = this.scrollMode == UltraViewPager.ScrollMode.HORIZONTAL;
        childWidth = this.itemMarginLeft + child.getMeasuredWidth() + this.itemMarginRight;
        childHeight = this.itemMarginTop + child.getMeasuredHeight() + this.itemMarginBottom;
        if (!Float.isNaN(this.ratio)) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)this.getMeasuredWidth() / this.ratio)), (int)0x40000000);
            this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
            childCount = this.getChildCount();
            for (i = 0; i < childCount; ++i) {
                view = this.getChildAt(i);
                view.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), heightMeasureSpec);
            }
        } else if (this.autoMeasureHeight) {
            if (isHorizontalScroll) {
                this.constrainLength = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
                this.setMeasuredDimension(this.getMeasuredWidth(), childHeight);
            } else {
                this.constrainLength = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000);
                this.setMeasuredDimension(childWidth, this.getMeasuredHeight());
            }
            boolean bl = this.needsMeasurePage = childHeight == this.itemMarginTop + this.itemMarginBottom;
        }
        if (!this.pagerAdapter.isEnableMultiScr()) {
            return;
        }
        int pageLength = isHorizontalScroll ? this.getMeasuredWidth() : this.getMeasuredHeight();
        int n = childLength = isHorizontalScroll ? child.getMeasuredWidth() : child.getMeasuredHeight();
        if (childLength > 0) {
            this.needsMeasurePage = false;
            int difference = pageLength - childLength;
            if (this.getPageMargin() == 0) {
                this.setPageMargin(-difference);
            }
            int offscreen = (int)Math.ceil((float)pageLength / (float)childLength) + 1;
            this.setOffscreenPageLimit(offscreen);
            this.requestLayout();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.needsMeasurePage = true;
    }

    public void setAdapter(PagerAdapter adapter) {
        if (adapter != null) {
            this.pagerAdapter = new UltraViewPagerAdapter(adapter);
            this.pagerAdapter.setCenterListener(this);
            this.pagerAdapter.setEnableLoop(this.enableLoop);
            this.pagerAdapter.setMultiScrRatio(this.multiScrRatio);
            this.needsMeasurePage = true;
            this.constrainLength = 0;
            super.setAdapter((PagerAdapter)this.pagerAdapter);
        } else {
            super.setAdapter(adapter);
        }
    }

    public void setCurrentItem(int item) {
        this.setCurrentItem(item, false);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        if (this.pagerAdapter.getCount() != 0 && this.pagerAdapter.isEnableLoop()) {
            item = this.pagerAdapter.getCount() / 2 + item % this.pagerAdapter.getRealCount();
        }
        super.setCurrentItem(item, smoothScroll);
    }

    public int getCurrentItem() {
        if (this.pagerAdapter.getCount() != 0) {
            int position = super.getCurrentItem();
            return position % this.pagerAdapter.getRealCount();
        }
        return super.getCurrentItem();
    }

    void setCurrentItemFake(int item, boolean smoothScroll) {
        super.setCurrentItem(item, smoothScroll);
    }

    int getCurrentItemFake() {
        return super.getCurrentItem();
    }

    public void setMultiScreen(float ratio) {
        this.multiScrRatio = ratio;
        if (this.pagerAdapter != null) {
            this.pagerAdapter.setMultiScrRatio(ratio);
            this.needsMeasurePage = true;
        }
        float pageMargin = (1.0f - ratio) * (float)this.getResources().getDisplayMetrics().widthPixels;
        if (this.scrollMode == UltraViewPager.ScrollMode.VERTICAL) {
            this.setPageMargin((int)pageMargin);
        } else {
            this.setPageMargin((int)(-(pageMargin + (float)this.convertDp2Px(this.getContext(), 1.0f))));
        }
    }

    private int convertDp2Px(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void setEnableLoop(boolean status) {
        this.enableLoop = status;
        if (this.pagerAdapter != null) {
            this.pagerAdapter.setEnableLoop(this.enableLoop);
        }
    }

    public void setItemRatio(double itemRatio) {
        this.itemRatio = itemRatio;
    }

    public void setAutoMeasureHeight(boolean autoMeasureHeight) {
        this.autoMeasureHeight = autoMeasureHeight;
    }

    public void setScrollMode(UltraViewPager.ScrollMode scrollMode) {
        this.scrollMode = scrollMode;
        if (scrollMode == UltraViewPager.ScrollMode.VERTICAL) {
            this.setPageTransformer(false, new UltraVerticalTransformer());
        }
    }

    public UltraViewPager.ScrollMode getScrollMode() {
        return this.scrollMode;
    }

    public int getConstrainLength() {
        return this.constrainLength;
    }

    public void setItemMargin(int left, int top, int right, int bottom) {
        this.itemMarginLeft = left;
        this.itemMarginTop = top;
        this.itemMarginRight = right;
        this.itemMarginBottom = bottom;
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    @Override
    public void center() {
        this.setCurrentItem(0);
    }

    @Override
    public void resetPosition() {
        this.setCurrentItem(this.getCurrentItem());
    }

    private MotionEvent swapTouchEvent(MotionEvent event) {
        float width = this.getWidth();
        float height = this.getHeight();
        float swappedX = event.getY() / height * width;
        float swappedY = event.getX() / width * height;
        event.setLocation(swappedX, swappedY);
        return event;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.scrollMode == UltraViewPager.ScrollMode.VERTICAL) {
            boolean intercept = super.onInterceptTouchEvent(this.swapTouchEvent(ev));
            this.swapTouchEvent(ev);
            return intercept;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.scrollMode == UltraViewPager.ScrollMode.VERTICAL) {
            return super.onTouchEvent(this.swapTouchEvent(ev));
        }
        return super.onTouchEvent(ev);
    }
}

