/*
 * Decompiled with CFR 0.152.
 */
package com.tmall.ultraviewpager;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.tmall.ultraviewpager.IUltraIndicatorBuilder;
import com.tmall.ultraviewpager.UltraViewPager;
import com.tmall.ultraviewpager.UltraViewPagerAdapter;
import com.tmall.ultraviewpager.UltraViewPagerView;

public class UltraViewPagerIndicator
extends View
implements ViewPager.OnPageChangeListener,
IUltraIndicatorBuilder {
    private UltraViewPagerView viewPager;
    private ViewPager.OnPageChangeListener pageChangeListener;
    private int scrollState;
    private int radius;
    private int indicatorPadding;
    private boolean animateIndicator;
    private int gravity;
    private UltraViewPager.Orientation orientation = UltraViewPager.Orientation.HORIZONTAL;
    private int marginLeft;
    private int marginTop;
    private int marginRight;
    private int marginBottom;
    private int focusColor;
    private int normalColor;
    private Bitmap focusBitmap;
    private Bitmap normalBitmap;
    private Paint paintStroke;
    private Paint paintFill;
    float pageOffset;
    float defaultRadius;
    private static final int DEFAULT_RADIUS = 3;
    private UltraViewPagerIndicatorListener indicatorBuildListener;

    public UltraViewPagerIndicator(Context context) {
        super(context);
        this.init();
    }

    public UltraViewPagerIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public UltraViewPagerIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.paintStroke = new Paint(1);
        this.paintStroke.setStyle(Paint.Style.STROKE);
        this.paintFill = new Paint(1);
        this.paintFill.setStyle(Paint.Style.FILL);
        this.defaultRadius = TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setViewPager(UltraViewPagerView viewPager) {
        this.viewPager = viewPager;
        this.viewPager.setOnPageChangeListener(this);
    }

    protected void onDraw(Canvas canvas) {
        float dY;
        float dX;
        int widthRatio;
        int shortPaddingAfter;
        int shortPaddingBefore;
        int longPaddingAfter;
        int longPaddingBefore;
        int shortSize;
        int longSize;
        super.onDraw(canvas);
        if (this.viewPager == null || this.viewPager.getAdapter() == null) {
            return;
        }
        int count = ((UltraViewPagerAdapter)this.viewPager.getAdapter()).getRealCount();
        if (count == 0) {
            return;
        }
        if (this.orientation == UltraViewPager.Orientation.HORIZONTAL) {
            longSize = this.viewPager.getWidth();
            shortSize = this.viewPager.getHeight();
            longPaddingBefore = (int)(this.getItemWidth() + (float)this.getPaddingLeft() + (float)this.marginLeft);
            longPaddingAfter = this.getPaddingRight() + this.marginRight;
            shortPaddingBefore = (int)(this.getItemWidth() + (float)this.getPaddingTop() + (float)this.marginTop);
            shortPaddingAfter = (int)this.paintStroke.getStrokeWidth() + this.getPaddingBottom() + this.marginBottom;
        } else {
            longSize = this.viewPager.getHeight();
            shortSize = this.viewPager.getWidth();
            longPaddingBefore = (int)(this.getItemWidth() + (float)this.getPaddingTop() + (float)this.marginTop);
            longPaddingAfter = (int)this.paintStroke.getStrokeWidth() + this.getPaddingBottom() + this.marginBottom;
            shortPaddingBefore = (int)(this.getItemWidth() + (float)this.getPaddingLeft() + (float)this.marginLeft);
            shortPaddingAfter = this.getPaddingRight() + this.marginRight;
        }
        float itemWidth = this.getItemWidth();
        int n = widthRatio = this.isDrawResIndicator() ? 1 : 2;
        if (this.indicatorPadding == 0) {
            this.indicatorPadding = (int)itemWidth;
        }
        float shortOffset = shortPaddingBefore;
        float longOffset = longPaddingBefore;
        float indicatorLength = (float)count * itemWidth * (float)widthRatio + (float)((count - 1) * this.indicatorPadding);
        int horizontalGravityMask = this.gravity & 7;
        int verticalGravityMask = this.gravity & 0x70;
        switch (horizontalGravityMask) {
            case 1: {
                longOffset = ((float)(longSize - longPaddingBefore - longPaddingAfter) - indicatorLength) / 2.0f;
                break;
            }
            case 5: {
                if (this.orientation == UltraViewPager.Orientation.HORIZONTAL) {
                    longOffset = (float)(longSize - longPaddingAfter) - indicatorLength;
                }
                if (this.orientation != UltraViewPager.Orientation.VERTICAL) break;
                shortOffset = (float)(shortSize - shortPaddingAfter) - itemWidth;
                break;
            }
        }
        switch (verticalGravityMask) {
            case 16: {
                shortOffset = ((float)(shortSize - shortPaddingAfter - shortPaddingBefore) - itemWidth) / 2.0f;
                break;
            }
            case 80: {
                if (this.orientation == UltraViewPager.Orientation.HORIZONTAL) {
                    shortOffset = (float)(shortSize - shortPaddingAfter) - this.getItemHeight();
                }
                if (this.orientation != UltraViewPager.Orientation.VERTICAL) break;
                longOffset = (float)(longSize - longPaddingAfter) - indicatorLength;
                break;
            }
        }
        if (horizontalGravityMask == 1 && verticalGravityMask == 16) {
            shortOffset = ((float)(shortSize - shortPaddingAfter - shortPaddingBefore) - itemWidth) / 2.0f;
        }
        float pageFillRadius = this.radius;
        if (this.paintStroke.getStrokeWidth() > 0.0f) {
            pageFillRadius -= this.paintStroke.getStrokeWidth() / 2.0f;
        }
        for (int iLoop = 0; iLoop < count; ++iLoop) {
            float drawLong = longOffset + (float)iLoop * (itemWidth * (float)widthRatio + (float)this.indicatorPadding);
            if (this.orientation == UltraViewPager.Orientation.HORIZONTAL) {
                dX = drawLong;
                dY = shortOffset;
            } else {
                dX = shortOffset;
                dY = drawLong;
            }
            if (this.isDrawResIndicator()) {
                if (iLoop == this.viewPager.getCurrentItem()) continue;
                canvas.drawBitmap(this.normalBitmap, dX, dY, this.paintFill);
                continue;
            }
            if (this.paintFill.getAlpha() > 0) {
                this.paintFill.setColor(this.normalColor);
                canvas.drawCircle(dX, dY, pageFillRadius, this.paintFill);
            }
            if (pageFillRadius == (float)this.radius) continue;
            canvas.drawCircle(dX, dY, (float)this.radius, this.paintStroke);
        }
        float cx = (float)this.viewPager.getCurrentItem() * (itemWidth * (float)widthRatio + (float)this.indicatorPadding);
        if (this.animateIndicator) {
            cx += this.pageOffset * itemWidth;
        }
        if (this.orientation == UltraViewPager.Orientation.HORIZONTAL) {
            dX = longOffset + cx;
            dY = shortOffset;
        } else {
            dX = shortOffset;
            dY = longOffset + cx;
        }
        if (this.isDrawResIndicator()) {
            canvas.drawBitmap(this.focusBitmap, dX, dY, this.paintStroke);
        } else {
            this.paintFill.setColor(this.focusColor);
            canvas.drawCircle(dX, dY, (float)this.radius, this.paintFill);
        }
    }

    private boolean isDrawResIndicator() {
        return this.focusBitmap != null && this.normalBitmap != null;
    }

    private float getItemWidth() {
        if (this.isDrawResIndicator()) {
            return Math.max(this.focusBitmap.getWidth(), this.normalBitmap.getWidth());
        }
        return this.radius == 0 ? this.defaultRadius : (float)this.radius;
    }

    private float getItemHeight() {
        if (this.isDrawResIndicator()) {
            return Math.max(this.focusBitmap.getHeight(), this.normalBitmap.getHeight());
        }
        return this.radius == 0 ? this.defaultRadius : (float)this.radius;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.pageOffset = positionOffset;
        this.invalidate();
        if (this.pageChangeListener != null) {
            this.pageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.scrollState == 0) {
            this.invalidate();
        }
        if (this.pageChangeListener != null) {
            this.pageChangeListener.onPageSelected(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
        this.scrollState = state;
        if (this.pageChangeListener != null) {
            this.pageChangeListener.onPageScrollStateChanged(state);
        }
    }

    @Override
    public IUltraIndicatorBuilder setOrientation(UltraViewPager.Orientation orien) {
        this.orientation = orien;
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setIndicatorPadding(int indicatorPadding) {
        this.indicatorPadding = indicatorPadding;
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setFocusColor(int focusColor) {
        this.focusColor = focusColor;
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setNormalColor(int normalColor) {
        this.normalColor = normalColor;
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setStrokeColor(int strokeColor) {
        this.paintStroke.setColor(strokeColor);
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setStrokeWidth(int strokeWidth) {
        this.paintStroke.setStrokeWidth((float)strokeWidth);
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setFocusResId(int focusResId) {
        try {
            this.focusBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)focusResId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setNormalResId(int normalResId) {
        try {
            this.normalBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)normalResId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setFocusIcon(Bitmap bitmap) {
        this.focusBitmap = bitmap;
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setNormalIcon(Bitmap bitmap) {
        this.normalBitmap = bitmap;
        return this;
    }

    @Override
    public IUltraIndicatorBuilder setMargin(int left, int top, int right, int bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
        return this;
    }

    @Override
    public void build() {
        if (this.indicatorBuildListener != null) {
            this.indicatorBuildListener.build();
        }
    }

    public void setPageChangeListener(ViewPager.OnPageChangeListener pageChangeListener) {
        this.pageChangeListener = pageChangeListener;
    }

    public void setIndicatorBuildListener(UltraViewPagerIndicatorListener listener) {
        this.indicatorBuildListener = listener;
    }

    static interface UltraViewPagerIndicatorListener {
        public void build();
    }
}

