/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.match.INodeTypeManager;
import com.ql.util.express.parse.KeyWordDefine4Java;
import com.ql.util.express.parse.NodeType;
import com.ql.util.express.parse.NodeTypeKind;
import com.ql.util.express.parse.WordSplit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class NodeTypeManager
implements INodeTypeManager {
    public final String[] splitWord;
    private final String[] keyWords;
    private final String[] nodeTypeDefines;
    protected final String[][] instructionFactoryMapping;
    protected final Map<String, NodeType> nodeTypes = new HashMap<String, NodeType>();
    protected final Map<String, String> functions = new HashMap<String, String>();

    public NodeTypeManager() {
        this(new KeyWordDefine4Java());
    }

    public NodeTypeManager(KeyWordDefine4Java keyWordDefine) {
        this.splitWord = keyWordDefine.splitWord;
        WordSplit.sortSplitWord(this.splitWord);
        this.keyWords = keyWordDefine.keyWords;
        this.nodeTypeDefines = keyWordDefine.nodeTypeDefines;
        this.instructionFactoryMapping = keyWordDefine.instructionFactoryMapping;
        this.initial();
        this.addOperatorWithRealNodeType("and", "&&");
        this.addOperatorWithRealNodeType("or", "||");
    }

    public void initial() {
        int i;
        NodeType[] tempKeyWordNodeTypes = new NodeType[this.splitWord.length + this.keyWords.length];
        for (i = 0; i < this.splitWord.length; ++i) {
            tempKeyWordNodeTypes[i] = this.createNodeType(this.splitWord[i] + ":TYPE=KEYWORD");
        }
        for (i = 0; i < this.keyWords.length; ++i) {
            tempKeyWordNodeTypes[i + this.splitWord.length] = this.createNodeType(this.keyWords[i] + ":TYPE=KEYWORD");
        }
        for (NodeType tempKeyWordNodeType : tempKeyWordNodeTypes) {
            tempKeyWordNodeType.initial();
        }
        NodeType[] nodeTypes = new NodeType[this.nodeTypeDefines.length];
        for (int i2 = 0; i2 < this.nodeTypeDefines.length; ++i2) {
            nodeTypes[i2] = this.createNodeType(this.nodeTypeDefines[i2]);
        }
        for (NodeType nodeType : nodeTypes) {
            nodeType.initial();
        }
        if (this.instructionFactoryMapping != null) {
            for (NodeType nodeType : this.instructionFactoryMapping) {
                for (String s : ((String)((Object)nodeType[0])).split(",")) {
                    this.findNodeType(s).setInstructionFactory((String)((Object)nodeType[1]));
                }
            }
        }
    }

    public NodeType createNodeType(String defineStr) {
        int index = defineStr.indexOf(":", 1);
        String name = defineStr.substring(0, index).trim();
        NodeType define = this.nodeTypes.get(name);
        if (define != null) {
            throw new RuntimeException("\u8282\u70b9\u7c7b\u578b\u5b9a\u4e49\u91cd\u590d:" + name + " \u5b9a\u4e491=" + define.getDefineStr() + " \u5b9a\u4e492=" + defineStr);
        }
        define = new NodeType(this, name, defineStr);
        this.nodeTypes.put(name, define);
        return define;
    }

    @Override
    public NodeType findNodeType(String name) {
        NodeType result = this.nodeTypes.get(name);
        if (result == null) {
            throw new RuntimeException("\u6ca1\u6709\u5b9a\u4e49\u7684\u8282\u70b9\u7c7b\u578b\uff1a" + name);
        }
        while (result.getRealNodeType() != null) {
            result = result.getRealNodeType();
        }
        return result;
    }

    public void addOperatorWithRealNodeType(String keyWordName, String realName) {
        NodeType target = this.createNodeType(keyWordName + ":TYPE=KEYWORD,REAL=" + realName);
        target.initial();
    }

    public void addOperatorWithLevelOfReference(String operatorName, String refOperatorName) throws Exception {
        NodeType target = this.createNodeType(operatorName + ":TYPE=KEYWORD");
        target.initial();
        NodeType[] list = this.getNodeTypesByKind(NodeTypeKind.OPERATOR);
        NodeType refNodeType = this.findNodeType(refOperatorName);
        target.setInstructionFactory(refNodeType.getInstructionFactory());
        for (NodeType item : list) {
            if (!item.isContainerChild(refNodeType)) continue;
            item.addChild(target);
            return;
        }
    }

    public NodeType isExistNodeTypeDefine(String name) {
        NodeType result = this.nodeTypes.get(name);
        if (result != null && result.getRealNodeType() != null) {
            result = result.getRealNodeType();
        }
        return result;
    }

    public NodeType[] getNodeTypesByKind(NodeTypeKind nodeTypeKind) {
        ArrayList<NodeType> result = new ArrayList<NodeType>();
        for (NodeType item : this.nodeTypes.values()) {
            if (item.getKind() != nodeTypeKind) continue;
            result.add(item);
        }
        return result.toArray(new NodeType[0]);
    }

    public boolean isFunction(String name) {
        return this.functions.containsKey(name);
    }

    public void addFunctionName(String name) {
        this.functions.put(name, name);
    }
}

