/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.match;

import com.ql.util.express.exception.QLCompileException;
import com.ql.util.express.match.IDataNode;
import com.ql.util.express.match.INodeType;
import com.ql.util.express.match.INodeTypeManager;
import com.ql.util.express.match.MatchMode;
import com.ql.util.express.match.QLMatchResult;
import com.ql.util.express.match.QLMatchResultTree;
import com.ql.util.express.match.QLPatternNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class QLPattern {
    private QLPattern() {
        throw new IllegalStateException("Utility class");
    }

    public static QLPatternNode createPattern(INodeTypeManager nodeTypeManager, String name, String pattern) throws Exception {
        return new QLPatternNode(nodeTypeManager, name, pattern);
    }

    public static QLMatchResult findMatchStatement(INodeTypeManager iNodeTypeManager, QLPatternNode pattern, List<? extends IDataNode> nodes, int point) throws Exception {
        AtomicLong maxDeep = new AtomicLong(1L);
        AtomicLong maxMatchPoint = new AtomicLong();
        QLMatchResultCache resultCache = new QLMatchResultCache(5);
        ArrayListCache arrayListCache = new ArrayListCache(50);
        MatchParamsPack staticParams = new MatchParamsPack(iNodeTypeManager, nodes, maxDeep, maxMatchPoint, resultCache, arrayListCache);
        QLMatchResult result = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, pattern, point, 1);
        if (result == null || result.getMatchSize() == 0) {
            throw new QLCompileException("\u7a0b\u5e8f\u9519\u8bef\uff0c\u4e0d\u6ee1\u8db3\u8bed\u6cd5\u89c4\u8303\uff0c\u6ca1\u6709\u5339\u914d\u5230\u5408\u9002\u7684\u8bed\u6cd5,\u6700\u5927\u5339\u914d\u81f3[0:" + (maxMatchPoint.longValue() - 1L) + "]");
        }
        if (result.getMatchSize() != 1) {
            throw new QLCompileException("\u7a0b\u5e8f\u9519\u8bef\uff0c\u4e0d\u6ee1\u8db3\u8bed\u6cd5\u89c4\u8303\uff0c\u5fc5\u987b\u6709\u4e00\u4e2a\u6839\u8282\u70b9\uff1a" + pattern + ",\u6700\u5927\u5339\u914d\u81f3[0:" + (maxMatchPoint.longValue() - 1L) + "]");
        }
        return result;
    }

    private static QLMatchResult findMatchStatementWithAddRootOptimizeStack(MatchParamsPack staticParams, QLPatternNode pattern, int point, int deep) throws Exception {
        QLMatchResult result;
        List<QLMatchResultTree> tempList;
        List<? extends IDataNode> nodes;
        block59: {
            INodeTypeManager iNodeTypeManager = staticParams.iNodeTypeManager;
            nodes = staticParams.nodes;
            AtomicLong maxMatchPoint = staticParams.maxMatchPoint;
            AtomicLong maxDeep = staticParams.maxDeep;
            if ((long)(++deep) > maxDeep.longValue()) {
                maxDeep.set(deep);
            }
            tempList = null;
            int count = 0;
            int lastPoint = point;
            do {
                QLMatchResult tempResult = null;
                if (pattern.matchMode == MatchMode.DETAIL) {
                    int pointDetail = lastPoint;
                    QLMatchResult resultDetail = null;
                    if (pattern.nodeType == iNodeTypeManager.findNodeType("EOF") && pointDetail == nodes.size()) {
                        resultDetail = staticParams.resultCache.fetch().setMatchLastIndex(pointDetail + 1);
                    } else if (pattern.nodeType == iNodeTypeManager.findNodeType("EOF") && pointDetail < nodes.size() && "}".equals(nodes.get(pointDetail).getValue())) {
                        resultDetail = staticParams.resultCache.fetch().setMatchLastIndex(pointDetail);
                    } else if (pointDetail == nodes.size() && pattern.nodeType.getPatternNode() != null) {
                        resultDetail = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, pattern.nodeType.getPatternNode(), pointDetail, deep);
                    } else if (pointDetail < nodes.size()) {
                        INodeType tempNodeType = null;
                        if (pattern.nodeType.equals(nodes.get(pointDetail).getTreeType())) {
                            tempNodeType = nodes.get(pointDetail).getTreeType();
                        } else if (pattern.nodeType.equals(nodes.get(pointDetail).getNodeType())) {
                            tempNodeType = nodes.get(pointDetail).getNodeType();
                        }
                        if (tempNodeType != null) {
                            resultDetail = staticParams.resultCache.fetch();
                            resultDetail.addQLMatchResultTree(new QLMatchResultTree(tempNodeType, nodes.get(pointDetail), pattern.targetNodeType));
                            resultDetail.setMatchLastIndex(++pointDetail);
                        } else if (pattern.nodeType.getPatternNode() != null) {
                            resultDetail = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, pattern.nodeType.getPatternNode(), pointDetail, deep);
                            if (pattern.targetNodeType != null && resultDetail != null && resultDetail.getMatchSize() > 0) {
                                if (resultDetail.getMatchSize() > 1) {
                                    throw new QLCompileException("\u8bbe\u7f6e\u4e86\u7c7b\u578b\u8f6c\u6362\u7684\u8bed\u6cd5\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u6839\u8282\u70b9");
                                }
                                resultDetail.getMatches().get(0).setTargetNodeType(pattern.targetNodeType);
                            }
                        }
                        if (pattern.blame) {
                            if (resultDetail == null) {
                                resultDetail = staticParams.resultCache.fetch();
                                resultDetail.addQLMatchResultTree(new QLMatchResultTree(tempNodeType, nodes.get(pointDetail), null));
                                resultDetail.setMatchLastIndex(++pointDetail);
                            } else {
                                resultDetail = null;
                            }
                        }
                    }
                    if (resultDetail != null && (long)resultDetail.getMatchLastIndex() > maxMatchPoint.longValue()) {
                        maxMatchPoint.set(resultDetail.getMatchLastIndex());
                    }
                    tempResult = resultDetail;
                } else if (pattern.matchMode == MatchMode.AND) {
                    int pointAnd = lastPoint;
                    QLMatchResultTree root = null;
                    int matchCount = 0;
                    List<QLMatchResultTree> tempListAnd = null;
                    boolean isBreak = false;
                    for (QLPatternNode item : pattern.getChildren()) {
                        if (pointAnd > nodes.size()) {
                            isBreak = true;
                            break;
                        }
                        QLMatchResult tempResultAnd = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, item, pointAnd, deep);
                        if (tempResultAnd != null) {
                            if (tempResultAnd.getMatchSize() > 0) {
                                ++matchCount;
                            }
                            if (tempListAnd == null) {
                                tempListAnd = staticParams.arrayListCache.fetch();
                            }
                            pointAnd = tempResultAnd.getMatchLastIndex();
                            if (item.isTreeRoot && tempResultAnd.getMatchSize() > 0) {
                                if (tempResultAnd.getMatchSize() > 1) {
                                    throw new QLCompileException("\u6839\u8282\u70b9\u7684\u6570\u91cf\u5fc5\u987b\u662f1");
                                }
                                if (root == null) {
                                    QLMatchResultTree tempTree = tempResultAnd.getMatches().get(0);
                                    while (tempTree.getLeft() != null && !tempTree.getLeft().isEmpty()) {
                                        tempTree = tempTree.getLeft().get(0);
                                    }
                                    tempTree.addLeftAll(tempListAnd);
                                    tempListAnd.clear();
                                } else {
                                    tempResultAnd.getMatches().get(0).addLeft(root);
                                }
                                root = tempResultAnd.getMatches().get(0);
                            } else if (root != null) {
                                root.addRightAll(tempResultAnd.getMatches());
                            } else {
                                tempListAnd.addAll(tempResultAnd.getMatches());
                            }
                            if (tempResultAnd == null) continue;
                            staticParams.resultCache.sendBack(tempResultAnd);
                            continue;
                        }
                        isBreak = true;
                        break;
                    }
                    if (root != null) {
                        tempListAnd.add(root);
                    }
                    if (!isBreak) {
                        tempResult = staticParams.resultCache.fetch().addQLMatchResultTreeList(tempListAnd);
                        tempResult.setMatchLastIndex(pointAnd);
                    } else {
                        tempResult = null;
                    }
                    if (tempListAnd != null) {
                        staticParams.arrayListCache.sendBack(tempListAnd);
                    }
                } else if (pattern.matchMode == MatchMode.OR) {
                    QLPatternNode item;
                    Iterator<QLPatternNode> iterator = pattern.getChildren().iterator();
                    while (iterator.hasNext() && (tempResult = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, item = iterator.next(), lastPoint, deep)) == null) {
                    }
                } else {
                    throw new QLCompileException("\u4e0d\u6b63\u786e\u7684\u7c7b\u578b\uff1a" + pattern.matchMode.toString());
                }
                if (tempResult == null) {
                    if (count >= pattern.minMatchNum && count <= pattern.maxMatchNum) {
                        result = staticParams.resultCache.fetch();
                        if (tempList != null) {
                            result.addQLMatchResultTreeList(tempList);
                        }
                        result.setMatchLastIndex(lastPoint);
                    } else {
                        result = null;
                    }
                    break block59;
                }
                if (tempList == null) {
                    tempList = staticParams.arrayListCache.fetch();
                }
                lastPoint = tempResult.getMatchLastIndex();
                if (pattern.isTreeRoot) {
                    if (tempResult.getMatchSize() > 1) {
                        throw new QLCompileException("\u6839\u8282\u70b9\u7684\u6570\u91cf\u5fc5\u987b\u662f1");
                    }
                    if (tempList.isEmpty()) {
                        tempList.addAll(tempResult.getMatches());
                    } else {
                        tempResult.getMatches().get(0).addLeftAll(tempList);
                        tempList = staticParams.arrayListCache.fetch();
                        tempList.addAll(tempResult.getMatches());
                    }
                } else {
                    tempList.addAll(tempResult.getMatches());
                }
                if (tempResult == null) continue;
                staticParams.resultCache.sendBack(tempResult);
            } while (++count != pattern.maxMatchNum);
            result = staticParams.resultCache.fetch();
            if (tempList != null) {
                result.addQLMatchResultTreeList(tempList);
            }
            result.setMatchLastIndex(lastPoint);
        }
        if (result != null && pattern.isSkip) {
            result.getMatches().clear();
        }
        if (result != null && result.getMatchSize() > 0 && pattern.rootNodeType != null) {
            QLMatchResultTree tempTree = new QLMatchResultTree(pattern.rootNodeType, nodes.get(0).createExpressNode(pattern.rootNodeType, null));
            tempTree.addLeftAll(result.getMatches());
            result.getMatches().clear();
            result.getMatches().add(tempTree);
        }
        if (tempList != null) {
            staticParams.arrayListCache.sendBack(tempList);
        }
        return result;
    }

    public static class ArrayListCache<T> {
        public int newCount = 0;
        public int fetchCount = 0;
        private final List<T>[] cache;
        private final int len;
        private int point;

        public ArrayListCache(int length) {
            this.len = length;
            this.point = this.len - 1;
            this.cache = new List[this.len];
            for (int i = 0; i < this.len; ++i) {
                this.cache[i] = new ArrayList<T>();
            }
        }

        public List<T> fetch() {
            List<Object> result;
            if (this.point >= 0) {
                result = this.cache[this.point];
                this.cache[this.point] = null;
                --this.point;
                ++this.fetchCount;
            } else {
                result = new ArrayList();
                ++this.newCount;
            }
            return result;
        }

        public void sendBack(List<T> result) {
            if (this.point < this.len - 1) {
                ++this.point;
                this.cache[this.point] = result;
                this.cache[this.point].clear();
            }
        }
    }

    public static class QLMatchResultCache {
        public int newCount = 0;
        public int fetchCount = 0;
        private final QLMatchResult[] cache;
        private final int length;
        private int point;

        public QLMatchResultCache(int length) {
            this.length = length;
            this.point = this.length - 1;
            this.cache = new QLMatchResult[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.cache[i] = new QLMatchResult();
            }
        }

        public QLMatchResult fetch() {
            QLMatchResult result;
            if (this.point >= 0) {
                result = this.cache[this.point];
                this.cache[this.point] = null;
                --this.point;
                ++this.fetchCount;
            } else {
                result = new QLMatchResult();
                ++this.newCount;
            }
            return result;
        }

        public void sendBack(QLMatchResult result) {
            if (this.point < this.length - 1) {
                ++this.point;
                this.cache[this.point] = result;
                this.cache[this.point].clear();
            }
        }
    }

    public static class MatchParamsPack {
        final INodeTypeManager iNodeTypeManager;
        final List<? extends IDataNode> nodes;
        final AtomicLong maxDeep;
        final AtomicLong maxMatchPoint;
        final QLMatchResultCache resultCache;
        final ArrayListCache arrayListCache;

        public MatchParamsPack(INodeTypeManager iNodeTypeManager, List<? extends IDataNode> nodes, AtomicLong maxDeep, AtomicLong maxMatchPoint, QLMatchResultCache qlMatchResultCache, ArrayListCache arrayListCache) {
            this.iNodeTypeManager = iNodeTypeManager;
            this.nodes = nodes;
            this.maxDeep = maxDeep;
            this.maxMatchPoint = maxMatchPoint;
            this.resultCache = qlMatchResultCache;
            this.arrayListCache = arrayListCache;
        }
    }
}

