/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.ExpressUtil;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.OperatorOfNumber;
import com.ql.util.express.config.QLExpressRunStrategy;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.op.OperatorBase;
import java.util.Date;

public abstract class Operator
extends OperatorBase {
    @Override
    public OperateData executeInner(InstructionSetContext parent, ArraySwap list) throws Exception {
        Object[] parameters = new Object[list.length];
        for (int i = 0; i < list.length; ++i) {
            parameters[i] = list.get(i) == null && QLExpressRunStrategy.isAvoidNullPointer() ? null : list.get(i).getObject(parent);
        }
        Object result = this.executeInner(parameters);
        if (result != null && result.getClass().equals(OperateData.class)) {
            throw new QLException("\u64cd\u4f5c\u7b26\u53f7\u5b9a\u4e49\u7684\u8fd4\u56de\u7c7b\u578b\u9519\u8bef\uff1a" + this.getAliasName());
        }
        if (result == null) {
            return OperateDataCacheManager.fetchOperateData(null, null);
        }
        return OperateDataCacheManager.fetchOperateData(result, ExpressUtil.getSimpleDataType(result.getClass()));
    }

    public abstract Object executeInner(Object[] var1) throws Exception;

    public static boolean objectEquals(Object op1, Object op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        if (op1 instanceof Character || op2 instanceof Character) {
            if (op1 instanceof Character && op2 instanceof Character) {
                return op1.equals(op2);
            }
            if (op1 instanceof Number) {
                int compareResult = OperatorOfNumber.compareNumber((Number)op1, (int)((Character)op2).charValue());
                return compareResult == 0;
            }
            if (op2 instanceof Number) {
                int compareResult = OperatorOfNumber.compareNumber((int)((Character)op1).charValue(), (Number)op2);
                return compareResult == 0;
            }
        }
        if (op1 instanceof Number && op2 instanceof Number) {
            int compareResult = OperatorOfNumber.compareNumber((Number)op1, (Number)op2);
            return compareResult == 0;
        }
        return op1.equals(op2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int compareData(Object op1, Object op2) throws Exception {
        if (op1 == op2) {
            return 0;
        }
        if (op1 instanceof String) {
            return ((String)op1).compareTo(op2.toString());
        }
        if (op2 instanceof String) {
            return op1.toString().compareTo((String)op2);
        }
        if (op1 instanceof Character || op2 instanceof Character) {
            if (op1 instanceof Character && op2 instanceof Character) {
                return ((Character)op1).compareTo((Character)op2);
            }
            if (op1 instanceof Number) {
                return OperatorOfNumber.compareNumber((Number)op1, (int)((Character)op2).charValue());
            }
            if (!(op2 instanceof Number)) throw new QLException(op1 + "\u548c" + op2 + "\u4e0d\u80fd\u6267\u884ccompare \u64cd\u4f5c");
            return OperatorOfNumber.compareNumber((int)((Character)op1).charValue(), (Number)op2);
        }
        if (op1 instanceof Number && op2 instanceof Number) {
            return OperatorOfNumber.compareNumber((Number)op1, (Number)op2);
        }
        if (op1 instanceof Boolean && op2 instanceof Boolean) {
            if (((Boolean)op1).booleanValue() != ((Boolean)op2).booleanValue()) return -1;
            return 0;
        }
        if (!(op1 instanceof Date)) throw new QLException(op1 + "\u548c" + op2 + "\u4e0d\u80fd\u6267\u884ccompare \u64cd\u4f5c");
        if (!(op2 instanceof Date)) throw new QLException(op1 + "\u548c" + op2 + "\u4e0d\u80fd\u6267\u884ccompare \u64cd\u4f5c");
        return ((Date)op1).compareTo((Date)op2);
    }
}

