/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.DefaultExpressResourceLoader;
import com.ql.util.express.ExecuteTimeout;
import com.ql.util.express.ExportItem;
import com.ql.util.express.ExpressLoader;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.IExpressResourceLoader;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetRunner;
import com.ql.util.express.Operator;
import com.ql.util.express.exception.QLCompileException;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.ForRelBreakContinue;
import com.ql.util.express.instruction.IOperateDataCache;
import com.ql.util.express.instruction.InstructionFactory;
import com.ql.util.express.instruction.OperateDataCacheImpl;
import com.ql.util.express.instruction.op.OperatorBase;
import com.ql.util.express.instruction.op.OperatorFactory;
import com.ql.util.express.instruction.op.OperatorInstanceOf;
import com.ql.util.express.instruction.op.OperatorMinMax;
import com.ql.util.express.instruction.op.OperatorPrint;
import com.ql.util.express.instruction.op.OperatorPrintln;
import com.ql.util.express.instruction.op.OperatorRound;
import com.ql.util.express.instruction.op.OperatorSelfDefineClassFunction;
import com.ql.util.express.instruction.op.OperatorSelfDefineServiceFunction;
import com.ql.util.express.parse.AppendingClassFieldManager;
import com.ql.util.express.parse.AppendingClassMethodManager;
import com.ql.util.express.parse.ExpressNode;
import com.ql.util.express.parse.ExpressPackage;
import com.ql.util.express.parse.ExpressParse;
import com.ql.util.express.parse.NodeType;
import com.ql.util.express.parse.NodeTypeManager;
import com.ql.util.express.parse.Word;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class ExpressRunner {
    private static final String GLOBAL_DEFINE_NAME = "\u5168\u5c40\u5b9a\u4e49";
    private final boolean isTrace;
    private boolean isShortCircuit = true;
    private final boolean isPrecise;
    private final Map<String, Future<InstructionSet>> expressInstructionSetCache;
    private final ExpressLoader loader;
    private final IExpressResourceLoader expressResourceLoader;
    private final NodeTypeManager manager;
    private final OperatorFactory operatorManager;
    private final ExpressParse parse;
    final ExpressPackage rootExpressPackage = new ExpressPackage(null);
    private final ThreadLocal<Integer> threadReentrantCount = ThreadLocal.withInitial(() -> 0);
    private AppendingClassMethodManager appendingClassMethodManager;
    private AppendingClassFieldManager appendingClassFieldManager;
    private final ThreadLocal<IOperateDataCache> operateDataCacheThreadLocal = ThreadLocal.withInitial(() -> new OperateDataCacheImpl(30));

    public AppendingClassMethodManager getAppendingClassMethodManager() {
        return this.appendingClassMethodManager;
    }

    public AppendingClassFieldManager getAppendingClassFieldManager() {
        return this.appendingClassFieldManager;
    }

    public IOperateDataCache getOperateDataCache() {
        return this.operateDataCacheThreadLocal.get();
    }

    public ExpressRunner() {
        this(false, false);
    }

    public ExpressRunner(boolean isPrecise, boolean isTrace) {
        this(isPrecise, isTrace, new DefaultExpressResourceLoader(), null);
    }

    public ExpressRunner(boolean isPrecise, boolean isTrace, Map<String, Future<InstructionSet>> cacheMap) {
        this(isPrecise, isTrace, new DefaultExpressResourceLoader(), null, cacheMap);
    }

    public ExpressRunner(boolean isPrecise, boolean isStrace, NodeTypeManager nodeTypeManager) {
        this(isPrecise, isStrace, new DefaultExpressResourceLoader(), nodeTypeManager);
    }

    public ExpressRunner(boolean isPrecise, boolean isTrace, IExpressResourceLoader iExpressResourceLoader, NodeTypeManager nodeTypeManager) {
        this(isPrecise, isTrace, iExpressResourceLoader, nodeTypeManager, null);
    }

    public ExpressRunner(boolean isPrecise, boolean isTrace, IExpressResourceLoader iExpressResourceLoader, NodeTypeManager nodeTypeManager, Map<String, Future<InstructionSet>> cacheMap) {
        this.isTrace = isTrace;
        this.isPrecise = isPrecise;
        this.expressResourceLoader = iExpressResourceLoader;
        this.manager = nodeTypeManager == null ? new NodeTypeManager() : nodeTypeManager;
        this.expressInstructionSetCache = Objects.isNull(cacheMap) ? new ConcurrentHashMap<String, Future<InstructionSet>>() : cacheMap;
        this.operatorManager = new OperatorFactory(this.isPrecise);
        this.loader = new ExpressLoader(this);
        this.parse = new ExpressParse(this.manager, this.expressResourceLoader, this.isPrecise);
        this.rootExpressPackage.addPackage("java.lang");
        this.rootExpressPackage.addPackage("java.util");
        this.rootExpressPackage.addPackage("java.util.stream");
        this.addSystemFunctions();
        this.addSystemOperators();
    }

    private void addSystemOperators() {
        try {
            this.addOperator("instanceof", new OperatorInstanceOf("instanceof"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSystemFunctions() {
        this.addFunction("max", new OperatorMinMax("max"));
        this.addFunction("min", new OperatorMinMax("min"));
        this.addFunction("round", new OperatorRound("round"));
        this.addFunction("print", new OperatorPrint("print"));
        this.addFunction("println", new OperatorPrintln("println"));
    }

    public NodeTypeManager getNodeTypeManager() {
        return this.manager;
    }

    public OperatorFactory getOperatorFactory() {
        return this.operatorManager;
    }

    public IExpressResourceLoader getExpressResourceLoader() {
        return this.expressResourceLoader;
    }

    public void addMacro(String macroName, String express) throws Exception {
        String macroExpress = "macro " + macroName + " {" + express + "}";
        this.loader.parseInstructionSet(GLOBAL_DEFINE_NAME, macroExpress);
    }

    public void loadMultiExpress(String expressName, String express) throws Exception {
        if (expressName == null || expressName.trim().length() == 0) {
            expressName = GLOBAL_DEFINE_NAME;
        }
        this.loader.parseInstructionSet(expressName, express);
    }

    public void loadExpress(String expressName) throws Exception {
        this.loader.loadExpress(expressName);
    }

    public void addFunction(String name, OperatorBase op) {
        this.operatorManager.addOperator(name, op);
        this.manager.addFunctionName(name);
    }

    public void addFunctionAndClassMethod(String name, Class<?> bindingClass, OperatorBase op) {
        this.addFunction(name, op);
        this.addClassMethod(name, bindingClass, op);
    }

    public void addClassField(String field, Class<?> bindingClass, Operator op) {
        this.addClassField(field, bindingClass, Object.class, op);
    }

    public void addClassField(String field, Class<?> bindingClass, Class<?> returnType, Operator op) {
        if (this.appendingClassFieldManager == null) {
            this.appendingClassFieldManager = new AppendingClassFieldManager();
        }
        this.appendingClassFieldManager.addAppendingField(field, bindingClass, returnType, op);
    }

    public void addClassMethod(String name, Class<?> bindingClass, OperatorBase op) {
        if (this.appendingClassMethodManager == null) {
            this.appendingClassMethodManager = new AppendingClassMethodManager();
        }
        this.appendingClassMethodManager.addAppendingMethod(name, bindingClass, op);
    }

    public OperatorBase getFunction(String name) {
        return this.operatorManager.getOperator(name);
    }

    public void addFunctionOfClassMethod(String name, String className, String functionName, Class<?>[] parameterClassTypes, String errorInfo) throws Exception {
        OperatorSelfDefineClassFunction operatorSelfDefineClassFunction = new OperatorSelfDefineClassFunction(name, className, functionName, parameterClassTypes, null, null, errorInfo);
        this.addFunction(name, operatorSelfDefineClassFunction);
    }

    public void addFunctionOfClassMethod(String name, Class<?> clazz, String functionName, Class<?>[] parameterClassTypes, String errorInfo) throws Exception {
        OperatorSelfDefineClassFunction operatorSelfDefineClassFunction = new OperatorSelfDefineClassFunction(name, clazz, functionName, parameterClassTypes, null, null, errorInfo);
        this.addFunction(name, operatorSelfDefineClassFunction);
    }

    public void addFunctionOfClassMethod(String name, String className, String functionName, Class<?>[] parameterClassTypes, String[] parameterDesc, String[] parameterAnnotation, String errorInfo) throws Exception {
        OperatorSelfDefineClassFunction operatorSelfDefineClassFunction = new OperatorSelfDefineClassFunction(name, className, functionName, parameterClassTypes, parameterDesc, parameterAnnotation, errorInfo);
        this.addFunction(name, operatorSelfDefineClassFunction);
    }

    public void addFunctionOfClassMethod(String name, String className, String functionName, String[] parameterTypes, String errorInfo) throws Exception {
        OperatorSelfDefineClassFunction operatorSelfDefineClassFunction = new OperatorSelfDefineClassFunction(name, className, functionName, parameterTypes, null, null, errorInfo);
        this.addFunction(name, operatorSelfDefineClassFunction);
    }

    public void addFunctionOfClassMethod(String name, String className, String functionName, String[] parameterTypes, String[] parameterDesc, String[] parameterAnnotation, String errorInfo) throws Exception {
        OperatorSelfDefineClassFunction operatorSelfDefineClassFunction = new OperatorSelfDefineClassFunction(name, className, functionName, parameterTypes, parameterDesc, parameterAnnotation, errorInfo);
        this.addFunction(name, operatorSelfDefineClassFunction);
    }

    public void addFunctionOfServiceMethod(String name, Object serviceObject, String functionName, Class<?>[] parameterClassTypes, String errorInfo) throws Exception {
        OperatorSelfDefineServiceFunction operatorSelfDefineServiceFunction = new OperatorSelfDefineServiceFunction(name, serviceObject, functionName, parameterClassTypes, null, null, errorInfo);
        this.addFunction(name, operatorSelfDefineServiceFunction);
    }

    public void addFunctionOfServiceMethod(String name, Object serviceObject, String functionName, Class<?>[] parameterClassTypes, String[] parameterDesc, String[] parameterAnnotation, String errorInfo) throws Exception {
        OperatorSelfDefineServiceFunction operatorSelfDefineServiceFunction = new OperatorSelfDefineServiceFunction(name, serviceObject, functionName, parameterClassTypes, parameterDesc, parameterAnnotation, errorInfo);
        this.addFunction(name, operatorSelfDefineServiceFunction);
    }

    public void addFunctionOfServiceMethod(String name, Object serviceObject, String functionName, String[] parameterTypes, String errorInfo) throws Exception {
        OperatorSelfDefineServiceFunction operatorSelfDefineServiceFunction = new OperatorSelfDefineServiceFunction(name, serviceObject, functionName, parameterTypes, null, null, errorInfo);
        this.addFunction(name, operatorSelfDefineServiceFunction);
    }

    public void addFunctionOfServiceMethod(String name, Object serviceObject, String functionName, String[] parameterTypes, String[] parameterDesc, String[] parameterAnnotation, String errorInfo) throws Exception {
        OperatorSelfDefineServiceFunction operatorSelfDefineServiceFunction = new OperatorSelfDefineServiceFunction(name, serviceObject, functionName, parameterTypes, parameterDesc, parameterAnnotation, errorInfo);
        this.addFunction(name, operatorSelfDefineServiceFunction);
    }

    public void addOperator(String name, Operator operator) throws Exception {
        this.addOperator(name, "*", operator);
    }

    public void addOperator(String name, String refOperatorName, Operator operator) throws Exception {
        this.manager.addOperatorWithLevelOfReference(name, refOperatorName);
        this.operatorManager.addOperator(name, operator);
    }

    public void addOperatorWithAlias(String keyWordName, String realKeyWordName, String errorInfo) throws Exception {
        if (errorInfo != null && errorInfo.trim().length() == 0) {
            errorInfo = null;
        }
        if (this.manager.isFunction(realKeyWordName)) {
            this.manager.addFunctionName(keyWordName);
            this.operatorManager.addOperatorWithAlias(keyWordName, realKeyWordName, errorInfo);
            return;
        }
        NodeType realNodeType = this.manager.findNodeType(realKeyWordName);
        if (realNodeType == null) {
            throw new QLException("\u5173\u952e\u5b57\uff1a" + realKeyWordName + "\u4e0d\u5b58\u5728");
        }
        boolean isExist = this.operatorManager.isExistOperator(realNodeType.getName());
        if (!isExist && errorInfo != null) {
            throw new QLException("\u5173\u952e\u5b57\uff1a" + realKeyWordName + "\u662f\u901a\u8fc7\u6307\u4ee4\u6765\u5b9e\u73b0\u7684\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u9519\u8bef\u7684\u63d0\u793a\u4fe1\u606f\uff0cerrorInfo \u5fc5\u987b\u662f null");
        }
        if (!isExist || errorInfo == null) {
            this.manager.addOperatorWithRealNodeType(keyWordName, realNodeType.getName());
        } else {
            this.manager.addOperatorWithLevelOfReference(keyWordName, realNodeType.getName());
            this.operatorManager.addOperatorWithAlias(keyWordName, realNodeType.getName(), errorInfo);
        }
    }

    public OperatorBase replaceOperator(String name, OperatorBase op) {
        return this.operatorManager.replaceOperator(name, op);
    }

    public ExpressPackage getRootExpressPackage() {
        return this.rootExpressPackage;
    }

    public void clearExpressCache() {
        this.expressInstructionSetCache.clear();
    }

    public Object executeByExpressName(String name, IExpressContext<String, Object> context, List<String> errorList, boolean isTrace, boolean isCatchException) throws Exception {
        return InstructionSetRunner.executeOuter(this, this.loader.getInstructionSet(name), this.loader, context, errorList, isTrace, isCatchException, false, -1L);
    }

    public Object execute(InstructionSet instructionSet, IExpressContext<String, Object> context, List<String> errorList, boolean isTrace, boolean isCatchException) throws Exception {
        return this.executeReentrant(instructionSet, context, errorList, isTrace, isCatchException, -1L);
    }

    public Object execute(String expressString, IExpressContext<String, Object> context, List<String> errorList, boolean isCache, boolean isTrace, long timeoutMillis) throws Exception {
        return this.executeInner(expressString, context, errorList, isCache, isTrace, timeoutMillis);
    }

    public Object execute(String expressString, IExpressContext<String, Object> context, List<String> errorList, boolean isCache, boolean isTrace) throws Exception {
        return this.executeInner(expressString, context, errorList, isCache, isTrace, -1L);
    }

    private Object executeInner(String expressString, IExpressContext<String, Object> context, List<String> errorList, boolean isCache, boolean isTrace, long timeoutMillis) throws Exception {
        InstructionSet parseResult = isCache ? this.getInstructionSetFromLocalCache(expressString) : this.parseInstructionSet(expressString);
        return this.executeReentrant(parseResult, context, errorList, isTrace, false, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeReentrant(InstructionSet parseResult, IExpressContext<String, Object> context, List<String> errorList, boolean isTrace, boolean isCatchException, long timeoutMillis) throws Exception {
        try {
            int reentrantCount = this.threadReentrantCount.get() + 1;
            this.threadReentrantCount.set(reentrantCount);
            Object object = reentrantCount > 1 ? InstructionSetRunner.execute(this, parseResult, this.loader, context, errorList, isTrace, isCatchException, true, false, new ExecuteTimeout(timeoutMillis)) : InstructionSetRunner.executeOuter(this, parseResult, this.loader, context, errorList, isTrace, isCatchException, false, timeoutMillis);
            return object;
        }
        finally {
            this.threadReentrantCount.set(this.threadReentrantCount.get() - 1);
        }
    }

    public InstructionSet parseInstructionSet(String text) throws Exception {
        try {
            HashMap<String, String> selfDefineClass = new HashMap<String, String>();
            for (ExportItem item : this.loader.getExportInfo()) {
                if (!item.getType().equals("VClass")) continue;
                selfDefineClass.put(item.getName(), item.getName());
            }
            ExpressNode root = this.parse.parse(this.rootExpressPackage, text, this.isTrace, selfDefineClass);
            InstructionSet result = this.createInstructionSet(root, "main");
            if (this.isTrace) {
                System.out.println(result);
            }
            return result;
        }
        catch (QLCompileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QLCompileException("\u7f16\u8bd1\u5f02\u5e38:\n" + text, e);
        }
    }

    public ExportItem[] getExportInfo() {
        return this.loader.getExportInfo();
    }

    public InstructionSet getInstructionSetFromLocalCache(String expressString) throws Exception {
        FutureTask<InstructionSet> parseTask;
        FutureTask<InstructionSet> futureTask = this.expressInstructionSetCache.get(expressString);
        if (futureTask == null && (futureTask = (FutureTask<InstructionSet>)this.expressInstructionSetCache.putIfAbsent(expressString, parseTask = new FutureTask<InstructionSet>(() -> this.parseInstructionSet(expressString)))) == null) {
            futureTask = parseTask;
            parseTask.run();
        }
        try {
            return futureTask.get();
        }
        catch (Exception e) {
            Throwable originThrow = e.getCause();
            if (!(originThrow instanceof Exception)) {
                throw e;
            }
            throw (Exception)originThrow;
        }
    }

    public InstructionSet createInstructionSet(ExpressNode root, String type) throws Exception {
        InstructionSet result = new InstructionSet(type);
        this.createInstructionSet(root, result);
        return result;
    }

    public void createInstructionSet(ExpressNode root, InstructionSet result) throws Exception {
        Stack<ForRelBreakContinue> forStack = new Stack<ForRelBreakContinue>();
        this.createInstructionSetPrivate(result, forStack, root, true);
        if (!forStack.isEmpty()) {
            throw new QLCompileException("For\u5904\u7406\u9519\u8bef");
        }
    }

    public boolean createInstructionSetPrivate(InstructionSet result, Stack<ForRelBreakContinue> forStack, ExpressNode node, boolean isRoot) throws Exception {
        InstructionFactory factory = InstructionFactory.getInstructionFactory(node.getInstructionFactory());
        return factory.createInstruction(this, result, forStack, node, isRoot);
    }

    public String[] getOutVarNames(String express) throws Exception {
        return this.parseInstructionSet(express).getOutAttrNames();
    }

    public String[] getOutFunctionNames(String express) throws Exception {
        return this.parseInstructionSet(express).getOutFunctionNames();
    }

    public boolean isShortCircuit() {
        return this.isShortCircuit;
    }

    public void setShortCircuit(boolean isShortCircuit) {
        this.isShortCircuit = isShortCircuit;
    }

    public boolean isIgnoreConstChar() {
        return this.parse.isIgnoreConstChar();
    }

    public void setIgnoreConstChar(boolean ignoreConstChar) {
        this.parse.setIgnoreConstChar(ignoreConstChar);
    }

    public boolean checkSyntax(String text) {
        return this.checkSyntax(text, false, null);
    }

    public boolean checkSyntax(String text, boolean mockRemoteJavaClass, List<String> remoteJavaClassNames) {
        try {
            HashMap<String, String> selfDefineClass = new HashMap<String, String>();
            for (ExportItem item : this.loader.getExportInfo()) {
                if (!item.getType().equals("VClass")) continue;
                selfDefineClass.put(item.getName(), item.getName());
            }
            Word[] words = this.parse.splitWords(text, this.isTrace, selfDefineClass);
            ExpressNode root = this.parse.parse(this.rootExpressPackage, words, text, this.isTrace, selfDefineClass, mockRemoteJavaClass);
            InstructionSet result = this.createInstructionSet(root, "main");
            if (this.isTrace) {
                System.out.println(result);
            }
            if (mockRemoteJavaClass && remoteJavaClassNames != null) {
                remoteJavaClassNames.addAll(Arrays.asList(result.getVirClasses()));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

